/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.sql.Date;
import java.text.SimpleDateFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.experimental.module.OverlayShaderModule;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class CameraModule
extends QuarkModule {
    private static final int RULER_COLOR = 0x33000000;
    private static final int RULERS = 4;
    private static final int BORERS = 6;
    private static final int OVERLAYS = 5;
    private static final ResourceLocation[] SHADERS = new ResourceLocation[]{null, new ResourceLocation("quark", "shaders/post/grayscale.json"), new ResourceLocation("quark", "shaders/post/sepia.json"), new ResourceLocation("quark", "shaders/post/desaturate.json"), new ResourceLocation("quark", "shaders/post/oversaturate.json"), new ResourceLocation("quark", "shaders/post/cool.json"), new ResourceLocation("quark", "shaders/post/warm.json"), new ResourceLocation("quark", "shaders/post/conjugate.json"), new ResourceLocation("quark", "shaders/post/redfocus.json"), new ResourceLocation("quark", "shaders/post/greenfocus.json"), new ResourceLocation("quark", "shaders/post/bluefocus.json"), new ResourceLocation("quark", "shaders/post/yellowfocus.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("quark", "shaders/post/enderman.json"), new ResourceLocation("quark", "shaders/post/bits.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("quark", "shaders/post/watercolor.json"), new ResourceLocation("quark", "shaders/post/monochrome.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("quark", "shaders/post/colorblind/deuteranopia.json"), new ResourceLocation("quark", "shaders/post/colorblind/protanopia.json"), new ResourceLocation("quark", "shaders/post/colorblind/tritanopia.json"), new ResourceLocation("quark", "shaders/post/colorblind/achromatopsia.json")};
    @OnlyIn(value=Dist.CLIENT)
    private static KeyMapping cameraModeKey;
    private static int currentHeldItem;
    private static int currShader;
    private static int currRulers;
    private static int currBorders;
    private static int currOverlay;
    private static boolean queuedRefresh;
    private static boolean queueScreenshot;
    private static boolean screenshotting;
    private static boolean cameraMode;

    @Override
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        cameraModeKey = ModKeybindHandler.init(event, "camera_mode", "f12", "quark.gui.keygroup.misc");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void screenshotTaken(ScreenshotEvent event) {
        screenshotting = false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keystroke(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null && event.getAction() == 1) {
            if (cameraModeKey.m_90857_()) {
                cameraMode = !cameraMode;
                queuedRefresh = true;
                return;
            }
            if (cameraMode && mc.f_91080_ == null) {
                int key = event.getKey();
                boolean affected = false;
                boolean sneak = mc.f_91074_.m_20163_();
                switch (key) {
                    case 49: {
                        currShader = CameraModule.cycle(currShader, SHADERS.length, sneak);
                        affected = true;
                        break;
                    }
                    case 50: {
                        currRulers = CameraModule.cycle(currRulers, 4, sneak);
                        affected = true;
                        break;
                    }
                    case 51: {
                        currBorders = CameraModule.cycle(currBorders, 6, sneak);
                        affected = true;
                        break;
                    }
                    case 52: {
                        currOverlay = CameraModule.cycle(currOverlay, 5, sneak);
                        affected = true;
                        break;
                    }
                    case 53: {
                        if (!sneak) break;
                        currShader = 0;
                        currRulers = 0;
                        currBorders = 0;
                        currOverlay = 0;
                        affected = true;
                        break;
                    }
                    case 257: {
                        if (!queueScreenshot && !screenshotting) {
                            mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)QuarkSounds.ITEM_CAMERA_SHUTTER, (float)1.0f));
                        }
                        queueScreenshot = true;
                    }
                }
                if (affected) {
                    queuedRefresh = true;
                    currentHeldItem = mc.f_91074_.m_150109_().f_35977_;
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null) {
            Inventory inventory = player.m_150109_();
            if (currentHeldItem != -1 && inventory.f_35977_ != currentHeldItem) {
                inventory.f_35977_ = currentHeldItem;
                currentHeldItem = -1;
            }
        }
        if (mc.f_91073_ == null) {
            cameraMode = false;
            queuedRefresh = true;
        } else if (queuedRefresh) {
            CameraModule.refreshShader();
        }
        if (event.phase == TickEvent.Phase.END && cameraMode && mc.f_91080_ == null) {
            if (queueScreenshot) {
                screenshotting = true;
            }
            PoseStack stack = new PoseStack();
            CameraModule.renderCameraHUD(mc, stack);
            if (queueScreenshot) {
                queueScreenshot = false;
                Screenshot.m_92289_((File)mc.f_91069_, (RenderTarget)mc.m_91385_(), msg -> mc.execute(() -> mc.f_91065_.m_93076_().m_93785_(msg)));
            }
        }
    }

    private static void renderCameraHUD(Minecraft mc, PoseStack matrix) {
        Window mw = mc.m_91268_();
        int twidth = mw.m_85445_();
        int theight = mw.m_85446_();
        int width = twidth;
        int height = theight;
        int paddingHoriz = 0;
        int paddingVert = 0;
        int paddingColor = -16777216;
        double targetAspect = -1.0;
        switch (currBorders) {
            case 1: {
                targetAspect = 1.0;
                break;
            }
            case 2: {
                targetAspect = 1.3333333333333333;
                break;
            }
            case 3: {
                targetAspect = 1.7777777777777777;
                break;
            }
            case 4: {
                targetAspect = 2.3333333333333335;
                break;
            }
            case 5: {
                int border;
                paddingHoriz = border = (int)(20.0 * ((double)(twidth * theight) / 518400.0));
                paddingVert = border;
                paddingColor = -1;
            }
        }
        if (targetAspect > 0.0) {
            double currAspect = (double)width / (double)height;
            if (currAspect > targetAspect) {
                int desiredWidth = (int)((double)height * targetAspect);
                paddingHoriz = (width - desiredWidth) / 2;
            } else if (currAspect < targetAspect) {
                int desiredHeight = (int)((double)width / targetAspect);
                paddingVert = (height - desiredHeight) / 2;
            }
        }
        width -= paddingHoriz * 2;
        height -= paddingVert * 2;
        if (paddingHoriz > 0) {
            Screen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)paddingHoriz, (int)theight, (int)paddingColor);
            Screen.m_93172_((PoseStack)matrix, (int)(twidth - paddingHoriz), (int)0, (int)twidth, (int)theight, (int)paddingColor);
        }
        if (paddingVert > 0) {
            Screen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)twidth, (int)paddingVert, (int)paddingColor);
            Screen.m_93172_((PoseStack)matrix, (int)0, (int)(theight - paddingVert), (int)twidth, (int)theight, (int)paddingColor);
        }
        String overlayText = "";
        boolean overlayShadow = true;
        double overlayScale = 2.0;
        int overlayColor = -1;
        int overlayX = -1;
        int overlayY = -1;
        switch (currOverlay) {
            case 1: {
                overlayText = new SimpleDateFormat("MM/dd/yyyy").format(new Date(System.currentTimeMillis()));
                overlayColor = 0xF77700;
                break;
            }
            case 2: {
                String worldName = "N/A";
                if (mc.m_91092_() != null) {
                    worldName = mc.m_91092_().m_7326_();
                } else if (mc.m_91089_() != null) {
                    worldName = mc.m_91089_().f_105362_;
                }
                overlayText = I18n.m_118938_((String)"quark.camera.greetings", (Object[])new Object[]{worldName});
                overlayX = paddingHoriz + 20;
                overlayY = paddingVert + 20;
                overlayScale = 3.0;
                overlayColor = 15684645;
                break;
            }
            case 3: {
                overlayText = mc.f_91074_.m_36316_().getName();
                overlayScale = 6.0;
                overlayShadow = false;
                overlayColor = 0x44000000;
                break;
            }
            case 4: {
                overlayText = mc.f_91074_.m_21205_().m_41786_().getString();
                overlayX = twidth / 2 - mc.f_91062_.m_92895_(overlayText);
                overlayY = paddingVert + 40;
            }
        }
        if (overlayX == -1) {
            overlayX = twidth - paddingHoriz - mc.f_91062_.m_92895_(overlayText) * (int)overlayScale - 40;
        }
        if (overlayY == -1) {
            overlayY = theight - paddingVert - 10 - 10 * (int)overlayScale;
        }
        if (!overlayText.isEmpty()) {
            matrix.m_85836_();
            matrix.m_85837_((double)overlayX, (double)overlayY, 0.0);
            matrix.m_85841_((float)overlayScale, (float)overlayScale, 1.0f);
            if (overlayShadow) {
                mc.f_91062_.m_92750_(matrix, overlayText, 0.0f, 0.0f, overlayColor);
            } else {
                mc.f_91062_.m_92883_(matrix, overlayText, 0.0f, 0.0f, overlayColor);
            }
            matrix.m_85849_();
        }
        if (!screenshotting) {
            matrix.m_85836_();
            matrix.m_85837_((double)paddingHoriz, (double)paddingVert, 0.0);
            switch (currRulers) {
                case 1: {
                    CameraModule.vruler(matrix, width / 3, height);
                    CameraModule.vruler(matrix, width / 3 * 2, height);
                    CameraModule.hruler(matrix, height / 3, width);
                    CameraModule.hruler(matrix, height / 3 * 2, width);
                    break;
                }
                case 2: {
                    double phi1 = 0.3831417624521073;
                    double phi2 = 0.6168582375478928;
                    CameraModule.vruler(matrix, (int)((double)width * phi1), height);
                    CameraModule.vruler(matrix, (int)((double)width * phi2), height);
                    CameraModule.hruler(matrix, (int)((double)height * phi1), width);
                    CameraModule.hruler(matrix, (int)((double)height * phi2), width);
                    break;
                }
                case 3: {
                    CameraModule.vruler(matrix, width / 2, height);
                    CameraModule.hruler(matrix, height / 2, width);
                }
            }
            matrix.m_85849_();
            int left = 30;
            int top = theight - 65;
            ResourceLocation shader = SHADERS[currShader];
            Object text = "none";
            if (shader != null) {
                text = shader.m_135815_().replaceAll(".+/(.+)\\.json", "$1");
            }
            text = ChatFormatting.BOLD + "[1] " + ChatFormatting.RESET + I18n.m_118938_((String)"quark.camera.filter", (Object[])new Object[0]) + ChatFormatting.GOLD + I18n.m_118938_((String)("quark.camera.filter." + (String)text), (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)left, (float)top, 0xFFFFFF);
            text = ChatFormatting.BOLD + "[2] " + ChatFormatting.RESET + I18n.m_118938_((String)"quark.camera.rulers", (Object[])new Object[0]) + ChatFormatting.GOLD + I18n.m_118938_((String)("quark.camera.rulers" + currRulers), (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)left, (float)(top + 12), 0xFFFFFF);
            text = ChatFormatting.BOLD + "[3] " + ChatFormatting.RESET + I18n.m_118938_((String)"quark.camera.borders", (Object[])new Object[0]) + ChatFormatting.GOLD + I18n.m_118938_((String)("quark.camera.borders" + currBorders), (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)left, (float)(top + 24), 0xFFFFFF);
            text = ChatFormatting.BOLD + "[4] " + ChatFormatting.RESET + I18n.m_118938_((String)"quark.camera.overlay", (Object[])new Object[0]) + ChatFormatting.GOLD + I18n.m_118938_((String)("quark.camera.overlay" + currOverlay), (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)left, (float)(top + 36), 0xFFFFFF);
            text = ChatFormatting.BOLD + "[5] " + ChatFormatting.RESET + I18n.m_118938_((String)"quark.camera.reset", (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)left, (float)(top + 48), 0xFFFFFF);
            text = ChatFormatting.AQUA + I18n.m_118938_((String)"quark.camera.header", (Object[])new Object[0]);
            mc.f_91062_.m_92750_(matrix, (String)text, (float)(twidth / 2 - mc.f_91062_.m_92895_((String)text) / 2), 6.0f, 0xFFFFFF);
            text = I18n.m_118938_((String)"quark.camera.info", (Object[])new Object[]{Component.m_237117_((String)"quark.keybind.camera_mode").getString()});
            mc.f_91062_.m_92750_(matrix, (String)text, (float)(twidth / 2 - mc.f_91062_.m_92895_((String)text) / 2), 16.0f, 0xFFFFFF);
            ResourceLocation CAMERA_TEXTURE = new ResourceLocation("quark", "textures/misc/camera.png");
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CAMERA_TEXTURE);
            Screen.m_93143_((PoseStack)matrix, (int)(left - 22), (int)(top + 18), (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    private static void refreshShader() {
        if (queuedRefresh) {
            queuedRefresh = false;
        }
        Minecraft mc = Minecraft.m_91087_();
        GameRenderer render = mc.f_91063_;
        mc.f_91066_.f_92062_ = cameraMode;
        if (cameraMode) {
            ResourceLocation shader = SHADERS[currShader];
            if (shader != null) {
                render.m_109128_(shader);
                return;
            }
        } else if (ModuleLoader.INSTANCE.isModuleEnabled(OverlayShaderModule.class)) {
            for (ResourceLocation l : SHADERS) {
                if (l == null || !l.m_135815_().contains(OverlayShaderModule.shader + ".json")) continue;
                render.m_109128_(l);
                return;
            }
        }
        render.m_109106_(null);
    }

    private static void vruler(PoseStack matrix, int x, int height) {
        Screen.m_93172_((PoseStack)matrix, (int)x, (int)0, (int)(x + 1), (int)height, (int)0x33000000);
    }

    private static void hruler(PoseStack matrix, int y, int width) {
        Screen.m_93172_((PoseStack)matrix, (int)0, (int)y, (int)width, (int)(y + 1), (int)0x33000000);
    }

    private static int cycle(int curr, int max, boolean neg) {
        int val = curr + (neg ? -1 : 1);
        if (val < 0) {
            val = max - 1;
        } else if (val >= max) {
            val = 0;
        }
        return val;
    }

    static {
        currentHeldItem = -1;
        currShader = 0;
        currRulers = 0;
        currBorders = 0;
        currOverlay = 0;
        queuedRefresh = false;
        queueScreenshot = false;
        screenshotting = false;
    }
}

