/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.util.VanillaWoods;
import vazkii.quark.content.building.block.HollowLogBlock;
import vazkii.quark.content.building.block.HollowPillarBlock;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class HollowLogsModule
extends QuarkModule {
    private static final String TAG_TRYING_TO_CRAWL = "quark:trying_crawl";
    public static QuarkGenericTrigger crawlTrigger;
    @Config
    public static boolean enableAutoCrawl;

    @Override
    public void register() {
        for (VanillaWoods.Wood wood : VanillaWoods.ALL) {
            new HollowLogBlock(wood.log(), this, !wood.nether());
        }
        crawlTrigger = QuarkAdvancementHandler.registerGenericTrigger("hollow_log_crawl");
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (enableAutoCrawl && event.phase == TickEvent.Phase.START) {
            BlockPos pos;
            Direction dir;
            Player player = event.player;
            BlockPos playerPos = player.m_20183_();
            boolean isTrying = player.m_6047_() && !player.m_6069_() && player.f_19853_.m_8055_(playerPos).m_60812_((BlockGetter)player.f_19853_, playerPos).m_83281_();
            boolean wasTrying = player.getPersistentData().m_128471_(TAG_TRYING_TO_CRAWL);
            if (isTrying && !wasTrying && !this.tryClimb(player, dir = player.m_6350_(), pos = playerPos.m_121945_(dir))) {
                this.tryClimb(player, dir, pos.m_7494_());
            }
            if (isTrying != wasTrying) {
                player.getPersistentData().m_128379_(TAG_TRYING_TO_CRAWL, isTrying);
            }
        }
    }

    private boolean tryClimb(Player player, Direction dir, BlockPos pos) {
        Direction.Axis axis;
        BlockState state = player.f_19853_.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof HollowPillarBlock && (axis = (Direction.Axis)state.m_61143_((Property)HollowPillarBlock.f_55923_)) != Direction.Axis.Y && axis == dir.m_122434_()) {
            player.m_20124_(Pose.SWIMMING);
            player.m_20282_(true);
            double x = (double)pos.m_123341_() + 0.5 - (double)dir.m_122429_() * 0.4;
            double y = (double)pos.m_123342_() + 0.13;
            double z = (double)pos.m_123343_() + 0.5 - (double)dir.m_122431_() * 0.4;
            player.m_6034_(x, y, z);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                crawlTrigger.trigger(sp);
            }
            return true;
        }
        return false;
    }

    static {
        enableAutoCrawl = true;
    }
}

