/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.text.WordUtils;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.ConfigObjectSerializer;
import vazkii.quark.base.module.config.IConfigBuilder;
import vazkii.quark.base.module.config.IConfigCallback;
import vazkii.quark.base.module.config.QuarkConfigBuilder;

public class ConfigResolver {
    private static final Method SET_CONFIG_DATA = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
    private static final Method SETUP_CONFIG_FILE = ObfuscationReflectionHelper.findMethod(ConfigFileTypeHandler.class, (String)"setupConfigFile", (Class[])new Class[]{ModConfig.class, Path.class, ConfigFormat.class});
    private final ConfigFlagManager flagManager;
    private List<Runnable> refreshRunnables = new LinkedList<Runnable>();
    private ModConfig config;

    public ConfigResolver() {
        this.flagManager = new ConfigFlagManager();
    }

    public ModConfig getConfig() {
        return this.config;
    }

    public void registerConfigBoundElements() {
        this.flagManager.registerConfigBoundElements();
    }

    public void makeSpec() {
        ForgeConfigSpec.Builder forgeBuilder = new ForgeConfigSpec.Builder();
        IConfigCallback callback = Quark.proxy.getConfigCallback();
        QuarkConfigBuilder builder = new QuarkConfigBuilder(forgeBuilder, callback);
        ForgeConfigSpec spec = builder.configure(this::build);
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        this.config = new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, container);
        container.addConfig(this.config);
        this.loadFromFile(this.config, container);
    }

    private void loadFromFile(ModConfig modConfig, ModContainer container) {
        ConfigFileTypeHandler handler = modConfig.getHandler();
        CommentedFileConfig configData = this.readConfig(handler, FMLPaths.CONFIGDIR.get(), modConfig);
        SET_CONFIG_DATA.setAccessible(true);
        try {
            SET_CONFIG_DATA.invoke((Object)modConfig, configData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.configChanged();
        modConfig.save();
    }

    private CommentedFileConfig readConfig(ConfigFileTypeHandler handler, Path configBasePath, ModConfig c) {
        Path configPath = configBasePath.resolve(c.getFileName());
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((newfile, configFormat) -> {
            try {
                return (Boolean)SETUP_CONFIG_FILE.invoke((Object)handler, c, newfile, configFormat);
            }
            catch (Exception e) {
                throw new ConfigLoadingException(c, e);
            }
        }).writingMode(WritingMode.REPLACE).build();
        try {
            configData.load();
        }
        catch (Exception ex) {
            throw new ConfigLoadingException(c, ex);
        }
        return configData;
    }

    public void configChanged() {
        this.flagManager.clear();
        this.refreshRunnables.forEach(Runnable::run);
    }

    private Void build(IConfigBuilder builder) {
        builder.push("general", null);
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, GeneralConfig.INSTANCE);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create quark general config", e);
        }
        builder.pop();
        builder.push("categories", null);
        this.buildCategoryList(builder);
        builder.pop();
        for (ModuleCategory category : ModuleCategory.values()) {
            this.buildCategory(builder, category);
        }
        return null;
    }

    private void buildCategoryList(IConfigBuilder builder) {
        for (ModuleCategory category : ModuleCategory.values()) {
            ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool(WordUtils.capitalizeFully((String)category.name), () -> category.enabled, true);
            this.refreshRunnables.add(() -> {
                category.enabled = (Boolean)value.get();
            });
        }
    }

    private void buildCategory(IConfigBuilder builder, ModuleCategory category) {
        builder.push(category.name, (Object)category);
        List<QuarkModule> modules = category.getOwnedModules();
        HashMap<QuarkModule, Runnable> setEnabledRunnables = new HashMap<QuarkModule, Runnable>();
        for (QuarkModule module : modules) {
            ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool(module.displayName, () -> module.configEnabled, module.enabledByDefault);
            setEnabledRunnables.put(module, () -> {
                module.setEnabled((Boolean)value.get() != false && category.enabled);
                this.flagManager.putEnabledFlag(module);
            });
        }
        for (QuarkModule module : modules) {
            this.buildModule(builder, module, (Runnable)setEnabledRunnables.get(module));
        }
        builder.pop();
    }

    private void buildModule(IConfigBuilder builder, QuarkModule module, Runnable setEnabled) {
        if (!module.description.isEmpty()) {
            builder.comment(module.description);
        }
        builder.push(module.lowercaseName, module);
        if (module.antiOverlap != null && module.antiOverlap.size() > 0) {
            this.addModuleAntiOverlap(builder, module);
        }
        this.refreshRunnables.add(setEnabled);
        try {
            ConfigObjectSerializer.serialize(builder, this.flagManager, this.refreshRunnables, module);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create config spec for module " + module.displayName, e);
        }
        this.refreshRunnables.add(() -> module.pushFlags(this.flagManager));
        builder.pop();
    }

    private void addModuleAntiOverlap(IConfigBuilder builder, QuarkModule module) {
        StringBuilder desc = new StringBuilder("This feature disables itself if any of the following mods are loaded: \n");
        for (String s : module.antiOverlap) {
            desc.append(" - ").append(s).append("\n");
        }
        desc.append("This is done to prevent content overlap.\nYou can turn this on to force the feature to be loaded even if the above mods are also loaded.");
        String descStr = desc.toString();
        builder.comment(descStr);
        ForgeConfigSpec.ConfigValue<Boolean> value = builder.defineBool("Ignore Anti Overlap", () -> module.ignoreAntiOverlap, false);
        this.refreshRunnables.add(() -> {
            module.ignoreAntiOverlap = !GeneralConfig.useAntiOverlap || (Boolean)value.get() != false;
        });
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }
}

