/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block.be;

import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import vazkii.arl.block.be.SimpleInventoryBlockEntity;
import vazkii.quark.addons.oddities.block.pipe.BasePipeBlock;
import vazkii.quark.addons.oddities.module.PipesModule;
import vazkii.quark.base.client.handler.NetworkProfilingHandler;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;

public class PipeBlockEntity
extends SimpleInventoryBlockEntity {
    private static final String TAG_PIPE_ITEMS = "pipeItems";
    private static final String TAG_CONNECTIONS = "connections";
    private boolean iterating = false;
    public final List<PipeItem> pipeItems = new LinkedList<PipeItem>();
    public final List<PipeItem> queuedItems = new LinkedList<PipeItem>();
    private boolean skipSync = false;
    private final ConnectionType[] connectionsCache = new ConnectionType[6];
    private boolean convert = false;

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(PipesModule.blockEntityType, pos, state);
    }

    public static boolean isTheGoodDay(Level world) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PipeBlockEntity be) {
        be.tick();
    }

    public void tick() {
        Direction[] directionArray;
        boolean enabled;
        if (this.convert) {
            this.convert = false;
            this.refreshAllConnections();
        }
        if (!(enabled = this.isPipeEnabled()) && this.f_58857_.m_46467_() % 10L == 0L && (directionArray = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 3, 0.2, 0.2, 0.2, 0.0);
        }
        BlockState blockAt = this.f_58857_.m_8055_(this.f_58858_);
        if (!this.f_58857_.f_46443_ && enabled && blockAt.m_204336_(PipesModule.pipesTag)) {
            for (Direction side : Direction.values()) {
                if (this.connectionsCache[side.ordinal()] != ConnectionType.OPENING) continue;
                double minX = (double)this.f_58858_.m_123341_() + 0.25 + 0.5 * (double)Math.min(0, side.m_122429_());
                double minY = (double)this.f_58858_.m_123342_() + 0.25 + 0.5 * (double)Math.min(0, side.m_122430_());
                double minZ = (double)this.f_58858_.m_123343_() + 0.25 + 0.5 * (double)Math.min(0, side.m_122431_());
                double maxX = (double)this.f_58858_.m_123341_() + 0.75 + 0.5 * (double)Math.max(0, side.m_122429_());
                double maxY = (double)this.f_58858_.m_123342_() + 0.75 + 0.5 * (double)Math.max(0, side.m_122430_());
                double maxZ = (double)this.f_58858_.m_123343_() + 0.75 + 0.5 * (double)Math.max(0, side.m_122431_());
                Direction opposite = side.m_122424_();
                boolean pickedItemsUp = false;
                Predicate<ItemEntity> predicate = entity -> {
                    if (entity == null || !entity.m_6084_()) {
                        return false;
                    }
                    Vec3 motion = entity.m_20184_();
                    Direction dir = Direction.m_122366_((double)motion.f_82479_, (double)motion.f_82480_, (double)motion.f_82481_);
                    return dir == opposite;
                };
                for (ItemEntity item : this.f_58857_.m_6443_(ItemEntity.class, new AABB(minX, minY, minZ, maxX, maxY, maxZ), predicate)) {
                    this.passIn(item.m_32055_().m_41777_(), side);
                    if (PipesModule.doPipesWhoosh) {
                        if (PipeBlockEntity.isTheGoodDay(this.f_58857_)) {
                            this.f_58857_.m_6263_(null, item.m_20185_(), item.m_20186_(), item.m_20189_(), QuarkSounds.BLOCK_PIPE_PICKUP_LENNY, SoundSource.BLOCKS, 1.0f, 1.0f);
                        } else {
                            this.f_58857_.m_6263_(null, item.m_20185_(), item.m_20186_(), item.m_20189_(), QuarkSounds.BLOCK_PIPE_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    if (PipesModule.emitVibrations) {
                        this.m_58904_().m_220407_(GameEvent.f_157777_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
                    }
                    pickedItemsUp = true;
                    item.m_146870_();
                }
                if (!pickedItemsUp) continue;
                this.sync();
            }
        }
        int currentOut = this.getComparatorOutput();
        if (!this.pipeItems.isEmpty()) {
            if (PipesModule.maxPipeItems > 0 && this.pipeItems.size() > PipesModule.maxPipeItems && !this.f_58857_.f_46443_) {
                this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)this.f_58857_.m_8055_(this.f_58858_)));
                this.dropItem(new ItemStack((ItemLike)this.m_58900_().m_60734_()));
                this.f_58857_.m_7471_(this.m_58899_(), false);
            }
            ListIterator<PipeItem> itemItr = this.pipeItems.listIterator();
            this.iterating = true;
            while (itemItr.hasNext()) {
                PipeItem item = itemItr.next();
                Direction lastFacing = item.outgoingFace;
                if (!item.tick(this)) continue;
                itemItr.remove();
                if (item.valid) {
                    this.passOut(item);
                    continue;
                }
                if (this.f_58857_.f_46443_) continue;
                this.dropItem(item.stack, lastFacing, true);
            }
            this.iterating = false;
            this.pipeItems.addAll(this.queuedItems);
            if (!this.queuedItems.isEmpty()) {
                this.sync();
            }
            this.queuedItems.clear();
        }
        if (this.getComparatorOutput() != currentOut) {
            this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    public int getComparatorOutput() {
        return Math.min(15, this.pipeItems.size());
    }

    public Iterator<PipeItem> getItemIterator() {
        return this.pipeItems.iterator();
    }

    public boolean allowsFullConnection(ConnectionType conn) {
        BasePipeBlock pipe;
        Block block = this.f_58856_.m_60734_();
        return block instanceof BasePipeBlock && (pipe = (BasePipeBlock)block).allowsFullConnection(conn);
    }

    public boolean passIn(ItemStack stack, Direction face, Direction backlog, long seed, int time) {
        PipeItem item = new PipeItem(stack, face, seed);
        item.backloggedFace = backlog;
        if (!this.iterating) {
            int currentOut = this.getComparatorOutput();
            this.pipeItems.add(item);
            item.timeInWorld = time;
            if (this.getComparatorOutput() != currentOut) {
                this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            }
        } else {
            this.queuedItems.add(item);
        }
        return true;
    }

    public boolean passIn(ItemStack stack, Direction face) {
        return this.passIn(stack, face, null, this.f_58857_.f_46441_.m_188505_(), 0);
    }

    protected void passOut(PipeItem item) {
        boolean did = false;
        BlockPos targetPos = this.m_58899_().m_121945_(item.outgoingFace);
        if (this.f_58857_.m_8055_(targetPos).m_60734_() instanceof WorldlyContainerHolder) {
            ItemStack result = MiscUtil.putIntoInv(item.stack, (LevelAccessor)this.f_58857_, targetPos, null, item.outgoingFace.m_122424_(), false, false);
            if (result.m_41613_() != item.stack.m_41613_()) {
                did = true;
                if (!result.m_41619_()) {
                    this.bounceBack(item, result);
                }
            }
        } else {
            BlockEntity tile = this.f_58857_.m_7702_(targetPos);
            if (tile != null) {
                ItemStack result;
                if (tile instanceof PipeBlockEntity) {
                    PipeBlockEntity pipe = (PipeBlockEntity)tile;
                    did = pipe.passIn(item.stack, item.outgoingFace.m_122424_(), null, item.rngSeed, item.timeInWorld);
                } else if (!this.f_58857_.f_46443_ && (result = MiscUtil.putIntoInv(item.stack, (LevelAccessor)this.f_58857_, targetPos, tile, item.outgoingFace.m_122424_(), false, false)).m_41613_() != item.stack.m_41613_()) {
                    did = true;
                    if (!result.m_41619_()) {
                        this.bounceBack(item, result);
                    }
                }
            }
        }
        if (!did) {
            this.bounceBack(item, null);
        }
    }

    private void bounceBack(PipeItem item, ItemStack stack) {
        if (!this.f_58857_.f_46443_) {
            this.passIn(stack == null ? item.stack : stack, item.outgoingFace, item.incomingFace, item.rngSeed, item.timeInWorld);
        }
    }

    public void dropItem(ItemStack stack) {
        this.dropItem(stack, null, false);
    }

    public void dropItem(ItemStack stack, Direction facing, boolean playSound) {
        if (!this.f_58857_.f_46443_) {
            double posX = (double)this.f_58858_.m_123341_() + 0.5;
            double posY = (double)this.f_58858_.m_123342_() + 0.25;
            double posZ = (double)this.f_58858_.m_123343_() + 0.5;
            if (facing != null) {
                double shift = this.allowsFullConnection(ConnectionType.OPENING) ? 0.7 : 0.4;
                posX -= (double)facing.m_122429_() * shift;
                posY -= (double)facing.m_122430_() * (shift + 0.15);
                posZ -= (double)facing.m_122431_() * shift;
            }
            boolean shootOut = this.isPipeEnabled();
            float pitch = 1.0f;
            if (!shootOut) {
                pitch = 0.025f;
            }
            if (playSound) {
                if (PipesModule.doPipesWhoosh) {
                    if (PipeBlockEntity.isTheGoodDay(this.f_58857_)) {
                        this.f_58857_.m_6263_(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT_LENNY, SoundSource.BLOCKS, 1.0f, pitch);
                    } else {
                        this.f_58857_.m_6263_(null, posX, posY, posZ, QuarkSounds.BLOCK_PIPE_SHOOT, SoundSource.BLOCKS, 1.0f, pitch);
                    }
                }
                if (PipesModule.emitVibrations) {
                    this.m_58904_().m_220407_(GameEvent.f_157778_, this.m_58899_(), GameEvent.Context.m_223722_((BlockState)this.m_58900_()));
                }
            }
            ItemEntity entity = new ItemEntity(this.f_58857_, posX, posY, posZ, stack);
            entity.m_32060_();
            double velocityMod = 0.5;
            if (!shootOut) {
                velocityMod = 0.125;
            }
            if (facing != null) {
                double mx = (double)(-facing.m_122429_()) * velocityMod;
                double my = (double)(-facing.m_122430_()) * velocityMod;
                double mz = (double)(-facing.m_122431_()) * velocityMod;
                entity.m_20334_(mx, my, mz);
            }
            this.f_58857_.m_7967_((Entity)entity);
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        NetworkProfilingHandler.receive("pipe");
    }

    public void dropAllItems() {
        for (PipeItem item : this.pipeItems) {
            this.dropItem(item.stack);
        }
        this.pipeItems.clear();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void readSharedNBT(CompoundTag cmp) {
        this.skipSync = true;
        super.readSharedNBT(cmp);
        this.skipSync = false;
        ListTag pipeItemList = cmp.m_128437_(TAG_PIPE_ITEMS, (int)cmp.m_7060_());
        this.pipeItems.clear();
        pipeItemList.forEach(listCmp -> {
            PipeItem item = PipeItem.readFromNBT((CompoundTag)listCmp);
            this.pipeItems.add(item);
        });
        if (cmp.m_128441_(TAG_CONNECTIONS)) {
            byte[] c = cmp.m_128463_(TAG_CONNECTIONS);
            for (int i = 0; i < c.length; ++i) {
                this.connectionsCache[i] = ConnectionType.values()[c[i]];
            }
        }
    }

    public void writeSharedNBT(CompoundTag cmp) {
        super.writeSharedNBT(cmp);
        ListTag pipeItemList = new ListTag();
        for (PipeItem item : this.pipeItems) {
            CompoundTag listCmp = new CompoundTag();
            item.writeToNBT(listCmp);
            pipeItemList.add((Object)listCmp);
        }
        cmp.m_128365_(TAG_PIPE_ITEMS, (Tag)pipeItemList);
        for (int i = 0; i < this.connectionsCache.length; ++i) {
            if (this.connectionsCache[i] != null) continue;
            this.connectionsCache[i] = ConnectionType.NONE;
            this.convert = true;
        }
        cmp.m_177853_(TAG_CONNECTIONS, Arrays.stream(this.connectionsCache).map(c -> (byte)c.ordinal()).toList());
    }

    protected boolean canFit(ItemStack stack, BlockPos pos, Direction face) {
        if (this.f_58857_.m_8055_(pos).m_60734_() instanceof WorldlyContainerHolder) {
            return MiscUtil.canPutIntoInv(stack, (LevelAccessor)this.f_58857_, pos, null, face, false);
        }
        BlockEntity tile = this.f_58857_.m_7702_(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)tile;
            return pipe.isPipeEnabled();
        }
        return MiscUtil.canPutIntoInv(stack, (LevelAccessor)this.f_58857_, pos, tile, face, false);
    }

    protected boolean isPipeEnabled() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        return state.m_204336_(PipesModule.pipesTag) && !this.f_58857_.m_46753_(this.f_58858_);
    }

    public boolean m_7155_(int index, @Nonnull ItemStack itemStackIn, @Nonnull Direction direction) {
        return index == direction.ordinal() && this.isPipeEnabled();
    }

    public void m_6836_(int i, @Nonnull ItemStack itemstack) {
        if (!itemstack.m_41619_()) {
            Direction side = Direction.values()[i];
            this.passIn(itemstack, side);
            if (!this.f_58857_.f_46443_ && !this.skipSync) {
                this.sync();
            }
        }
    }

    public int m_6643_() {
        return 6;
    }

    protected boolean needsToSyncInventory() {
        return true;
    }

    public void sync() {
        MiscUtil.syncTE((BlockEntity)this);
    }

    public void refreshAllConnections() {
        Arrays.stream(Direction.values()).forEach(this::updateConnection);
    }

    protected ConnectionType updateConnection(Direction facing) {
        ConnectionType c;
        this.connectionsCache[facing.ordinal()] = c = PipeBlockEntity.computeConnectionTo((BlockGetter)this.f_58857_, this.f_58858_, facing);
        return c;
    }

    public ConnectionType getConnectionTo(Direction side) {
        ConnectionType c = this.connectionsCache[side.ordinal()];
        if (c == null) {
            c = this.updateConnection(side);
        }
        return c;
    }

    public static ConnectionType computeConnectionTo(BlockGetter world, BlockPos pos, Direction face) {
        return PipeBlockEntity.computeConnectionTo(world, pos, face, false);
    }

    private static ConnectionType computeConnectionTo(BlockGetter world, BlockPos pos, Direction face, boolean recursed) {
        block8: {
            BlockPos truePos = pos.m_121945_(face);
            if (world.m_8055_(truePos).m_60734_() instanceof WorldlyContainerHolder) {
                return ConnectionType.TERMINAL;
            }
            BlockEntity tile = world.m_7702_(truePos);
            if (tile != null) {
                if (tile instanceof PipeBlockEntity) {
                    return ConnectionType.PIPE;
                }
                if (tile instanceof Container || tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face.m_122424_()).isPresent()) {
                    return tile instanceof ChestBlockEntity ? ConnectionType.TERMINAL_OFFSET : ConnectionType.TERMINAL;
                }
            }
            if (!recursed) {
                ConnectionType other = PipeBlockEntity.computeConnectionTo(world, pos, face.m_122424_(), true);
                if (other.isSolid) {
                    for (Direction d : Direction.values()) {
                        if (d.m_122434_() == face.m_122434_()) continue;
                        other = PipeBlockEntity.computeConnectionTo(world, pos, d, true);
                        if (!other.isSolid) {
                            continue;
                        }
                        break block8;
                    }
                    return ConnectionType.OPENING;
                }
            }
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType {
        NONE(false, false, false, 0.0),
        PIPE(true, true, false, 0.0),
        OPENING(false, true, true, -0.125, 0.1875),
        TERMINAL(true, true, true, 0.125),
        TERMINAL_OFFSET(true, true, true, 0.1875);

        public final boolean isSolid;
        public final boolean allowsItems;
        public final boolean isFlared;
        private final double flareShift;
        private final double fullFlareShift;

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared, double flareShift, double fullFlareShift) {
            this.isSolid = isSolid;
            this.allowsItems = allowsItems;
            this.isFlared = isFlared;
            this.flareShift = flareShift;
            this.fullFlareShift = fullFlareShift;
        }

        private ConnectionType(boolean isSolid, boolean allowsItems, boolean isFlared, double flareShift) {
            this(isSolid, allowsItems, isFlared, flareShift, flareShift);
        }

        public double getFlareShift(PipeBlockEntity pipe) {
            return pipe.allowsFullConnection(this) ? this.fullFlareShift : this.flareShift;
        }
    }

    public static class PipeItem {
        private static final String TAG_TICKS = "ticksInPipe";
        private static final String TAG_INCOMING = "incomingFace";
        private static final String TAG_OUTGOING = "outgoingFace";
        private static final String TAG_BACKLOGGED = "backloggedFace";
        private static final String TAG_RNG_SEED = "rngSeed";
        private static final String TAG_TIME_IN_WORLD = "timeInWorld";
        private static final List<Direction> HORIZONTAL_SIDES_LIST = Arrays.asList(MiscUtil.HORIZONTALS);
        public final ItemStack stack;
        public int ticksInPipe;
        public final Direction incomingFace;
        public Direction outgoingFace;
        public Direction backloggedFace;
        public long rngSeed;
        public int timeInWorld = 0;
        public boolean valid = true;

        public PipeItem(ItemStack stack, Direction face, long rngSeed) {
            this.stack = stack;
            this.ticksInPipe = 0;
            this.incomingFace = this.outgoingFace = face;
            this.rngSeed = rngSeed;
        }

        protected boolean tick(PipeBlockEntity pipe) {
            ++this.ticksInPipe;
            ++this.timeInWorld;
            if (this.ticksInPipe == PipesModule.effectivePipeSpeed / 2 - 1) {
                this.outgoingFace = this.getTargetFace(pipe);
            }
            if (this.outgoingFace == null) {
                this.valid = false;
                return true;
            }
            return this.ticksInPipe >= PipesModule.effectivePipeSpeed;
        }

        protected Direction getTargetFace(PipeBlockEntity pipe) {
            BlockPos pipePos = pipe.m_58899_();
            if (this.incomingFace != Direction.DOWN && this.backloggedFace != Direction.DOWN && pipe.canFit(this.stack, pipePos.m_121945_(Direction.DOWN), Direction.UP)) {
                return Direction.DOWN;
            }
            Direction incomingOpposite = this.incomingFace;
            if (this.incomingFace.m_122434_() != Direction.Axis.Y && (incomingOpposite = this.incomingFace.m_122424_()) != this.backloggedFace && pipe.canFit(this.stack, pipePos.m_121945_(incomingOpposite), this.incomingFace)) {
                return incomingOpposite;
            }
            ArrayList<Direction> sides = new ArrayList<Direction>(HORIZONTAL_SIDES_LIST);
            sides.remove(this.incomingFace);
            sides.remove(incomingOpposite);
            Random rng = new Random(this.rngSeed);
            this.rngSeed = rng.nextLong();
            Collections.shuffle(sides, rng);
            for (Direction side : sides) {
                if (side == this.backloggedFace || !pipe.canFit(this.stack, pipePos.m_121945_(side), side.m_122424_())) continue;
                return side;
            }
            if (this.incomingFace != Direction.UP && this.backloggedFace != Direction.UP && pipe.canFit(this.stack, pipePos.m_121945_(Direction.UP), Direction.DOWN)) {
                return Direction.UP;
            }
            if (this.backloggedFace != null) {
                return this.backloggedFace;
            }
            return null;
        }

        public float getTimeFract(float partial) {
            return ((float)this.ticksInPipe + partial) / (float)PipesModule.effectivePipeSpeed;
        }

        public void writeToNBT(CompoundTag cmp) {
            this.stack.m_41739_(cmp);
            cmp.m_128405_(TAG_TICKS, this.ticksInPipe);
            cmp.m_128405_(TAG_INCOMING, this.incomingFace.ordinal());
            cmp.m_128405_(TAG_OUTGOING, this.outgoingFace.ordinal());
            cmp.m_128405_(TAG_BACKLOGGED, this.backloggedFace != null ? this.backloggedFace.ordinal() : -1);
            cmp.m_128356_(TAG_RNG_SEED, this.rngSeed);
            cmp.m_128405_(TAG_TIME_IN_WORLD, this.timeInWorld);
        }

        public static PipeItem readFromNBT(CompoundTag cmp) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)cmp);
            Direction inFace = Direction.values()[cmp.m_128451_(TAG_INCOMING)];
            long rngSeed = cmp.m_128454_(TAG_RNG_SEED);
            PipeItem item = new PipeItem(stack, inFace, rngSeed);
            item.ticksInPipe = cmp.m_128451_(TAG_TICKS);
            item.outgoingFace = Direction.values()[cmp.m_128451_(TAG_OUTGOING)];
            item.timeInWorld = cmp.m_128451_(TAG_TIME_IN_WORLD);
            int backloggedId = cmp.m_128451_(TAG_BACKLOGGED);
            item.backloggedFace = backloggedId == -1 ? null : Direction.values()[backloggedId];
            return item;
        }
    }
}

