/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import shadows.placebo.util.PlaceboUtil;

public class EnchantmentIngredient
extends AbstractIngredient {
    protected final ItemLike item;
    protected final Enchantment enchantment;
    protected final int minLevel;

    public EnchantmentIngredient(ItemLike item, Enchantment enchantment, int minLevel) {
        super(Stream.of(new Ingredient.ItemValue(EnchantmentIngredient.format(item, enchantment, minLevel))));
        this.item = item;
        this.enchantment = enchantment;
        this.minLevel = minLevel;
    }

    private static ItemStack format(ItemLike item, Enchantment enchantment, int minLevel) {
        ItemStack stack = new ItemStack(item);
        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)minLevel), (ItemStack)stack);
        PlaceboUtil.addLore((ItemStack)stack, (Component)Component.m_237110_((String)"ingredient.apotheosis.ench", (Object[])new Object[]{((MutableComponent)enchantment.m_44700_(minLevel)).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.ITALIC})}));
        return stack;
    }

    public boolean test(ItemStack stack) {
        return super.test(stack) && stack.getEnchantmentLevel(this.enchantment) >= this.minLevel;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        return new JsonObject();
    }

    public static class Serializer
    implements IIngredientSerializer<EnchantmentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EnchantmentIngredient parse(FriendlyByteBuf buffer) {
            ItemStack stack = buffer.m_130267_();
            Enchantment ench = (Enchantment)((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(buffer.m_130242_());
            short level = buffer.readShort();
            return new EnchantmentIngredient((ItemLike)stack.m_41720_(), ench, level);
        }

        public EnchantmentIngredient parse(JsonObject json) {
            return null;
        }

        public void write(FriendlyByteBuf buffer, EnchantmentIngredient ingredient) {
            buffer.m_130055_(new ItemStack(ingredient.item));
            buffer.m_130130_(((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((Object)ingredient.enchantment));
            buffer.writeShort(ingredient.minLevel);
        }
    }
}

