/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.placebo.codec.PlaceboCodecs;

public final class LootCategory {
    private static final Map<String, LootCategory> BY_ID_INTERNAL = new HashMap<String, LootCategory>();
    private static final List<LootCategory> VALUES_INTERNAL = new LinkedList<LootCategory>();
    public static final Map<String, LootCategory> BY_ID = Collections.unmodifiableMap(BY_ID_INTERNAL);
    public static final List<LootCategory> VALUES = Collections.unmodifiableList(VALUES_INTERNAL);
    public static final Codec<LootCategory> CODEC = ExtraCodecs.m_184405_(LootCategory::getName, LootCategory::byId);
    public static final Codec<Set<LootCategory>> SET_CODEC = PlaceboCodecs.setCodec(CODEC);
    public static final LootCategory BOW = LootCategory.register("bow", s -> s.m_41720_() instanceof BowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final LootCategory CROSSBOW = LootCategory.register("crossbow", s -> s.m_41720_() instanceof CrossbowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND));
    public static final LootCategory PICKAXE = LootCategory.register("pickaxe", s -> s.canPerformAction(ToolActions.PICKAXE_DIG), s -> LootCategory.arr(EquipmentSlot.MAINHAND));
    public static final LootCategory SHOVEL = LootCategory.register("shovel", s -> s.canPerformAction(ToolActions.SHOVEL_DIG), s -> LootCategory.arr(EquipmentSlot.MAINHAND));
    public static final LootCategory HEAVY_WEAPON = LootCategory.register("heavy_weapon", new ShieldBreakerTest(), s -> LootCategory.arr(EquipmentSlot.MAINHAND));
    public static final LootCategory HELMET = LootCategory.register("helmet", LootCategory.armorSlot(EquipmentSlot.HEAD), s -> LootCategory.arr(EquipmentSlot.HEAD));
    public static final LootCategory CHESTPLATE = LootCategory.register("chestplate", LootCategory.armorSlot(EquipmentSlot.CHEST), s -> LootCategory.arr(EquipmentSlot.CHEST));
    public static final LootCategory LEGGINGS = LootCategory.register("leggings", LootCategory.armorSlot(EquipmentSlot.LEGS), s -> LootCategory.arr(EquipmentSlot.LEGS));
    public static final LootCategory BOOTS = LootCategory.register("boots", LootCategory.armorSlot(EquipmentSlot.FEET), s -> LootCategory.arr(EquipmentSlot.FEET));
    public static final LootCategory SHIELD = LootCategory.register("shield", s -> s.canPerformAction(ToolActions.SHIELD_BLOCK), s -> LootCategory.arr(EquipmentSlot.OFFHAND));
    public static final LootCategory TRIDENT = LootCategory.register("trident", s -> s.m_41720_() instanceof TridentItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND));
    public static final LootCategory SWORD = LootCategory.register("sword", s -> s.canPerformAction(ToolActions.SWORD_DIG) || s.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, s).get((Object)Attributes.f_22281_).stream().anyMatch(m -> m.m_22218_() > 0.0), s -> LootCategory.arr(EquipmentSlot.MAINHAND));
    public static final LootCategory NONE = LootCategory.register("none", (Predicate<ItemStack>)Predicates.alwaysFalse(), s -> new EquipmentSlot[0]);
    private final String name;
    private final Predicate<ItemStack> validator;
    private final Function<ItemStack, EquipmentSlot[]> slotGetter;

    private LootCategory(String name, Predicate<ItemStack> validator, Function<ItemStack, EquipmentSlot[]> slotGetter) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.validator = (Predicate)Preconditions.checkNotNull(validator);
        this.slotGetter = (Function)Preconditions.checkNotNull(slotGetter);
    }

    public String getDescId() {
        return "text.apotheosis.category." + this.name;
    }

    public String getDescIdPlural() {
        return this.getDescId() + ".plural";
    }

    public String getName() {
        return this.name;
    }

    public EquipmentSlot[] getSlots(ItemStack stack) {
        return this.slotGetter.apply(stack);
    }

    public boolean isValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    public boolean isArmor() {
        return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
    }

    public boolean isBreaker() {
        return this == PICKAXE || this == SHOVEL;
    }

    public boolean isRanged() {
        return this == BOW || this == CROSSBOW || this == TRIDENT;
    }

    public boolean isDefensive() {
        return this.isArmor() || this == SHIELD;
    }

    public boolean isLightWeapon() {
        return this == SWORD || this == TRIDENT;
    }

    public boolean isWeapon() {
        return this == SWORD || this == HEAVY_WEAPON || this == TRIDENT;
    }

    public boolean isWeaponOrShield() {
        return this.isLightWeapon() || this == SHIELD;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public String toString() {
        return String.format("LootCategory[%s]", this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof LootCategory)) return false;
        LootCategory cat = (LootCategory)obj;
        if (!cat.name.equals(this.name)) return false;
        return true;
    }

    public static final LootCategory register(@Nullable LootCategory orderRef, String name, Predicate<ItemStack> validator, Function<ItemStack, EquipmentSlot[]> slotGetter) {
        LootCategory cat = new LootCategory(name, validator, slotGetter);
        if (BY_ID_INTERNAL.containsKey(name)) {
            throw new IllegalArgumentException("Cannot register a loot category with a duplicate name.");
        }
        BY_ID_INTERNAL.put(name, cat);
        int idx = VALUES_INTERNAL.size();
        if (orderRef != null) {
            idx = VALUES_INTERNAL.indexOf(orderRef);
        }
        VALUES_INTERNAL.add(idx, cat);
        return cat;
    }

    @Nullable
    public static LootCategory byId(String name) {
        return BY_ID.get(name);
    }

    public static LootCategory forItem(ItemStack item) {
        LootCategory override = AdventureConfig.TYPE_OVERRIDES.get(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (override != null) {
            return override;
        }
        for (LootCategory c : VALUES) {
            if (!c.isValid(item)) continue;
            return c;
        }
        return NONE;
    }

    private static EquipmentSlot[] arr(EquipmentSlot ... s) {
        return s;
    }

    private static Predicate<ItemStack> armorSlot(EquipmentSlot slot) {
        return stack -> {
            ArmorItem arm;
            Item patt8619$temp = stack.m_41720_();
            return patt8619$temp instanceof ArmorItem && (arm = (ArmorItem)patt8619$temp).m_40402_() == slot;
        };
    }

    static final LootCategory register(String name, Predicate<ItemStack> validator, Function<ItemStack, EquipmentSlot[]> slotGetter) {
        return LootCategory.register(null, name, validator, slotGetter);
    }

    private static class ShieldBreakerTest
    implements Predicate<ItemStack> {
        private Zombie attacker;
        private Zombie holder;

        private ShieldBreakerTest() {
        }

        @Override
        public boolean test(ItemStack t) {
            try {
                ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (this.attacker == null && server != null) {
                    this.attacker = new Zombie((Level)server.m_129880_(Level.f_46428_));
                    this.holder = new Zombie((Level)server.m_129880_(Level.f_46428_));
                }
                if (this.holder != null) {
                    this.holder.m_21008_(InteractionHand.OFF_HAND, shield);
                }
                return t.canDisableShield(shield, (LivingEntity)this.holder, (LivingEntity)this.attacker);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

