/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FItemLayerModel
implements IUnbakedGeometry<FItemLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    private ImmutableList<Material> textures;
    private final Int2ObjectMap<ForgeFaceData> layerData;
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;
    private final boolean deprecatedLoader;
    private final boolean logWarning;

    @Deprecated(forRemoval=true, since="1.20")
    public FItemLayerModel(@Nullable ImmutableList<Material> textures, IntSet emissiveLayers, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this(textures, (Int2ObjectMap<ForgeFaceData>)((Int2ObjectMap)emissiveLayers.intStream().collect(Int2ObjectArrayMap::new, (map, val) -> map.put(val, (Object)new ForgeFaceData(-1, 15, 15)), (map1, map2) -> map1.putAll((Map)map2))), renderTypeNames, false, false);
    }

    public FItemLayerModel(@Nullable ImmutableList<Material> textures, Int2ObjectMap<ForgeFaceData> layerData, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this(textures, layerData, renderTypeNames, false, false);
    }

    private FItemLayerModel(@Nullable ImmutableList<Material> textures, Int2ObjectMap<ForgeFaceData> layerData, Int2ObjectMap<ResourceLocation> renderTypeNames, boolean deprecatedLoader, boolean logWarning) {
        this.textures = textures;
        this.layerData = layerData;
        this.renderTypeNames = renderTypeNames;
        this.deprecatedLoader = deprecatedLoader;
        this.logWarning = logWarning;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.textures == null) {
            throw new IllegalStateException("Textures have not been initialized. Either pass them in through the constructor or call getMaterials(...) first.");
        }
        if (this.deprecatedLoader) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated loader \"forge:item-layers\" instead of \"forge:item_layers\". This loader will be removed in 1.20.");
        }
        if (this.logWarning) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated \"fullbright_layers\" field in its item layer model instead of \"emissive_layers\". This field will be removed in 1.20.");
        }
        TextureAtlasSprite particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.m_110466_(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((IGeometryBakingContext)context, (TextureAtlasSprite)particle, (ItemOverrides)overrides, (ItemTransforms)context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            ResourceLocation renderTypeName;
            TextureAtlasSprite sprite = spriteGetter.apply((Material)this.textures.get(i));
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)i, (TextureAtlasSprite)sprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)modelState, (ResourceLocation)modelLocation);
            if (this.layerData.containsKey(i)) {
                ForgeFaceData data = (ForgeFaceData)this.layerData.get(i);
                FItemLayerModel.applyingLightmap(data.blockLight(), data.skyLight()).processInPlace(quads);
                FItemLayerModel.applyingColor(data.color()).processInPlace(quads);
            }
            RenderTypeGroup renderTypes = (renderTypeName = (ResourceLocation)this.renderTypeNames.get(i)) != null ? context.getRenderType(renderTypeName) : null;
            builder.addQuads(renderTypes != null ? renderTypes : normalRenderTypes, (Collection)quads);
        }
        return builder.build();
    }

    public static IQuadTransformer applyingLightmap(int blockLight, int skyLight) {
        return quad -> {
            int[] vertices = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.UV2] = LightTexture.m_109885_((int)blockLight, (int)skyLight);
            }
        };
    }

    public static IQuadTransformer applyingColor(int color) {
        int fixedColor = FItemLayerModel.toABGR(color);
        return quad -> {
            int[] vertices = quad.m_111303_();
            for (int i = 0; i < 4; ++i) {
                vertices[i * IQuadTransformer.STRIDE + IQuadTransformer.COLOR] = fixedColor;
            }
        };
    }

    public static int toABGR(int argb) {
        return argb & 0xFF00FF00 | argb >> 16 & 0xFF | argb << 16 & 0xFF0000;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        if (this.textures != null) {
            return this.textures;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (context.hasMaterial("particle")) {
            builder.add((Object)context.getMaterial("particle"));
        }
        int i = 0;
        while (context.hasMaterial("layer" + i)) {
            builder.add((Object)context.getMaterial("layer" + i));
            ++i;
        }
        this.textures = builder.build();
        return this.textures;
    }

    public record ForgeFaceData(int color, int blockLight, int skyLight) {
        public static final ForgeFaceData DEFAULT = new ForgeFaceData(-1, 0, 0);
        public static final Codec<Integer> COLOR = new ExtraCodecs.EitherCodec((Codec)Codec.INT, (Codec)Codec.STRING).xmap(either -> (Integer)either.map(Function.identity(), str -> (int)Long.parseLong(str, 16)), color -> Either.right((Object)Integer.toHexString(color)));
        public static final Codec<ForgeFaceData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)COLOR.optionalFieldOf("color", (Object)-1).forGetter(ForgeFaceData::color), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("block_light", (Object)0).forGetter(ForgeFaceData::blockLight), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("sky_light", (Object)0).forGetter(ForgeFaceData::skyLight)).apply((Applicative)builder, ForgeFaceData::new));
    }

    public static final class Loader
    implements IGeometryLoader<FItemLayerModel> {
        public static final Loader INSTANCE = new Loader(false);
        @Deprecated(forRemoval=true, since="1.19")
        public static final Loader INSTANCE_DEPRECATED = new Loader(true);
        private final boolean deprecated;

        private Loader(boolean deprecated) {
            this.deprecated = deprecated;
        }

        public FItemLayerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = new ResourceLocation((String)entry.getKey());
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate render type for layer " + layer);
                    }
                }
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            this.readUnlit(jsonObject, "forge_data", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, false);
            boolean logWarning = this.readUnlit(jsonObject, "emissive_layers", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, true);
            return new FItemLayerModel(null, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, (Int2ObjectMap<ResourceLocation>)renderTypeNames, this.deprecated, logWarning |= this.readUnlit(jsonObject, "fullbright_layers", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, (Int2ObjectMap<ForgeFaceData>)emissiveLayers, true));
        }

        protected boolean readUnlit(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<ResourceLocation> renderTypeNames, Int2ObjectMap<ForgeFaceData> layerData, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return false;
            }
            JsonElement ele = jsonObject.get(name);
            if (ele.isJsonArray()) {
                JsonArray fullbrightLayers = jsonObject.getAsJsonArray(name);
                for (JsonElement layer : fullbrightLayers) {
                    layerData.put(layer.getAsInt(), (Object)new ForgeFaceData(-1, 15, 15));
                }
                return logWarning && !fullbrightLayers.isEmpty();
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (String layerStr : fullbrightLayers.keySet()) {
                int layer = Integer.parseInt(layerStr);
                ForgeFaceData data = (ForgeFaceData)ForgeFaceData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)fullbrightLayers.get(layerStr)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                layerData.put(layer, (Object)data);
            }
            return false;
        }
    }
}

