/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossStats;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.json.WeightedJsonReloadListener;

public final class MinibossItem
extends PlaceboJsonReloadListener.TypeKeyedBase<MinibossItem>
implements WeightedJsonReloadListener.ILuckyWeighted,
WeightedJsonReloadListener.IDimensional,
GameStagesCompat.IStaged {
    protected int weight;
    protected float quality;
    protected String name;
    protected Set<EntityType<?>> entities;
    protected BossStats stats;
    @Nullable
    protected Set<String> stages;
    protected Set<ResourceLocation> dimensions;
    protected boolean affixed;
    @SerializedName(value="valid_gear_sets")
    protected List<GearSet.SetPredicate> armorSets;
    @SerializedName(value="nbt")
    protected CompoundTag customNbt;
    @SerializedName(value="supporting_entities")
    protected List<SupportingEntity> supportingEntities;
    protected SupportingEntity mount;

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public Set<EntityType<?>> getEntities() {
        return this.entities;
    }

    public void transform(Mob mob, RandomSource random, float luck) {
        if (this.customNbt != null) {
            mob.m_20258_(this.customNbt);
        }
        this.initBoss(random, mob, luck);
        if (this.customNbt != null) {
            mob.m_7378_(this.customNbt);
        }
    }

    public void initBoss(RandomSource rand, Mob mob, float luck) {
        int duration = mob instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : this.stats.effects) {
            if (!(rand.m_188501_() <= inst.getChance())) continue;
            mob.m_7292_(inst.createInstance(rand, duration));
        }
        for (RandomAttributeModifier modif : this.stats.modifiers) {
            modif.apply(rand, (LivingEntity)mob);
        }
        mob.f_21345_.f_25345_.removeIf(BossItem.IS_VILLAGER_ATTACK);
        String name = NameHelper.setEntityName(rand, mob);
        GearSet set = BossArmorManager.INSTANCE.getRandomSet(rand, luck, this.armorSets);
        set.apply((LivingEntity)mob);
        boolean anyValid = false;
        for (EquipmentSlot t : EquipmentSlot.values()) {
            ItemStack s = mob.m_6844_(t);
            if (s.m_41619_() || LootCategory.forItem(s).isNone()) continue;
            anyValid = true;
            break;
        }
        if (!anyValid) {
            throw new RuntimeException("Attempted to apply boss gear set " + set.getId() + " but it had no valid affix loot items generated.");
        }
        int guaranteed = rand.m_188503_(6);
        ItemStack temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
        while (temp.m_41619_() || LootCategory.forItem(temp) == LootCategory.NONE) {
            guaranteed = rand.m_188503_(6);
            temp = mob.m_6844_(EquipmentSlot.values()[guaranteed]);
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = mob.m_6844_(s);
            if (s.ordinal() == guaranteed) {
                mob.m_21409_(s, 2.0f);
            }
            if (s.ordinal() == guaranteed || !(rand.m_188501_() < this.stats.enchantChance)) continue;
            this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels[0] : this.stats.enchLevels[1], true);
            mob.m_8061_(s, stack);
        }
        mob.getPersistentData().m_128379_("apoth.boss", true);
        mob.m_21153_(mob.m_21233_());
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400));
    }

    public void enchantBossItem(RandomSource rand, ItemStack stack, int level, boolean treasure) {
        List ench = EnchantmentHelper.m_220297_((RandomSource)rand, (ItemStack)stack, (int)level, (boolean)treasure);
        Map<Enchantment, Integer> map = ench.stream().filter(d -> !d.f_44947_.m_6589_()).collect(Collectors.toMap(d -> d.f_44947_, d -> d.f_44948_, Math::max));
        map.putAll(EnchantmentHelper.m_44831_((ItemStack)stack));
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
    }

    public ItemStack modifyBossItem(ItemStack stack, RandomSource rand, String bossName, float luck, LootRarity rarity) {
        this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? this.stats.enchLevels[2] : this.stats.enchLevels[3], true);
        NameHelper.setItemName(rand, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, rand);
        String bossOwnerName = String.format(NameHelper.ownershipFormat, bossName) + " ";
        Component name = AffixHelper.getName(stack);
        ComponentContents componentContents = name.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            MutableComponent copy = Component.m_237110_((String)(bossOwnerName + tc.m_237508_()), (Object[])tc.m_237523_()).m_130948_(name.m_7383_());
            AffixHelper.setName(stack, (Component)copy);
        }
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (entry.getKey() == null) continue;
            enchMap.put((Enchantment)entry.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)entry.getKey()), (Integer)entry.getValue() + rand.m_188503_(2)));
        }
        if (AdventureConfig.curseBossItems) {
            ItemStack stk = stack;
            List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> e.canApplyAtEnchantingTable(stk) && e.m_6589_()).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Enchantment curse = (Enchantment)list.get(rand.m_188503_(list.size()));
                enchMap.put(curse, Mth.m_216271_((RandomSource)rand, (int)1, (int)EnchHooks.getMaxLevel(curse)));
            }
        }
        EnchantmentHelper.m_44865_(enchMap, (ItemStack)stack);
        stack.m_41783_().m_128379_("apoth_boss", true);
        return stack;
    }

    public MinibossItem validate() {
        return this;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public static class SupportingEntity {
        EntityType<?> entity;
        CompoundTag nbt;
        int x;
        int y;
        int z;
    }
}

