/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossStats;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;
import shadows.placebo.json.WeightedJsonReloadListener;

public final class BossItem
extends PlaceboJsonReloadListener.TypeKeyedBase<BossItem>
implements WeightedJsonReloadListener.ILuckyWeighted,
WeightedJsonReloadListener.IDimensional,
LootRarity.Clamped,
GameStagesCompat.IStaged {
    public static final Predicate<Goal> IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).f_26048_ == Villager.class;
    protected int weight;
    protected float quality;
    protected EntityType<?> entity;
    protected AABB size;
    protected Map<LootRarity, BossStats> stats;
    @Nullable
    protected Set<String> stages;
    @SerializedName(value="valid_gear_sets")
    protected List<GearSet.SetPredicate> armorSets;
    @SerializedName(value="nbt")
    protected CompoundTag customNbt;
    protected Set<ResourceLocation> dimensions;
    @SerializedName(value="min_rarity")
    protected LootRarity minRarity;
    @SerializedName(value="max_rarity")
    protected LootRarity maxRarity;

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    public AABB getSize() {
        return this.size;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public Mob createBoss(ServerLevelAccessor world, BlockPos pos, RandomSource random, float luck) {
        Mob entity = (Mob)this.entity.m_20615_((Level)world.m_6018_());
        if (this.customNbt != null) {
            entity.m_20258_(this.customNbt);
        }
        this.initBoss(random, entity, luck);
        if (this.customNbt != null) {
            entity.m_7378_(this.customNbt);
        }
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, random.m_188501_() * 360.0f, 0.0f);
        return entity;
    }

    public void initBoss(RandomSource rand, Mob entity, float luck) {
        LootRarity rarity = LootRarity.random(rand, luck, this);
        BossStats stats = this.stats.get(rarity);
        int duration = entity instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : stats.effects) {
            if (!(rand.m_188501_() <= inst.getChance())) continue;
            entity.m_7292_(inst.createInstance(rand, duration));
        }
        for (RandomAttributeModifier modif : stats.modifiers) {
            modif.apply(rand, (LivingEntity)entity);
        }
        entity.f_21345_.f_25345_.removeIf(IS_VILLAGER_ATTACK);
        String name = NameHelper.setEntityName(rand, entity);
        GearSet set = BossArmorManager.INSTANCE.getRandomSet(rand, luck, this.armorSets);
        set.apply((LivingEntity)entity);
        boolean anyValid = false;
        for (EquipmentSlot t : EquipmentSlot.values()) {
            ItemStack s = entity.m_6844_(t);
            if (s.m_41619_() || LootCategory.forItem(s).isNone()) continue;
            anyValid = true;
            break;
        }
        if (!anyValid) {
            throw new RuntimeException("Attempted to apply boss gear set " + set.getId() + " but it had no valid affix loot items generated.");
        }
        int guaranteed = rand.m_188503_(6);
        ItemStack temp = entity.m_6844_(EquipmentSlot.values()[guaranteed]);
        while (temp.m_41619_() || LootCategory.forItem(temp) == LootCategory.NONE) {
            guaranteed = rand.m_188503_(6);
            temp = entity.m_6844_(EquipmentSlot.values()[guaranteed]);
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(s);
            if (s.ordinal() == guaranteed) {
                entity.m_21409_(s, 2.0f);
            }
            if (s.ordinal() == guaranteed) {
                entity.m_8061_(s, this.modifyBossItem(stack, rand, name, luck, rarity));
                entity.m_6593_((Component)((MutableComponent)entity.m_7770_()).m_130948_(Style.f_131099_.m_131148_(rarity.color())));
                continue;
            }
            if (!(rand.m_188501_() < stats.enchantChance)) continue;
            this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? stats.enchLevels[0] : stats.enchLevels[1], true);
            entity.m_8061_(s, stack);
        }
        entity.getPersistentData().m_128379_("apoth.boss", true);
        entity.getPersistentData().m_128359_("apoth.rarity", rarity.id());
        entity.m_21153_(entity.m_21233_());
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400));
    }

    public void enchantBossItem(RandomSource rand, ItemStack stack, int level, boolean treasure) {
        List ench = EnchantmentHelper.m_220297_((RandomSource)rand, (ItemStack)stack, (int)level, (boolean)treasure);
        Map<Enchantment, Integer> map = ench.stream().filter(d -> !d.f_44947_.m_6589_()).collect(Collectors.toMap(d -> d.f_44947_, d -> d.f_44948_, Math::max));
        map.putAll(EnchantmentHelper.m_44831_((ItemStack)stack));
        EnchantmentHelper.m_44865_(map, (ItemStack)stack);
    }

    public ItemStack modifyBossItem(ItemStack stack, RandomSource rand, String bossName, float luck, LootRarity rarity) {
        BossStats stats = this.stats.get(rarity);
        this.enchantBossItem(rand, stack, Apotheosis.enableEnch ? stats.enchLevels[2] : stats.enchLevels[3], true);
        NameHelper.setItemName(rand, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, rand);
        String bossOwnerName = String.format(NameHelper.ownershipFormat, bossName);
        Component name = AffixHelper.getName(stack);
        ComponentContents componentContents = name.m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            String oldKey = tc.m_237508_();
            String string = oldKey.equals("misc.apotheosis.affix_name.two") ? "misc.apotheosis.affix_name.three" : "misc.apotheosis.affix_name.four";
            Object[] newArgs = new Object[tc.m_237523_().length + 1];
            newArgs[0] = bossOwnerName;
            for (int i = 1; i < newArgs.length; ++i) {
                newArgs[i] = tc.m_237523_()[i - 1];
            }
            MutableComponent copy = Component.m_237110_((String)string, (Object[])newArgs).m_130948_(name.m_7383_().m_131155_(Boolean.valueOf(false)));
            AffixHelper.setName(stack, (Component)copy);
        }
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (entry.getKey() == null) continue;
            enchMap.put((Enchantment)entry.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)entry.getKey()), (Integer)entry.getValue() + rand.m_188503_(2)));
        }
        if (AdventureConfig.curseBossItems) {
            ItemStack stk = stack;
            List list = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> e.canApplyAtEnchantingTable(stk) && e.m_6589_()).collect(Collectors.toList());
            if (!list.isEmpty()) {
                Enchantment curse = (Enchantment)list.get(rand.m_188503_(list.size()));
                enchMap.put(curse, Mth.m_216271_((RandomSource)rand, (int)1, (int)EnchHooks.getMaxLevel(curse)));
            }
        }
        EnchantmentHelper.m_44865_(enchMap, (ItemStack)stack);
        stack.m_41783_().m_128379_("apoth_boss", true);
        return stack;
    }

    public BossItem validate() {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Boss Item " + this.id + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Boss Item " + this.id + " has a negative quality!"));
        Preconditions.checkNotNull(this.entity, (Object)("Boss Item " + this.id + " has null entity type!"));
        Preconditions.checkNotNull((Object)this.size, (Object)("Boss Item " + this.id + " has no size!"));
        if (this.minRarity != null) {
            Preconditions.checkArgument((this.maxRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        if (this.maxRarity != null) {
            Preconditions.checkArgument((this.minRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        LootRarity r = LootRarity.max(LootRarity.COMMON, this.minRarity);
        while (r != LootRarity.ANCIENT) {
            Preconditions.checkNotNull((Object)this.stats.get(r));
            if (r == this.maxRarity) break;
            r = LootRarity.LIST.get(r.ordinal() + 1);
        }
        return this;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }
}

