/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.coremod.api.ASMAPI;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.util.GearSet;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.WeightedJsonReloadListener;

public class BossArmorManager
extends WeightedJsonReloadListener<GearSet> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setFieldNamingStrategy(f -> f.getName().equals(ASMAPI.mapField((String)"field_76292_a")) ? "weight" : f.getName()).create();
    public static final BossArmorManager INSTANCE = new BossArmorManager();

    public BossArmorManager() {
        super(AdventureModule.LOGGER, "boss_gear", false, false);
    }

    public <T extends Predicate<GearSet>> GearSet getRandomSet(RandomSource rand, float luck, @Nullable List<GearSet.SetPredicate> armorSets) {
        if (armorSets == null || armorSets.isEmpty()) {
            return (GearSet)this.getRandomItem(rand, luck);
        }
        List valid = this.registry.values().stream().filter(e -> {
            for (Predicate f : armorSets) {
                if (!f.test(e)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (valid.isEmpty()) {
            return (GearSet)this.getRandomItem(rand, luck);
        }
        ArrayList list = new ArrayList(valid.size());
        valid.stream().map(l -> l.wrap(luck)).forEach(list::add);
        return WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new PSerializer.Builder("Boss Gear Set").withJsonDeserializer(obj -> (GearSet)((Object)((Object)GSON.fromJson(obj, GearSet.class)))));
    }
}

