/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.loot.LootRarity;

public record GemInstance(ItemStack gemStack, Gem gem, LootRarity rarity, int facets) {
    public GemInstance(ItemStack gemStack) {
        this(gemStack, GemItem.getGem(gemStack), GemItem.getLootRarity(gemStack), GemItem.getFacets(gemStack));
    }

    public static GemInstance orLegacy(ItemStack gemStack) {
        return new GemInstance(gemStack, GemItem.getGemOrLegacy(gemStack), GemItem.getLootRarity(gemStack), GemItem.getFacets(gemStack));
    }

    public boolean isValid() {
        return this.gem != null && this.rarity != null && this.facets >= 0 && this.facets <= this.gem.getMaxFacets(this.rarity);
    }

    public boolean isValidIn(ItemStack socketed) {
        return this.isValid() && this.gem.isValidIn(socketed, this.gemStack, this.rarity);
    }

    public int maxFacets() {
        return this.gem.getMaxFacets(this.rarity);
    }

    public boolean isMaxed() {
        return this.facets == this.maxFacets();
    }
}

