/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.compat.GameStagesCompat;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.WeightedJsonReloadListener;

public class Gem
extends PlaceboJsonReloadListener.TypeKeyedBase<Gem>
implements WeightedJsonReloadListener.ILuckyWeighted,
WeightedJsonReloadListener.IDimensional,
LootRarity.Clamped,
GameStagesCompat.IStaged {
    public static final Codec<Gem> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.f_144628_.fieldOf("weight").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getWeight), (App)Codec.FLOAT.fieldOf("quality").forGetter(WeightedJsonReloadListener.ILuckyWeighted::getQuality), (App)PlaceboCodecs.setCodec((Codec)ResourceLocation.f_135803_).optionalFieldOf("dimensions", Collections.emptySet()).forGetter(WeightedJsonReloadListener.IDimensional::getDimensions), (App)LootRarity.CODEC.optionalFieldOf("min_rarity", (Object)LootRarity.COMMON).forGetter(LootRarity.Clamped::getMinRarity), (App)LootRarity.CODEC.optionalFieldOf("max_rarity", (Object)LootRarity.MYTHIC).forGetter(LootRarity.Clamped::getMaxRarity), (App)GemManager.gemBonusCodec().listOf().fieldOf("bonuses").forGetter(Gem::getBonuses), (App)Codec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(Gem::isUnique), (App)PlaceboCodecs.setCodec((Codec)Codec.STRING).optionalFieldOf("stages").forGetter(gem -> Optional.ofNullable(gem.getStages()))).apply((Applicative)inst, Gem::new));
    protected final int weight;
    protected final float quality;
    protected final Set<ResourceLocation> dimensions;
    protected final List<GemBonus> bonuses;
    protected final boolean unique;
    @Nullable
    protected final Set<String> stages;
    protected final transient Map<LootCategory, GemBonus> bonusMap;
    protected final transient int uuidsNeeded;
    protected final transient LootRarity minRarity;
    protected final transient LootRarity maxRarity;

    public Gem(int weight, float quality, Set<ResourceLocation> dimensions, @Nullable LootRarity minRarity, @Nullable LootRarity maxRarity, List<GemBonus> bonuses, boolean unique, Optional<Set<String>> stages) {
        this.weight = weight;
        this.quality = quality;
        this.dimensions = dimensions;
        this.bonuses = bonuses;
        this.unique = unique;
        this.stages = stages.orElse(null);
        this.bonusMap = bonuses.stream().mapMulti((gemData, mapper) -> {
            for (LootCategory c : gemData.getGemClass().types()) {
                mapper.accept(Pair.of((Object)c, (Object)gemData));
            }
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        this.uuidsNeeded = this.bonuses.stream().mapToInt(GemBonus::getNumberOfUUIDs).max().orElse(0);
        if (!this.bonuses.isEmpty()) {
            this.minRarity = LootRarity.values().stream().filter(bonuses.get(0)::supports).min(LootRarity::compareTo).get();
            this.maxRarity = LootRarity.values().stream().filter(bonuses.get(0)::supports).max(LootRarity::compareTo).get();
        } else {
            this.minRarity = this.maxRarity = LootRarity.COMMON;
        }
    }

    public int getNumberOfUUIDs() {
        return this.uuidsNeeded;
    }

    public void addModifiers(ItemStack socketed, ItemStack gem, LootRarity rarity, int facets, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> map) {
        LootCategory cat = LootCategory.forItem(socketed);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)socketed.m_41786_().getString());
            return;
        }
        for (EquipmentSlot itemSlot : cat.getSlots(socketed)) {
            if (itemSlot != slot) continue;
            this.getBonus(socketed).ifPresent(b -> b.addModifiers(gem, rarity, facets, map));
        }
    }

    public void addInformation(ItemStack gem, LootRarity rarity, int facets, Consumer<Component> list) {
        if (this.isUnique()) {
            list.accept((Component)Component.m_237115_((String)"text.apotheosis.unique").m_130948_(Style.f_131099_.m_178520_(13056274)));
        }
        list.accept((Component)Component.m_237110_((String)"text.apotheosis.facets", (Object[])new Object[]{4 + facets}).m_130948_(Style.f_131099_.m_178520_(11444950)));
        list.accept(CommonComponents.f_237098_);
        Style style = Style.f_131099_.m_178520_(720650);
        list.accept((Component)Component.m_237115_((String)"text.apotheosis.socketable_into").m_130948_(style));
        Gem.addTypeInfo(list, this.bonusMap.keySet().toArray());
        list.accept(CommonComponents.f_237098_);
        if (this.bonuses.size() == 1) {
            list.accept((Component)Component.m_237115_((String)"item.modifiers.socket").m_130940_(ChatFormatting.GOLD));
            list.accept(this.bonuses.get(0).getSocketBonusTooltip(gem, rarity, facets));
        } else {
            list.accept((Component)Component.m_237115_((String)"item.modifiers.socket_in").m_130940_(ChatFormatting.GOLD));
            for (GemBonus bonus : this.bonuses) {
                Component modifComp = bonus.getSocketBonusTooltip(gem, rarity, facets);
                MutableComponent sum = Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237110_((String)"%s: %s", (Object[])new Object[]{Component.m_237115_((String)("gem_class." + bonus.getGemClass().key())), modifComp})}).m_130940_(ChatFormatting.GOLD);
                list.accept((Component)sum);
            }
        }
    }

    public Component getSocketBonusTooltip(ItemStack socketed, ItemStack gem, LootRarity rarity, int facets) {
        return this.getBonus(socketed).map(b -> b.getSocketBonusTooltip(gem, rarity, facets)).orElse((Component)Component.m_237113_((String)"Invalid Gem Category"));
    }

    public int getMaxFacets(LootRarity rarity) {
        return this.bonuses.stream().mapToInt(b -> b.getMaxFacets(rarity)).max().orElse(0);
    }

    public boolean canApplyTo(ItemStack stack, ItemStack gem, LootRarity rarity) {
        List<Gem> gems;
        if (this.isUnique() && (gems = SocketHelper.getActiveGems(stack)).contains(this)) {
            return false;
        }
        return this.isValidIn(stack, gem, rarity);
    }

    public boolean isValidIn(ItemStack stack, ItemStack gem, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        return !cat.isNone() && this.bonusMap.containsKey(cat) && this.bonusMap.get(cat).supports(rarity);
    }

    public int getDamageProtection(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, DamageSource source) {
        return this.getBonus(stack).map(b -> b.getDamageProtection(gem, rarity, facets, source)).orElse(0);
    }

    public float getDamageBonus(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, MobType creatureType) {
        return this.getBonus(stack).map(b -> Float.valueOf(b.getDamageBonus(gem, rarity, facets, creatureType))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void doPostAttack(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, LivingEntity user, @Nullable Entity target) {
        this.getBonus(stack).ifPresent(b -> b.doPostAttack(gem, rarity, facets, user, target));
    }

    public void doPostHurt(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, LivingEntity user, @Nullable Entity attacker) {
        this.getBonus(stack).ifPresent(b -> b.doPostHurt(gem, rarity, facets, user, attacker));
    }

    public void onArrowFired(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, LivingEntity user, AbstractArrow arrow) {
        this.getBonus(stack).ifPresent(b -> b.onArrowFired(gem, rarity, facets, user, arrow));
    }

    @Nullable
    public InteractionResult onItemUse(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, UseOnContext ctx) {
        return this.getBonus(stack).map(b -> b.onItemUse(gem, rarity, facets, ctx)).orElse(null);
    }

    public void onArrowImpact(AbstractArrow arrow, ItemStack gem, LootRarity rarity, int facets, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, LivingEntity entity, DamageSource source, float amount) {
        return this.getBonus(stack).map(b -> Float.valueOf(b.onShieldBlock(gem, rarity, facets, entity, source, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void onBlockBreak(ItemStack stack, ItemStack gem, LootRarity rarity, int facets, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        this.getBonus(stack).ifPresent(b -> b.onBlockBreak(gem, rarity, facets, player, world, pos, state));
    }

    public float getDurabilityBonusPercentage(ItemStack socketed, ItemStack gemStack, LootRarity lootRarity, int facets, ServerPlayer user) {
        return this.getBonus(socketed).map(b -> Float.valueOf(b.getDurabilityBonusPercentage(gemStack, lootRarity, facets, user))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float onHurt(ItemStack socketed, ItemStack gemStack, LootRarity rarity, int facets, DamageSource src, LivingEntity ent, float amount) {
        return this.getBonus(socketed).map(b -> Float.valueOf(b.onHurt(gemStack, rarity, facets, src, ent, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void getEnchantmentLevels(ItemStack socketed, ItemStack gemStack, LootRarity rarity, int facets, Map<Enchantment, Integer> enchantments) {
        this.getBonus(socketed).ifPresent(b -> b.getEnchantmentLevels(gemStack, rarity, facets, enchantments));
    }

    protected Optional<GemBonus> getBonus(ItemStack stack) {
        return Optional.ofNullable(this.bonusMap.get(LootCategory.forItem(stack)));
    }

    public String toString() {
        return String.format("Gem: %s", this.getId());
    }

    public static String fmt(float f) {
        return Affix.fmt(f);
    }

    public boolean equals(Object obj) {
        Gem gem;
        return obj instanceof Gem && (gem = (Gem)obj).getId().equals((Object)this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public float getQuality() {
        return this.quality;
    }

    public int getWeight() {
        return this.weight;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    public List<GemBonus> getBonuses() {
        return this.bonuses;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public Gem validate() {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Gem " + this.getId() + " has a negative weight"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Gem " + this.getId() + " has a negative quality"));
        Preconditions.checkNotNull(this.dimensions);
        Preconditions.checkArgument((this.maxRarity.ordinal() >= this.minRarity.ordinal() ? 1 : 0) != 0);
        LootRarity.values().stream().filter(r -> r.isAtLeast(this.minRarity) && r.isAtMost(this.maxRarity)).forEach(r -> Preconditions.checkArgument((boolean)this.bonuses.stream().allMatch(b -> b.supports((LootRarity)r))));
        return this;
    }

    @Override
    public Set<String> getStages() {
        return this.stages;
    }

    public static void addTypeInfo(Consumer<Component> list, Object ... types) {
        Arrays.sort(types, (c1, c2) -> ((LootCategory)c1).getName().compareTo(((LootCategory)c2).getName()));
        Style style = Style.f_131099_.m_178520_(720650);
        if (types.length != LootCategory.BY_ID.size() - 1) {
            int rem;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < types.length; i += rem) {
                rem = Math.min(3, types.length - i);
                Object[] args = new Object[rem];
                for (int r = 0; r < rem; ++r) {
                    sb.append("%s, ");
                    args[r] = Component.m_237115_((String)((LootCategory)types[i + r]).getDescIdPlural());
                }
                list.accept((Component)Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237110_((String)sb.substring(0, sb.length() - 2), (Object[])args)}).m_130948_(style));
                sb.setLength(0);
            }
        } else {
            list.accept((Component)Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{Component.m_237115_((String)"text.apotheosis.anything")}).m_130948_(style));
        }
    }
}

