/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.util.StepFunction;

public class PotionAffix
extends Affix {
    private static Codec<Pair<StepFunction, StepFunction>> STEP_PAIR_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("duration").forGetter(Pair::getLeft), (App)StepFunction.CODEC.fieldOf("amplifier").forGetter(Pair::getRight)).apply((Applicative)inst, Pair::of));
    private static MapCodec<Map<LootRarity, Pair<StepFunction, StepFunction>>> VALUES_CODEC = Codec.simpleMap(LootRarity.CODEC, STEP_PAIR_CODEC, (Keyable)Keyable.forStrings(() -> LootRarity.values().stream().map(LootRarity::id)));
    public static final Codec<PotionAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("mob_effect").forGetter(a -> a.effect), (App)Target.CODEC.fieldOf("target").forGetter(a -> a.target), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)Codec.INT.optionalFieldOf("cooldown", (Object)0).forGetter(a -> a.cooldown), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, PotionAffix::new));
    protected final MobEffect effect;
    protected final Target target;
    protected final Map<LootRarity, Pair<StepFunction, StepFunction>> values;
    protected final int cooldown;
    protected final Set<LootCategory> types;
    protected final transient Map<LootRarity, EffectInst> effects;

    public PotionAffix(MobEffect effect, Target target, Map<LootRarity, Pair<StepFunction, StepFunction>> values, int cooldown, Set<LootCategory> types) {
        super(AffixType.ABILITY);
        this.effect = effect;
        this.target = target;
        this.values = values;
        this.cooldown = cooldown;
        this.types = types;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        values.forEach((rarity, pair) -> builder.put(rarity, (Object)new EffectInst(this.effect, (StepFunction)pair.getLeft(), (StepFunction)pair.getRight())));
        this.effects = builder.build();
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MobEffectInstance inst = this.effects.get(rarity).build(level);
        if (this.cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)this.cooldown)});
            list.accept((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{this.target.toComponent(PotionAffix.toComponent(inst)), cd}).m_130940_(ChatFormatting.YELLOW));
        } else {
            list.accept((Component)this.target.toComponent(PotionAffix.toComponent(inst)).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains(cat)) && this.effects.containsKey(rarity);
    }

    @Override
    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity attacker) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.HURT_SELF) {
            this.applyEffect(user, inst, level);
        } else if (this.target == Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ATTACK_SELF) {
            this.applyEffect(user, inst, level);
        } else if (this.target == Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((LivingEntity)player, inst, level);
        }
    }

    @Override
    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, float level, HitResult res, HitResult.Type type) {
        Entity entity;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ARROW_SELF) {
            Entity entity2 = arrow.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(owner, inst, level);
            }
        } else if (this.target == Target.ARROW_TARGET && type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(target, inst, level);
        }
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, inst, level);
        } else if (this.target == Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(target, inst, level);
        }
        return amount;
    }

    private void applyEffect(LivingEntity target, EffectInst inst, float level) {
        long lastApplied;
        MobEffectInstance mei = inst.build(level);
        if (this.cooldown != 0 && (lastApplied = target.getPersistentData().m_128454_("apoth.affix_cooldown." + this.getId().toString())) != 0L && lastApplied + (long)this.cooldown >= target.f_19853_.m_46467_()) {
            return;
        }
        target.m_7292_(mei);
        target.getPersistentData().m_128356_("apoth.affix_cooldown." + this.getId().toString(), target.f_19853_.m_46467_());
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker");

        public static final Codec<Target> CODEC;
        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return Component.m_237110_((String)("affix.apotheosis.target." + this.id), (Object[])args);
        }

        static {
            CODEC = new EnumCodec(Target.class);
        }
    }

    public record EffectInst(MobEffect effect, StepFunction duration, StepFunction amplifier) {
        public MobEffectInstance build(float level) {
            return new MobEffectInstance(this.effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }

        public void write(FriendlyByteBuf buf) {
            this.duration.write(buf);
            this.amplifier.write(buf);
        }

        public static EffectInst read(MobEffect effect, FriendlyByteBuf buf) {
            return new EffectInst(effect, StepFunction.read((FriendlyByteBuf)buf), StepFunction.read((FriendlyByteBuf)buf));
        }
    }
}

