/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.mixin.LivingEntityInvoker;
import shadows.placebo.util.StepFunction;

public class ExecutingAffix
extends Affix {
    public static final Codec<ExecutingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ExecutingAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public ExecutingAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ItemStack.f_41584_.format(100.0f * this.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        float threshold = this.getTrueLevel(rarity, level);
        if ((double)Apotheosis.localAtkStrength >= 0.98 && target instanceof LivingEntity) {
            DamageSource src;
            LivingEntity living = (LivingEntity)target;
            if (!living.f_19853_.f_46443_ && living.m_21223_() / living.m_21233_() < threshold && !((LivingEntityInvoker)living).callCheckTotemDeathProtection(src = new EntityDamageSource("apotheosis.execute", (Entity)user).m_19380_().m_19382_())) {
                SoundEvent soundevent = ((LivingEntityInvoker)living).callGetDeathSound();
                if (soundevent != null) {
                    living.m_5496_(soundevent, ((LivingEntityInvoker)living).callGetSoundVolume(), living.m_6100_());
                }
                living.m_21153_(0.0f);
                living.m_6667_(src);
            }
        }
    }
}

