/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class CatalyzingAffix
extends Affix {
    public static final Codec<CatalyzingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, CatalyzingAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public CatalyzingAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237115_((String)("affix." + this.getId() + ".desc")).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.SHIELD && this.values.containsKey(rarity);
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        if (source.m_19372_()) {
            int time = (int)((float)this.values.get(rarity).getInt(level) * amount);
            int modifier = 1 + (int)(amount / 12.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time, modifier));
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }
}

