/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.util.StepFunction;

public class AttributeAffix
extends Affix {
    public static final Codec<AttributeAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)new EnumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, AttributeAffix::new));
    protected final Attribute attribute;
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;
    protected final transient Map<LootRarity, ModifierInst> modifiers;

    public AttributeAffix(Attribute attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, Set<LootCategory> types) {
        super(AffixType.STAT);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
        this.types = types;
        this.modifiers = values.entrySet().stream().map(entry -> Pair.of((Object)((LootRarity)entry.getKey()), (Object)new ModifierInst(attr, op, (StepFunction)entry.getValue(), new HashMap<EquipmentSlot, UUID>()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
    }

    @Override
    public void addModifiers(ItemStack stack, LootRarity rarity, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        ModifierInst modif = this.modifiers.get(rarity);
        if (modif.attr == null) {
            AdventureModule.LOGGER.debug("The affix {} has attempted to apply a null attribute modifier to {}!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        for (EquipmentSlot slot : cat.getSlots(stack)) {
            if (slot != type) continue;
            map.accept(modif.attr, modif.build(slot, this.getId(), level));
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains(cat)) && this.modifiers.containsKey(rarity);
    }

    public record ModifierInst(Attribute attr, AttributeModifier.Operation op, StepFunction valueFactory, Map<EquipmentSlot, UUID> cache) {
        public AttributeModifier build(EquipmentSlot slot, ResourceLocation id, float level) {
            return new AttributeModifier(this.cache.computeIfAbsent(slot, k -> UUID.randomUUID()), "affix:" + id, (double)this.valueFactory.get(level), this.op);
        }
    }
}

