/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.AttributeAffix;
import shadows.apotheosis.adventure.affix.effect.CatalyzingAffix;
import shadows.apotheosis.adventure.affix.effect.CleavingAffix;
import shadows.apotheosis.adventure.affix.effect.DamageReductionAffix;
import shadows.apotheosis.adventure.affix.effect.DurableAffix;
import shadows.apotheosis.adventure.affix.effect.EnlightenedAffix;
import shadows.apotheosis.adventure.affix.effect.ExecutingAffix;
import shadows.apotheosis.adventure.affix.effect.FestiveAffix;
import shadows.apotheosis.adventure.affix.effect.MagicalArrowAffix;
import shadows.apotheosis.adventure.affix.effect.OmneticAffix;
import shadows.apotheosis.adventure.affix.effect.PotionAffix;
import shadows.apotheosis.adventure.affix.effect.PsychicAffix;
import shadows.apotheosis.adventure.affix.effect.RadialAffix;
import shadows.apotheosis.adventure.affix.effect.RetreatingAffix;
import shadows.apotheosis.adventure.affix.effect.SpectralShotAffix;
import shadows.apotheosis.adventure.affix.effect.TelepathicAffix;
import shadows.apotheosis.adventure.affix.effect.ThunderstruckAffix;
import shadows.apotheosis.adventure.affix.socket.SocketAffix;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.PlaceboJsonReloadListener;

public class AffixManager
extends PlaceboJsonReloadListener<Affix> {
    public static final AffixManager INSTANCE = new AffixManager();
    private Multimap<AffixType, Affix> byType = ImmutableMultimap.of();

    public AffixManager() {
        super(AdventureModule.LOGGER, "affixes", true, true);
    }

    protected void beginReload() {
        super.beginReload();
    }

    protected void onReload() {
        super.onReload();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.registry.values().forEach(a -> builder.put((Object)a.type, (Object)a));
        this.byType = builder.build();
        Preconditions.checkArgument((boolean)(Apoth.Affixes.SOCKET.get() instanceof SocketAffix), (Object)"Socket Affix not registered!");
        Preconditions.checkArgument((boolean)(Apoth.Affixes.DURABLE.get() instanceof DurableAffix), (Object)"Durable Affix not registered!");
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(Apotheosis.loc("attribute"), PSerializer.fromCodec((String)"Attribute Affix", AttributeAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("mob_effect"), PSerializer.fromCodec((String)"Potion Affix", PotionAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("damage_reduction"), PSerializer.fromCodec((String)"Damage Reduction Affix", DamageReductionAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("catalyzing"), PSerializer.fromCodec((String)"Catalyzing Affix", CatalyzingAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("cleaving"), PSerializer.fromCodec((String)"Cleaving Affix", CleavingAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("enlightened"), PSerializer.fromCodec((String)"Enlightened Affix", EnlightenedAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("executing"), PSerializer.fromCodec((String)"Executing Affix", ExecutingAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("festive"), PSerializer.fromCodec((String)"Festive Affix", FestiveAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("magical"), PSerializer.fromCodec((String)"Magical Affix", MagicalArrowAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("omnetic"), PSerializer.fromCodec((String)"Omnetic Affix", OmneticAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("psychic"), PSerializer.fromCodec((String)"Psychic Affix", PsychicAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("radial"), PSerializer.fromCodec((String)"Radial Affix", RadialAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("retreating"), PSerializer.fromCodec((String)"Retreating Affix", RetreatingAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("spectral"), PSerializer.fromCodec((String)"Spectral Affix", SpectralShotAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("telepathic"), PSerializer.fromCodec((String)"Telepathic Affix", TelepathicAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("thunderstruck"), PSerializer.fromCodec((String)"Thunderstruck Affix", ThunderstruckAffix.CODEC));
        this.registerSerializer(Apotheosis.loc("socket"), PSerializer.builtin((String)"Socket Affix", SocketAffix::new));
        this.registerSerializer(Apotheosis.loc("durable"), PSerializer.builtin((String)"Durable Affix", DurableAffix::new));
    }

    public Multimap<AffixType, Affix> getTypeMap() {
        return this.byType;
    }
}

