/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public record UpdateBuildingToolPacket(InteractionHand hand, Optional<BuildingToolMode> mode, Map<ToolModeProperty<?>, Object> properties, Optional<BlockPos> selectedPos, Optional<BlockState> selectedState, Optional<Integer> reachDistanceModifier) {
    public static void encoder(UpdateBuildingToolPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        UpdateBuildingToolPacket.writeOptional(buff, packet.mode.map(BuildingToolMode::getName), arg_0 -> ((FriendlyByteBuf)buff).m_130085_(arg_0));
        buff.writeInt(packet.properties.size());
        for (Map.Entry<ToolModeProperty<?>, Object> entry : packet.properties.entrySet()) {
            ToolModeProperty<?> property = entry.getKey();
            buff.m_130070_(property.getKey());
            buff.m_130070_(property.write(entry.getValue()));
        }
        UpdateBuildingToolPacket.writeOptional(buff, packet.selectedPos, arg_0 -> ((FriendlyByteBuf)buff).m_130064_(arg_0));
        UpdateBuildingToolPacket.writeOptional(buff, packet.selectedState.map(NbtUtils::m_129202_), arg_0 -> ((FriendlyByteBuf)buff).m_130079_(arg_0));
        UpdateBuildingToolPacket.writeOptional(buff, packet.reachDistanceModifier, arg_0 -> ((FriendlyByteBuf)buff).writeInt(arg_0));
    }

    private static <T> void writeOptional(FriendlyByteBuf buff, Optional<T> optional, Consumer<T> write) {
        buff.writeBoolean(optional.isPresent());
        if (optional.isPresent()) {
            write.accept(optional.get());
        }
    }

    public static UpdateBuildingToolPacket decoder(FriendlyByteBuf buff) {
        InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        Optional<BuildingToolMode> mode = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130281_(), () -> null).map(BuildingToolMode.REGISTRY::get);
        HashMap properties = new HashMap();
        int propertiesSize = buff.readInt();
        if (!mode.isPresent() && propertiesSize > 0) {
            StructureGelMod.LOGGER.warn("Can't read building tool properties from packet because no mode was sent", new Object[0]);
        } else {
            for (int i = 0; i < propertiesSize; ++i) {
                String k = buff.m_130277_();
                String v = buff.m_130277_();
                ToolModeProperty<?> property = mode.get().getProperties().get(k);
                properties.put(property, property.read(v));
            }
        }
        Optional<BlockPos> selectedPos = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130135_(), () -> null);
        Optional<BlockState> selectedState = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130260_(), () -> null).map(NbtUtils::m_129241_);
        Optional<Integer> reachDistanceModifier = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).readInt(), () -> 0);
        return new UpdateBuildingToolPacket(hand, mode, properties, selectedPos, selectedState, reachDistanceModifier);
    }

    private static <T> Optional<T> readOptional(FriendlyByteBuf buff, Supplier<T> read, Supplier<T> defaultVal) {
        boolean isPresent = buff.readBoolean();
        return Optional.ofNullable(isPresent ? read.get() : defaultVal.get());
    }

    public static void handler(UpdateBuildingToolPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            InteractionHand hand;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            ItemStack stack = player.m_21120_(hand = packet.hand);
            if (stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                int reach;
                if (packet.mode.isPresent()) {
                    BuildingToolMode mode = packet.mode.get();
                    if (BuildingToolItem.getMode(stack) != mode) {
                        BuildingToolItem.clearPoses(stack);
                    }
                    BuildingToolItem.setMode(stack, mode);
                    if (packet.selectedPos.isPresent() && mode instanceof BuildingToolMode.ForCorners) {
                        BuildingToolMode.ForCorners forCorners = (BuildingToolMode.ForCorners)mode;
                        forCorners.setPosition((Player)player, packet.selectedPos.get(), stack);
                    }
                }
                for (Map.Entry entry : packet.properties.entrySet()) {
                    ToolModeProperty prop = (ToolModeProperty)entry.getKey();
                    BuildingToolItem.setProperty(stack, prop, entry.getValue());
                }
                if (packet.selectedState.isPresent()) {
                    BuildingToolItem.setSelectedState(stack, packet.selectedState.get());
                }
                if (packet.reachDistanceModifier.isPresent() && ToolModeProperty.REACH_DISTANCE.isValid(reach = packet.reachDistanceModifier.get().intValue()) && reach != BuildingToolItem.getReachDistanceModifier(stack)) {
                    player.m_5661_((Component)Component.m_237110_((String)"info.structure_gel.building_tool.message.set_reach", (Object[])new Object[]{reach}), true);
                    BuildingToolItem.setReachDistanceModifier(stack, reach);
                }
                player.m_6674_(hand);
            }
        });
        context.get().setPacketHandled(true);
    }
}

