/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.tile;

import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.item.addon.RangeAddonItem;
import com.buuz135.industrial.proxy.client.IndustrialAssetProvider;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public abstract class IndustrialAreaWorkingTile<T extends IndustrialAreaWorkingTile<T>>
extends IndustrialWorkingTile<T> {
    @Save
    private int pointer = 0;
    @Save
    private boolean showingArea = false;
    private ButtonComponent areaButton = new ButtonComponent(136, 84, 14, 14){

        @OnlyIn(value=Dist.CLIENT)
        public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
            ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
            addons.add(() -> new StateButtonAddon(IndustrialAreaWorkingTile.this.areaButton, new StateButtonInfo[]{new StateButtonInfo(0, IndustrialAssetProvider.BUTTON_SHOW_AREA, new String[]{"text.industrialforegoing.button.show_area"}), new StateButtonInfo(1, IndustrialAssetProvider.BUTTON_HIDE_AREA, new String[]{"text.industrialforegoing.button.hide_area"})}){

                public int getState() {
                    return IndustrialAreaWorkingTile.this.showingArea ? 1 : 0;
                }
            });
            return addons;
        }
    }.setPredicate((playerEntity, compoundNBT) -> {
        this.showingArea = !this.showingArea;
        this.markForUpdate();
    });
    private RangeManager.RangeType type;
    private boolean acceptsRangeUpgrades;

    public IndustrialAreaWorkingTile(Pair<RegistryObject<Block>, RegistryObject<BlockEntityType<?>>> basicTileBlock, RangeManager.RangeType type, boolean acceptsRangeUpgrades, int estimatedPower, BlockPos blockPos, BlockState blockState) {
        super(basicTileBlock, estimatedPower, blockPos, blockState);
        this.addButton(this.areaButton);
        this.type = type;
        this.acceptsRangeUpgrades = acceptsRangeUpgrades;
    }

    public VoxelShape getWorkingArea() {
        return new RangeManager(this.f_58858_, this.getFacingDirection(), this.type).get(this.hasAugmentInstalled(RangeAddonItem.RANGE) ? (int)AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(RangeAddonItem.RANGE).get(0)), (IAugmentType)RangeAddonItem.RANGE) + 1 : 0);
    }

    public BlockPos getPointedBlockPos() {
        List<BlockPos> blockPosList = BlockUtils.getBlockPosInAABB(this.getWorkingArea().m_83215_());
        this.pointer = this.safetyPointerCheck(blockPosList);
        return blockPosList.get(this.pointer);
    }

    private int safetyPointerCheck(List<BlockPos> blockPosList) {
        return this.pointer < blockPosList.size() ? this.pointer : 0;
    }

    public void increasePointer() {
        BlockPos pointed = this.getPointedBlockPos();
        if (this.f_58857_ instanceof ServerLevel) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f((float)Math.abs(this.f_58858_.m_123341_() % 255) / 256.0f, (float)Math.abs(this.f_58858_.m_123342_() % 255) / 256.0f, (float)Math.abs(this.f_58858_.m_123343_() % 255) / 256.0f), 1.0f), (double)pointed.m_123341_() + 0.5, (double)(pointed.m_123342_() + 1), (double)pointed.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        ++this.pointer;
    }

    public boolean isShowingArea() {
        return this.showingArea;
    }

    public boolean isLoaded(BlockPos pos) {
        return this.f_58857_.m_46832_(pos, pos);
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        if (AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)RangeAddonItem.RANGE)) {
            return super.canAcceptAugment(augment) && this.acceptsRangeUpgrades;
        }
        return super.canAcceptAugment(augment);
    }

    public AABB getRenderBoundingBox() {
        return this.getWorkingArea().m_83215_();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        BlockPos pointed = this.getPointedBlockPos();
        if (!(level instanceof ServerLevel) || level.m_46467_() % 5L == 0L) {
            // empty if block
        }
    }
}

