/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.shared.integration.Optifine;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import net.minecraftforge.fml.ModList;

public class ShaderMod {
    public static final ShaderMod INSTANCE = ModList.get().isLoaded("oculus") ? new IrisImpl() : new ShaderMod();

    public boolean isShaderMod() {
        return Optifine.isLoaded();
    }

    public boolean isRenderingShadowPass() {
        return false;
    }

    public DirectFixedWidthFontRenderer.QuadEmitter getQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
        return new DirectFixedWidthFontRenderer.ByteBufferEmitter(makeBuffer.apply(RenderTypes.TERMINAL.m_110508_().m_86020_() * vertexCount * 4));
    }

    private static final class IrisImpl
    extends ShaderMod {
        private IrisImpl() {
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }

        @Override
        public boolean isShaderMod() {
            return true;
        }

        @Override
        public DirectFixedWidthFontRenderer.QuadEmitter getQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
            return IrisApi.getInstance().getMinorApiRevision() >= 1 ? new IrisQuadEmitter(vertexCount, makeBuffer) : super.getQuadEmitter(vertexCount, makeBuffer);
        }

        private static final class IrisQuadEmitter
        implements DirectFixedWidthFontRenderer.QuadEmitter {
            private final IrisTextVertexSink sink;

            private IrisQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
                this.sink = IrisApi.getInstance().createTextVertexSink(vertexCount, makeBuffer);
            }

            @Override
            public VertexFormat format() {
                return this.sink.getUnderlyingVertexFormat();
            }

            @Override
            public ByteBuffer buffer() {
                return this.sink.getUnderlyingByteBuffer();
            }

            @Override
            public void quad(float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2) {
                this.sink.quad(x1, y1, x2, y2, z, IrisQuadEmitter.pack(rgba[0], rgba[1], rgba[2], rgba[3]), u1, v1, u2, v2, 0xF000F0);
            }

            private static int pack(int r, int g, int b, int a) {
                return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
            }
        }
    }
}

