/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.improvableskills.ImprovableSkills;
import org.zeith.improvableskills.api.PlayerSkillData;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.cfg.ConfigsIS;
import org.zeith.improvableskills.data.PlayerDataManager;
import org.zeith.improvableskills.net.NetSkillCalculator;

public class CommandImprovableSkills {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        IForgeRegistry<PlayerSkillBase> $skills = ImprovableSkills.SKILLS();
        IForgeRegistry<PlayerAbilityBase> $abilities = ImprovableSkills.ABILITIES();
        ResourceKeyArgument skillArg = ResourceKeyArgument.m_212386_((ResourceKey)$skills.getRegistryKey());
        ResourceKeyArgument abilArg = ResourceKeyArgument.m_212386_((ResourceKey)$abilities.getRegistryKey());
        SuggestionProvider skillSuggestions = (src, builder) -> {
            $skills.getKeys().stream().map(ResourceLocation::toString).filter(s -> s.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
        SuggestionProvider abilSuggestions = (src, builder) -> {
            $abilities.getKeys().stream().map(ResourceLocation::toString).filter(s -> s.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"improvableskills").requires(executor -> executor.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(src -> {
            ConfigsIS.config.load();
            ConfigsIS.reloadCustom(ConfigsIS.config);
            ConfigsIS.reloadCosts();
            NetSkillCalculator.pack().build().sendToAll();
            if (ConfigsIS.config.hasChanged()) {
                ConfigsIS.config.save();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)"Configs have been reloaded."), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"skills").then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"skill", (ArgumentType)skillArg).suggests(skillSuggestions).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(src -> {
            ResourceKey key = (ResourceKey)src.getArgument("skill", ResourceKey.class);
            PlayerSkillBase skill = (PlayerSkillBase)ImprovableSkills.SKILLS().getValue(key.m_135782_());
            int level = IntegerArgumentType.getInteger((CommandContext)src, (String)"level");
            if (skill == null) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Skill " + JSONObject.quote((String)key.m_135782_().toString()) + " not found."))).create();
            }
            if (level > skill.getMaxLevel()) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Unable to set skill level to " + level + ", as the max level for ")).m_7220_((Component)skill.getLocalizedName()).m_130946_(" is " + skill.getMaxLevel() + ".")).create();
            }
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                pd.setSkillLevel(skill, level);
                if (level > 0 && skill.getScrollState().hasScroll()) {
                    pd.unlockSkillScroll(skill, true);
                }
                ++updated;
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)"Skill ").m_7220_((Component)skill.getLocalizedName()).m_130946_(" set to level " + level + " for " + updated + " players."), true);
            return updated;
        }))))).then(Commands.m_82127_((String)"everything").executes(src -> {
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                for (PlayerSkillBase skill : ImprovableSkills.SKILLS().getValues()) {
                    pd.setSkillLevel(skill, skill.getMaxLevel());
                    if (!skill.getScrollState().hasScroll()) continue;
                    pd.unlockSkillScroll(skill, false);
                }
                ++updated;
                pd.sync();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)("All skills have been given at their max levels for " + updated + " players.")), true);
            return updated;
        }))))).then(Commands.m_82127_((String)"revoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"skill", (ArgumentType)skillArg).suggests(skillSuggestions).executes(src -> {
            ResourceKey key = (ResourceKey)src.getArgument("skill", ResourceKey.class);
            PlayerSkillBase skill = (PlayerSkillBase)ImprovableSkills.SKILLS().getValue(key.m_135782_());
            int level = 0;
            if (skill == null) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Skill " + JSONObject.quote((String)key.m_135782_().toString()) + " not found."))).create();
            }
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                pd.setSkillLevel(skill, level);
                pd.lockSkillScroll(skill, true);
                ++updated;
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)"Skill ").m_7220_((Component)skill.getLocalizedName()).m_130946_(" revoked from " + updated + " players."), true);
            return updated;
        })))).then(Commands.m_82127_((String)"everything").executes(src -> {
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                for (PlayerSkillBase skill : ImprovableSkills.SKILLS().getValues()) {
                    pd.setSkillLevel(skill, 0);
                    pd.lockSkillScroll(skill, false);
                }
                pd.sync();
                ++updated;
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)("All skills have been revoked from " + updated + " players.")), true);
            return updated;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"abilities").then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"ability", (ArgumentType)abilArg).suggests(abilSuggestions).executes(src -> {
            ResourceKey key = (ResourceKey)src.getArgument("ability", ResourceKey.class);
            PlayerAbilityBase abil = (PlayerAbilityBase)ImprovableSkills.ABILITIES().getValue(key.m_135782_());
            if (abil == null) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Ability " + JSONObject.quote((String)key.m_135782_().toString()) + " not found."))).create();
            }
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                pd.unlockAbility(abil, true);
                ++updated;
                pd.sync();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)"Ability ").m_7220_((Component)abil.getLocalizedName()).m_130946_(" unlocked for " + updated + " players."), true);
            return updated;
        })))).then(Commands.m_82127_((String)"everything").executes(src -> {
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                for (PlayerAbilityBase skill : ImprovableSkills.ABILITIES().getValues()) {
                    pd.unlockAbility(skill, false);
                }
                ++updated;
                pd.sync();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)("All abilities have been unlocked for " + updated + " players.")), true);
            return updated;
        }))))).then(Commands.m_82127_((String)"revoke").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"only").then(Commands.m_82129_((String)"ability", (ArgumentType)abilArg).suggests(abilSuggestions).executes(src -> {
            ResourceKey key = (ResourceKey)src.getArgument("ability", ResourceKey.class);
            PlayerAbilityBase abil = (PlayerAbilityBase)ImprovableSkills.ABILITIES().getValue(key.m_135782_());
            if (abil == null) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Ability " + JSONObject.quote((String)key.m_135782_().toString()) + " not found."))).create();
            }
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                pd.lockAbility(abil, true);
                ++updated;
                pd.sync();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)"Ability ").m_7220_((Component)abil.getLocalizedName()).m_130946_(" revoked for " + updated + " players."), true);
            return updated;
        })))).then(Commands.m_82127_((String)"everything").executes(src -> {
            int updated = 0;
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)src, (String)"targets")) {
                PlayerSkillData pd = PlayerDataManager.getDataFor((Player)player);
                if (pd == null) continue;
                for (PlayerAbilityBase skill : ImprovableSkills.ABILITIES().getValues()) {
                    pd.lockAbility(skill, false);
                }
                ++updated;
                pd.sync();
            }
            ((CommandSourceStack)src.getSource()).m_81354_((Component)Component.m_237113_((String)("All abilities have been revoked for " + updated + " players.")), true);
            return updated;
        }))))));
    }
}

