/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.improvableskills;

import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.api.registry.RegistryMapping;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.core.adapter.ModSourceAdapter;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.improvableskills.api.RecipeParchmentFragment;
import org.zeith.improvableskills.api.loot.RandomBoolean;
import org.zeith.improvableskills.api.loot.SkillLoot;
import org.zeith.improvableskills.api.registry.PageletBase;
import org.zeith.improvableskills.api.registry.PlayerAbilityBase;
import org.zeith.improvableskills.api.registry.PlayerSkillBase;
import org.zeith.improvableskills.cfg.ConfigsIS;
import org.zeith.improvableskills.command.CommandImprovableSkills;
import org.zeith.improvableskills.custom.items.ItemAbilityScroll;
import org.zeith.improvableskills.init.AbilitiesIS;
import org.zeith.improvableskills.init.ItemsIS;
import org.zeith.improvableskills.init.TreasuresIS;
import org.zeith.improvableskills.proxy.ISClient;
import org.zeith.improvableskills.proxy.ISServer;

@Mod(value="improvableskills")
public class ImprovableSkills {
    public static final Logger LOG = LogManager.getLogger((String)"ImprovableSkills");
    public static final String MOD_ID = "improvableskills";
    public static final String MOD_NAME = "Improvable Skills";
    public static final String NBT_DATA_TAG = "ImprovableSkillsData";
    public static final ISServer PROXY = (ISServer)DistExecutor.unsafeRunForDist(() -> ISClient::new, () -> ISServer::new);
    public static final CreativeModeTab TAB = new CreativeModeTab("improvableskills"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemsIS.SKILLS_BOOK);
        }
    };
    private static Supplier<IForgeRegistry<PlayerSkillBase>> SKILLS;
    private static Supplier<IForgeRegistry<PlayerAbilityBase>> ABILITIES;
    private static Supplier<IForgeRegistry<PageletBase>> PAGELETS;

    public ImprovableSkills() {
        ModSourceAdapter.ModSource illegalSourceNotice = ModSourceAdapter.getModSource(ImprovableSkills.class).filter(ModSourceAdapter.ModSource::wasDownloadedIllegally).orElse(null);
        if (illegalSourceNotice != null) {
            LOG.fatal("====================================================");
            LOG.fatal("WARNING: ImprovableSkills was downloaded from " + illegalSourceNotice.referrerDomain() + ", which has been marked as illegal site over at stopmodreposts.org.");
            LOG.fatal("Please download the mod from https://www.curseforge.com/minecraft/mc-mods/improvable-skills");
            LOG.fatal("====================================================");
            MutableComponent illegalUri = Component.m_237113_((String)illegalSourceNotice.referrerDomain()).m_130938_(s -> s.m_131140_(ChatFormatting.RED));
            MutableComponent smrUri = Component.m_237113_((String)"stopmodreposts.org").m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://stopmodreposts.org/")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open webpage."))));
            MutableComponent curseforgeUri = Component.m_237113_((String)"curseforge.com").m_130938_(s -> s.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/improvable-skills")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open webpage."))));
            ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.m_237113_((String)"WARNING: ImprovableSkills was downloaded from ").m_7220_((Component)illegalUri).m_130946_(", which has been marked as illegal site over at ").m_7220_((Component)smrUri).m_130946_(". Please download the mod from ").m_7220_((Component)curseforgeUri).m_130946_("."));
        }
        LanguageAdapter.registerMod((String)MOD_ID);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::newRegistries);
        modBus.addListener(this::setup);
        modBus.addListener(this::loadComplete);
        PROXY.register(modBus);
        IEventBus mcfBus = MinecraftForge.EVENT_BUS;
        mcfBus.addListener(this::registerCommands);
        mcfBus.addListener(this::addLoot);
        HammerLib.EVENT_BUS.addListener(this::addRecipes);
    }

    private void registerCommands(RegisterCommandsEvent e) {
        CommandImprovableSkills.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher(), e.getBuildContext());
    }

    private void setup(FMLCommonSetupEvent e) {
        TreasuresIS.register();
    }

    private void loadComplete(FMLLoadCompleteEvent e) {
        ConfigsIS.reloadCosts();
        if (ConfigsIS.config.hasChanged()) {
            ConfigsIS.config.save();
        }
    }

    private void newRegistries(NewRegistryEvent e) {
        SKILLS = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "skills")).disableSync(), reg -> RegistryMapping.report(PlayerSkillBase.class, (IForgeRegistry)reg, (boolean)false));
        ABILITIES = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "abilities")).disableSync(), reg -> RegistryMapping.report(PlayerAbilityBase.class, (IForgeRegistry)reg, (boolean)false));
        PAGELETS = e.create(new RegistryBuilder().setName(new ResourceLocation(MOD_ID, "pagelets")).disableSync(), reg -> RegistryMapping.report(PageletBase.class, (IForgeRegistry)reg, (boolean)false));
    }

    private void addLoot(LootTableLoadEvent e) {
        for (PlayerSkillBase skill : ImprovableSkills.SKILLS()) {
            SkillLoot loot = skill.getLoot();
            if (loot == null) continue;
            loot.apply(e);
        }
        if (e.getName().toString().toLowerCase().contains("chests/")) {
            RandomBoolean bool = new RandomBoolean();
            bool.n = 5;
            LOG.info("Injecting parchment into LootTable '" + e.getName() + "'!");
            try {
                LootTable table = e.getTable();
                table.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ItemsIS.PARCHMENT_FRAGMENT).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79707_(1).m_79711_(60)).name("parchment_fragment").m_79082_());
            }
            catch (Throwable err) {
                LOG.error("Failed to inject parchment into LootTable '" + e.getName() + "'!!!");
                err.printStackTrace();
            }
        }
    }

    private void addRecipes(RegisterRecipesEvent e) {
        ((ShapedRecipeBuilder)e.shaped().shape(new String[]{"lbl", "pgp", "lbl"}).map('l', (Object)Tags.Items.LEATHER).map('b', (Object)Items.f_42517_).map('p', (Object)Items.f_42516_).map('g', (Object)Tags.Items.INGOTS_GOLD).result((ItemLike)ItemsIS.SKILLS_BOOK)).register();
        ((ShapelessRecipeBuilder)e.shapeless().add((Object)ItemsIS.PARCHMENT_FRAGMENT).result(new ItemStack((ItemLike)Items.f_42516_, 7))).register();
        e.add((Recipe)new RecipeParchmentFragment(AbilitiesIS.ANVIL.getRegistryName(), ItemAbilityScroll.of(AbilitiesIS.ANVIL), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{RecipeHelper.fromTag((TagKey)Tags.Items.ENDER_PEARLS), RecipeHelper.fromComponent((Object)Items.f_42146_), RecipeHelper.fromTag((TagKey)Tags.Items.GEMS_EMERALD)})));
        e.add((Recipe)new RecipeParchmentFragment(AbilitiesIS.CRAFTER.getRegistryName(), ItemAbilityScroll.of(AbilitiesIS.CRAFTER), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{RecipeHelper.fromTag((TagKey)Tags.Items.ENDER_PEARLS), RecipeHelper.fromComponent((Object)Items.f_41960_), RecipeHelper.fromTag((TagKey)Tags.Items.INGOTS_IRON)})));
        e.add((Recipe)new RecipeParchmentFragment(AbilitiesIS.ENCHANTING.getRegistryName(), ItemAbilityScroll.of(AbilitiesIS.ENCHANTING), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{RecipeHelper.fromTag((TagKey)Tags.Items.ENDER_PEARLS), RecipeHelper.fromComponent((Object)Items.f_42100_), RecipeHelper.fromComponent((Object)Items.f_41997_)})));
        e.add((Recipe)new RecipeParchmentFragment(AbilitiesIS.MAGNETISM.getRegistryName(), ItemAbilityScroll.of(AbilitiesIS.MAGNETISM), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{RecipeHelper.fromTag((TagKey)Tags.Items.ENDER_PEARLS), RecipeHelper.fromComponent((Object)Items.f_42545_), RecipeHelper.fromComponent((Object)Items.f_42416_), RecipeHelper.fromComponent((Object)Items.f_42026_)})));
        e.add((Recipe)new RecipeParchmentFragment(AbilitiesIS.AUTO_XP_BANK.getRegistryName(), ItemAbilityScroll.of(AbilitiesIS.AUTO_XP_BANK), (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{RecipeHelper.fromTag((TagKey)Tags.Items.ENDER_PEARLS), RecipeHelper.fromComponent((Object)Items.f_42612_), RecipeHelper.fromComponent((Object)Items.f_42451_)})));
    }

    public static IForgeRegistry<PlayerSkillBase> SKILLS() {
        return SKILLS.get();
    }

    public static IForgeRegistry<PlayerAbilityBase> ABILITIES() {
        return ABILITIES.get();
    }

    public static IForgeRegistry<PageletBase> PAGELETS() {
        return PAGELETS.get();
    }
}

