/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import quek.undergarden.block.fluid.VirulentMixFluid;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class UGFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"undergarden");
    public static final DeferredRegister<FluidType> TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"undergarden");
    public static final RegistryObject<FluidType> VIRULENT_MIX_TYPE = TYPES.register("virulent_mix", () -> new FluidType(FluidType.Properties.create().descriptionId("block.undergarden.virulent_mix").motionScale(0.00116666666).canExtinguish(true).supportsBoating(true).lightLevel(10).density(1500).temperature(600).viscosity(1000).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)UGSoundEvents.BUCKET_EMPTY_VIRULENT.get()).sound(SoundActions.BUCKET_FILL, (SoundEvent)UGSoundEvents.BUCKET_FILL_VIRULENT.get())){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_still");
                }

                public ResourceLocation getFlowingTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_flow");
                }

                public ResourceLocation getOverlayTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_flow");
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.22352941f, 0.09803922f, 0.3137255f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.m_157445_((float)0.0f);
                    RenderSystem.m_157443_((float)3.0f);
                }
            });
        }
    });
    public static final RegistryObject<FlowingFluid> VIRULENT_MIX_SOURCE = FLUIDS.register("virulent_mix_source", () -> new VirulentMixFluid.Source(VIRULENT_MIX_PROPERTIES));
    public static final RegistryObject<FlowingFluid> VIRULENT_MIX_FLOWING = FLUIDS.register("virulent_mix_flowing", () -> new VirulentMixFluid.Flowing(VIRULENT_MIX_PROPERTIES));
    public static final ForgeFlowingFluid.Properties VIRULENT_MIX_PROPERTIES = new ForgeFlowingFluid.Properties(VIRULENT_MIX_TYPE, VIRULENT_MIX_SOURCE, VIRULENT_MIX_FLOWING).bucket(UGItems.VIRULENT_MIX_BUCKET).block(UGBlocks.VIRULENT_MIX);
}

