/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.projectile.slingshot;

import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class SlingshotProjectile
extends ThrowableItemProjectile {
    protected boolean ricochet;
    protected int ricochetTimes = 0;
    private boolean dropItem;

    public SlingshotProjectile(EntityType<? extends ThrowableItemProjectile> type, Level level) {
        super(type, level);
    }

    public SlingshotProjectile(EntityType<? extends ThrowableItemProjectile> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public SlingshotProjectile(EntityType<? extends ThrowableItemProjectile> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockState blockstate = this.f_19853_.m_8055_(result.m_82425_());
        LivingEntity shooter = (LivingEntity)this.m_37282_();
        if (!blockstate.m_60812_((BlockGetter)this.f_19853_, result.m_82425_()).m_83281_()) {
            this.m_7355_(result.m_82425_(), blockstate);
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)3);
                if (this.ricochet) {
                    Vec3 delta = this.m_20184_();
                    Direction direction = result.m_82434_();
                    float velocity = (float)delta.m_82553_() / 2.0f;
                    if (direction == Direction.UP || direction == Direction.DOWN) {
                        this.m_6686_(delta.f_82479_, delta.m_82548_().f_82480_, delta.f_82481_, velocity, 1.0f);
                    } else if (direction == Direction.WEST || direction == Direction.EAST) {
                        this.m_6686_(delta.m_82548_().f_82479_, delta.m_82548_().f_82480_, delta.f_82481_, velocity, 1.0f);
                    } else {
                        this.m_6686_(delta.f_82479_, delta.m_82548_().f_82480_, delta.m_82548_().f_82481_, velocity, 1.0f);
                    }
                    --this.ricochetTimes;
                    if (this.ricochetTimes == 0) {
                        this.m_146870_();
                        if (shooter instanceof Player && !((Player)shooter).m_150110_().f_35937_ && this.dropItem) {
                            this.m_19983_(new ItemStack((ItemLike)this.m_7881_()));
                        }
                    }
                } else {
                    this.m_146870_();
                    if (shooter instanceof Player && !((Player)shooter).m_150110_().f_35937_ && this.dropItem) {
                        this.m_19983_(new ItemStack((ItemLike)this.m_7881_()));
                    }
                }
            }
        }
    }

    public void setRicochetTimes(int times) {
        this.ricochet = true;
        this.ricochetTimes = times;
    }

    protected void setDropItem(boolean dropItem) {
        this.dropItem = dropItem;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

