/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.boss;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.registry.UGSoundEvents;

public class ForgottenGuardian
extends Monster {
    private int attackTimer;

    public ForgottenGuardian(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
        this.f_21364_ = 30;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_STEP.get(), 0.5f, 1.0f);
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
            this.m_146870_();
        } else {
            this.f_20891_ = 0;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.m_5912_() && this.f_19862_ && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
            AABB axisalignedbb = this.m_20191_().m_82377_(0.2, 0.0, 0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)axisalignedbb.f_82288_), (int)Mth.m_14107_((double)axisalignedbb.f_82289_), (int)Mth.m_14107_((double)axisalignedbb.f_82290_), (int)Mth.m_14107_((double)axisalignedbb.f_82291_), (int)Mth.m_14107_((double)axisalignedbb.f_82292_), (int)Mth.m_14107_((double)axisalignedbb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13070_)) continue;
                this.f_19853_.m_46953_(blockpos, false, (Entity)this);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        this.attackTimer = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        this.m_5496_((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_ATTACK.get(), 1.0f, 1.0f);
        return super.m_7327_(entity);
    }

    protected void m_6731_(LivingEntity entity) {
        double x = entity.m_20185_() - this.m_20185_();
        double z = entity.m_20189_() - this.m_20189_();
        double modifier = Math.max(x * x + z * z, 0.001);
        entity.m_5997_(x / modifier * 2.0, (double)0.2f, z / modifier * 2.0);
        entity.f_19864_ = true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (entity instanceof Projectile) {
            this.m_5496_((SoundEvent)UGSoundEvents.FORGOTTEN_GUARDIAN_DEFLECT.get(), 1.0f, 1.0f);
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected PathNavigation m_6037_(Level level) {
        return new Navigator((Mob)this, level);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    static class Navigator
    extends GroundPathNavigation {
        public Navigator(Mob entity, Level level) {
            super(entity, level);
        }

        protected PathFinder m_5532_(int range) {
            this.f_26508_ = new Processor();
            return new PathFinder(this.f_26508_, range);
        }
    }

    static class Processor
    extends WalkNodeEvaluator {
        private Processor() {
        }

        protected BlockPathTypes m_6603_(BlockGetter level, boolean p_215744_2_, boolean p_215744_3_, BlockPos pos, BlockPathTypes pathNodeType) {
            return BlockPathTypes.WALKABLE;
        }
    }
}

