/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.client.model.BruteModel;
import quek.undergarden.client.model.DwellerModel;
import quek.undergarden.client.model.ForgottenGuardianModel;
import quek.undergarden.client.model.GloomperModel;
import quek.undergarden.client.model.GwibModel;
import quek.undergarden.client.model.GwiblingModel;
import quek.undergarden.client.model.MasticatorModel;
import quek.undergarden.client.model.MinionModel;
import quek.undergarden.client.model.MogModel;
import quek.undergarden.client.model.MuncherModel;
import quek.undergarden.client.model.NargoyleModel;
import quek.undergarden.client.model.RotbeastModel;
import quek.undergarden.client.model.RotlingModel;
import quek.undergarden.client.model.RotwalkerModel;
import quek.undergarden.client.model.ScintlingModel;
import quek.undergarden.client.model.SploogieModel;
import quek.undergarden.client.model.StonebornModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.blockentity.DepthrockBedRender;
import quek.undergarden.client.render.blockentity.GrongletRender;
import quek.undergarden.client.render.entity.BoomgourdRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.ForgottenGuardianRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GrongletEntityRender;
import quek.undergarden.client.render.entity.GwibRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MasticatorRender;
import quek.undergarden.client.render.entity.MinionRender;
import quek.undergarden.client.render.entity.MogRender;
import quek.undergarden.client.render.entity.MuncherRender;
import quek.undergarden.client.render.entity.NargoyleRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.SploogieRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.client.render.entity.UGBoatRenderer;
import quek.undergarden.entity.UGBoat;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;

@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class UndergardenClient {
    private static final ResourceLocation VIRULENCE_HEARTS = new ResourceLocation("undergarden", "textures/gui/virulence_hearts.png");
    private static final ResourceLocation BRITTLENESS_ARMOR = new ResourceLocation("undergarden", "textures/gui/brittleness_armor.png");

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get(), DepthrockBedRender::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.UNDERGARDEN_SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.GRONGLET.get(), GrongletRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOAT.get(), context -> new UGBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)UGEntityTypes.CHEST_BOAT.get(), context -> new UGBoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOOMGOURD.get(), BoomgourdRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GOO_BALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTTEN_BLISTERBERRY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BLISTERBOMB.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GRONGLET.get(), GrongletEntityRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION.get(), MinionRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTLING.get(), RotlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTWALKER.get(), RotwalkerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTBEAST.get(), RotbeastRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DWELLER.get(), DwellerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIBLING.get(), GwiblingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BRUTE.get(), BruteRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SCINTLING.get(), ScintlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GLOOMPER.get(), GloomperRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.STONEBORN.get(), StonebornRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.NARGOYLE.get(), NargoyleRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MUNCHER.get(), MuncherRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SPLOOGIE.get(), SploogieRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIB.get(), GwibRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MOG.get(), MogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MASTICATOR.get(), MasticatorRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), ForgottenGuardianRender::new);
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_HEAD, DepthrockBedRender::createHeadLayer);
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_FOOT, DepthrockBedRender::createFootLayer);
        event.registerLayerDefinition(UGModelLayers.GRONGLET, GrongletRender::createBodyLayer);
        for (UGBoat.Type boatType : UGBoat.Type.values()) {
            event.registerLayerDefinition(UGBoatRenderer.createBoatModelName(boatType), () -> BoatModel.m_233347_((boolean)false));
            event.registerLayerDefinition(UGBoatRenderer.createChestBoatModelName(boatType), () -> BoatModel.m_233347_((boolean)true));
        }
        event.registerLayerDefinition(UGModelLayers.MINION, MinionModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTLING, RotlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTWALKER, RotwalkerModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTBEAST, RotbeastModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.DWELLER, () -> DwellerModel.createBodyLayer(0.0f));
        event.registerLayerDefinition(UGModelLayers.DWELLER_SADDLE, () -> DwellerModel.createBodyLayer(0.5f));
        event.registerLayerDefinition(UGModelLayers.GWIBLING, GwiblingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.BRUTE, BruteModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SCINTLING, ScintlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GLOOMPER, GloomperModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.STONEBORN, StonebornModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.NARGOYLE, NargoyleModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MUNCHER, MuncherModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SPLOOGIE, SploogieModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GWIB, GwibModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MOG, MogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MASTICATOR, MasticatorModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_GUARDIAN, ForgottenGuardianModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tintGetter, pos, tint) -> tintGetter != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)tintGetter, (BlockPos)pos) : new Color(91, 117, 91).getRGB(), new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPTURF.get(), (Block)UGBlocks.SHIMMERWEED.get(), (Block)UGBlocks.TALL_DEEPTURF.get(), (Block)UGBlocks.TALL_SHIMMERWEED.get(), (Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), (Block)UGBlocks.POTTED_SHIMMERWEED.get(), (Block)UGBlocks.DROOPVINE.get(), (Block)UGBlocks.DROOPVINE_PLANT.get()});
        event.register((state, world, pos, tint) -> new Color(54, 45, 66).getRGB(), new Block[]{(Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors bColors = event.getBlockColors();
        event.register((stack, tint) -> bColors.m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, 0), new ItemLike[]{(ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (ItemLike)UGBlocks.DEEPTURF.get(), (ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_DEEPTURF.get()});
        event.register((stack, tint) -> {
            if (tint == 0) {
                return new Color(91, 117, 91).getRGB();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get()});
    }

    @SubscribeEvent
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(UGDimensions.UNDERGARDEN_LEVEL.m_135782_(), new DimensionSpecialEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true){

            public Vec3 m_5927_(Vec3 fogColor, float brightness) {
                return fogColor;
            }

            public boolean m_5781_(int x, int y) {
                return false;
            }
        });
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "virulence_hearts", (gui, stack, partialTick, width, height) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && player.m_21023_((MobEffect)UGEffects.VIRULENCE.get()) && gui.shouldDrawSurvivalElements()) {
                UndergardenClient.renderVirulenceHearts(width, height, stack, gui, (Player)player);
            }
        });
        event.registerAbove(VanillaGuiOverlay.ARMOR_LEVEL.id(), "brittleness_armor", (gui, stack, partialTick, width, height) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && player.m_21023_((MobEffect)UGEffects.BRITTLENESS.get()) && gui.shouldDrawSurvivalElements()) {
                UndergardenClient.renderBrittlenessArmor(width, height, stack, gui, (Player)player);
            }
        });
    }

    private static void renderBrittlenessArmor(int width, int height, PoseStack stack, ForgeGui gui, Player player) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BRITTLENESS_ARMOR);
        RenderSystem.m_69478_();
        int x = width / 2 - 91;
        int y = height - 49;
        int level = player.m_21230_();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                gui.m_93228_(stack, x, y, 34, 9, 9, 9);
            } else if (i == level) {
                gui.m_93228_(stack, x, y, 25, 9, 9, 9);
            } else {
                gui.m_93228_(stack, x, y, 16, 9, 9, 9);
            }
            x += 8;
        }
        gui.leftHeight += 10;
        RenderSystem.m_69461_();
    }

    private static void renderVirulenceHearts(int width, int height, PoseStack stack, ForgeGui gui, Player player) {
        boolean highlight;
        RenderSystem.m_157456_((int)0, (ResourceLocation)VIRULENCE_HEARTS);
        RenderSystem.m_69478_();
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean bl = highlight = gui.f_92976_ > (long)gui.m_93079_() && (gui.f_92976_ - (long)gui.m_93079_()) / 3L % 2L == 1L;
        if (health < gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.m_93079_() + 20;
        } else if (health > gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.m_93079_() + 10;
        }
        if (Util.m_137550_() - gui.f_92975_ > 1000L) {
            gui.f_92973_ = health;
            gui.f_92974_ = health;
            gui.f_92975_ = Util.m_137550_();
        }
        gui.f_92973_ = health;
        int healthLast = gui.f_92974_;
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        gui.f_92985_.m_188584_((long)gui.m_93079_() * 312871L);
        int x = width / 2 - 91;
        int y = height - 39;
        gui.leftHeight += healthRows * rowHeight;
        if (rowHeight != 10) {
            gui.leftHeight += 10 - rowHeight;
        }
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = gui.m_93079_() % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        UndergardenClient.renderHearts(stack, gui, player, x, y, rowHeight, regen, healthMax, health, healthLast, absorb, highlight);
        RenderSystem.m_69461_();
    }

    private static void renderHearts(PoseStack stack, ForgeGui gui, Player player, int x, int y, int height, int regen, float healthMax, int health, int healthLast, int absorb, boolean highlight) {
        Gui.HeartType heartType = Gui.HeartType.m_168732_((Player)player);
        int hardcoreOffset = 9 * (player.f_19853_.m_6106_().m_5466_() ? 5 : 0);
        int healthAmount = Mth.m_14165_((double)((double)healthMax / 2.0));
        int absorptionAmount = Mth.m_14165_((double)((double)absorb / 2.0));
        int l = healthAmount * 2;
        for (int i1 = healthAmount + absorptionAmount - 1; i1 >= 0; --i1) {
            int k2;
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int newX = x + k1 * 8;
            int newY = y - j1 * height;
            if (health + absorb <= 4) {
                newY += gui.f_92985_.m_188503_(2);
            }
            if (i1 < healthAmount && i1 == regen) {
                newY -= 2;
            }
            gui.m_168700_(stack, Gui.HeartType.CONTAINER, newX, newY, hardcoreOffset, highlight, false);
            int j2 = i1 * 2;
            boolean bl = flag = i1 >= healthAmount;
            if (flag && (k2 = j2 - l) < absorb) {
                boolean flag1 = k2 + 1 == absorb;
                gui.m_168700_(stack, heartType == Gui.HeartType.WITHERED ? heartType : Gui.HeartType.ABSORBING, newX, newY, hardcoreOffset, false, flag1);
            }
            if (highlight && j2 < healthLast) {
                boolean flag2 = j2 + 1 == healthLast;
                gui.m_168700_(stack, heartType, newX, newY, hardcoreOffset, true, flag2);
            }
            if (j2 >= health) continue;
            boolean flag3 = j2 + 1 == health;
            gui.m_168700_(stack, heartType, newX, newY, hardcoreOffset, false, flag3);
        }
    }

    @Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void overlaysPre(RenderGuiOverlayEvent.Pre event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && event.getOverlay().id() == VanillaGuiOverlay.PLAYER_HEALTH.id() && player.m_21023_((MobEffect)UGEffects.VIRULENCE.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void undergardenFog(ViewportEvent.RenderFog event) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            Camera camera = event.getCamera();
            if (player != null && player.m_9236_().m_46472_() == UGDimensions.UNDERGARDEN_LEVEL && camera.m_167685_() == FogType.NONE && camera.getBlockAtCamera().m_60819_().m_76178_()) {
                RenderSystem.m_157445_((float)0.0f);
                RenderSystem.m_157443_((float)200.0f);
                RenderSystem.m_202160_((FogShape)FogShape.SPHERE);
            }
        }
    }
}

