/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.Occultism;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class TextUtil {
    private static final Map<String, String> MOD_NAME_TO_ID = new HashMap<String, String>();
    private static final String[] EASTER_EGGS = new String[]{"KliKli", "Xalmas", "Toastbroat", "Najlitarvan", "TheBoo", "Ridanisaurus", "Legiaseth", "Vallen", "Vemerion", "Eqis"};
    private static final String[] SYLLABLE1 = new String[]{"Kr", "Ca", "Ra", "Mrok", "Cru", "Ray", "Bre", "Zed", "Drak", "Mor", "Jag", "Mer", "Jar", "Mjol", "Zork", "Mad", "Cry", "Zur", "Creo", "Azak", "Azur", "Rei", "Cro", "Mar", "Luk", "Bar", "Gor", "Rak", "Thr", "Nar", "Vor", "Fir", "Trin", "Drog", "Karn", "Gar", "Ulf", "Hroth", "Ald", "Yng", "Styr", "Eir", "Ein", "Sig", "Ket", "Erl", "Haf", "Bryn", "Nid", "Grim", "Hol", "Fen", "Sigr", "Geir", "Hyr", "Val", "Har", "Kol", "Eyr"};
    private static final String[] SYLLABLE2 = new String[]{"air", "ir", "mi", "sor", "mee", "clo", "red", "cra", "ark", "arc", "miri", "lori", "cres", "mur", "zer", "marac", "zoir", "slamar", "salmar", "urak", "tim", "jor", "vyr", "dor", "thor", "kyl", "lyn", "wyn", "wynn", "lond", "rond", "vond", "dorn", "korn", "morn", "gorn", "thorn", "worn", "norn", "rinn", "dell", "bell", "vell", "fell", "kell", "zell", "nir", "fir", "mir", "tir", "sir", "vir", "zir", "lir", "jyr", "ryl", "rym", "lym", "lyn", "ryn", "myr", "myl", "myn", "ryn"};
    private static final String[] SYLLABLE3 = new String[]{"d", "ed", "ark", "arc", "es", "er", "der", "tron", "med", "ure", "zur", "cred", "mur", "aeus", "th", "vyr", "dor", "morn", "born", "thorn", "fyr", "lyr", "ryth", "ryn", "drin", "dryn", "kyr", "kyn", "lynd", "lind", "lyne", "line", "ryne", "rine", "thyr", "thyre", "vyn", "vin", "vyne", "vine", "rynne", "rinne", "syr", "syrn", "zirn", "zirne", "kyl", "kylle", "dor", "dorne", "lor", "lorne", "morn", "morne", "thorn", "thorne", "vyrn", "vyrne", "wyrm"};
    private static final Random random = new Random();
    private static boolean modNamesInitialized = false;

    public static void initializeModNames() {
        modNamesInitialized = true;
        for (IModInfo info : ModList.get().getMods()) {
            MOD_NAME_TO_ID.put(info.getModId(), info.getDisplayName());
        }
    }

    public static String getModNameForGameObject(@Nonnull Object object) {
        ResourceLocation key;
        if (modNamesInitialized) {
            TextUtil.initializeModNames();
        }
        if (object instanceof Item) {
            key = ForgeRegistries.ITEMS.getKey((Object)((Item)object));
        } else if (object instanceof Block) {
            key = ForgeRegistries.BLOCKS.getKey((Object)((Block)object));
        } else {
            return null;
        }
        String modId = key.m_135827_();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = MOD_NAME_TO_ID.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            MOD_NAME_TO_ID.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static String formatDemonName(String name) {
        return ChatFormatting.GOLD.toString() + ChatFormatting.BOLD + name + ChatFormatting.RESET;
    }

    public static MutableComponent formatDemonName(MutableComponent name) {
        return name.m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
    }

    public static String formatLargeNumber(int number) {
        if ((double)number < Math.pow(10.0, 3.0)) {
            return "" + number;
        }
        if ((double)number < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)number / 1000.0f);
            return rounded + "K";
        }
        if ((double)number < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)number < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return Integer.toString(number);
    }

    public static String generateName() {
        boolean usePossibleSpiritNames;
        List possibleSpiritNames = (List)Occultism.SERVER_CONFIG.rituals.possibleSpiritNames.get();
        boolean bl = usePossibleSpiritNames = random.nextDouble() > (Double)Occultism.SERVER_CONFIG.rituals.usePossibleSpiritNamesChance.get();
        if (!possibleSpiritNames.isEmpty() && usePossibleSpiritNames) {
            return random.nextInt(20) == 0 ? EASTER_EGGS[random.nextInt(EASTER_EGGS.length)] : (String)possibleSpiritNames.get(random.nextInt(possibleSpiritNames.size()));
        }
        return random.nextInt(20) == 0 ? EASTER_EGGS[random.nextInt(EASTER_EGGS.length)] : SYLLABLE1[random.nextInt(SYLLABLE1.length)] + SYLLABLE2[random.nextInt(SYLLABLE2.length)] + SYLLABLE3[random.nextInt(SYLLABLE3.length)];
    }
}

