/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.registry;

import com.github.klikli_dev.occultism.crafting.recipe.CrushingRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.MinerRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OccultismRecipes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"occultism");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"occultism");
    public static final RegistryObject<RecipeType<SpiritTradeRecipe>> SPIRIT_TRADE_TYPE = OccultismRecipes.registerRecipeType("spirit_trade");
    public static final RegistryObject<RecipeType<SpiritFireRecipe>> SPIRIT_FIRE_TYPE = OccultismRecipes.registerRecipeType("spirit_fire");
    public static final RegistryObject<RecipeType<CrushingRecipe>> CRUSHING_TYPE = OccultismRecipes.registerRecipeType("crushing");
    public static final RegistryObject<RecipeType<MinerRecipe>> MINER_TYPE = OccultismRecipes.registerRecipeType("miner");
    public static final RegistryObject<RecipeType<RitualRecipe>> RITUAL_TYPE = OccultismRecipes.registerRecipeType("ritual");
    public static final RegistryObject<RecipeSerializer<SpiritTradeRecipe>> SPIRIT_TRADE = RECIPES.register("spirit_trade", () -> SpiritTradeRecipe.SERIALIZER);
    public static final RegistryObject<RecipeSerializer<SpiritFireRecipe>> SPIRIT_FIRE = RECIPES.register("spirit_fire", () -> SpiritFireRecipe.SERIALIZER);
    public static final RegistryObject<RecipeSerializer<CrushingRecipe>> CRUSHING = RECIPES.register("crushing", () -> CrushingRecipe.SERIALIZER);
    public static final RegistryObject<RecipeSerializer<MinerRecipe>> MINER = RECIPES.register("miner", () -> MinerRecipe.SERIALIZER);
    public static final RegistryObject<RecipeSerializer<RitualRecipe>> RITUAL = RECIPES.register("ritual", () -> RitualRecipe.SERIALIZER);

    static <T extends Recipe<?>> RegistryObject<RecipeType<T>> registerRecipeType(final String id) {
        return RECIPE_TYPES.register(id, () -> new RecipeType<T>(){

            public String toString() {
                return id;
            }
        });
    }
}

