/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageToggleFamiliarSettings
extends MessageBase {
    public Map<EntityType<?>, Boolean> familiarsPressed;

    public MessageToggleFamiliarSettings(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageToggleFamiliarSettings(Map<EntityType<?>, Boolean> familiarsPressed) {
        this.familiarsPressed = familiarsPressed;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        player.getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).ifPresent(cap -> {
            for (Map.Entry<EntityType<?>, Boolean> toggle : this.familiarsPressed.entrySet()) {
                if (!toggle.getValue().booleanValue()) continue;
                cap.setFamiliarEnabled(toggle.getKey(), !cap.isFamiliarEnabled(toggle.getKey()));
                player.m_5661_((Component)Component.m_237115_((String)("message.occultism.familiar." + ForgeRegistries.ENTITY_TYPES.getKey(toggle.getKey()).m_135815_() + (cap.isFamiliarEnabled(toggle.getKey()) ? ".enabled" : ".disabled"))), true);
            }
        });
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            buf.writeBoolean(this.familiarsPressed.get(familiar).booleanValue());
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.familiarsPressed = new HashMap();
        for (EntityType<? extends IFamiliar> familiar : FamiliarSettingsCapability.getFamiliars()) {
            this.familiarsPressed.put(familiar, buf.readBoolean());
        }
    }
}

