/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.datagen;

import com.github.klikli_dev.occultism.common.block.otherworld.IesniumOreNaturalBlock;
import com.github.klikli_dev.occultism.common.block.otherworld.OtherworldLeavesNaturalBlock;
import com.github.klikli_dev.occultism.common.level.multichunk.MultiChunkFeature;
import com.github.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.datagen.CrushingRecipeProvider;
import com.github.klikli_dev.occultism.datagen.ItemModelsGenerator;
import com.github.klikli_dev.occultism.datagen.OccultismAdvancementProvider;
import com.github.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.github.klikli_dev.occultism.datagen.PentacleProvider;
import com.github.klikli_dev.occultism.datagen.StandardBlockStateProvider;
import com.github.klikli_dev.occultism.datagen.StandardLootTableProvider;
import com.github.klikli_dev.occultism.datagen.lang.ENUSProvider;
import com.github.klikli_dev.occultism.datagen.lang.FRFRProvider;
import com.github.klikli_dev.occultism.datagen.lang.PTBRProvider;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismFeatures;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.m_236039_(event.includeServer(), (DataProvider)new StandardLootTableProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new PentacleProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new OccultismAdvancementProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new CrushingRecipeProvider(generator));
        generator.m_236039_(event.includeClient(), (DataProvider)new ItemModelsGenerator(generator, event.getExistingFileHelper()));
        generator.m_236039_(event.includeClient(), (DataProvider)new StandardBlockStateProvider(generator, event.getExistingFileHelper()));
        ENUSProvider enUSProvider = new ENUSProvider(generator);
        generator.m_236039_(event.includeServer(), (DataProvider)new OccultismBookProvider(generator, "occultism", enUSProvider));
        generator.m_236039_(event.includeClient(), (DataProvider)enUSProvider);
        generator.m_236039_(event.includeClient(), (DataProvider)new FRFRProvider(generator));
        generator.m_236039_(event.includeClient(), (DataProvider)new PTBRProvider(generator));
        DataGenerators.registerFeatures(event);
    }

    public static void registerFeatures(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registries);
        ResourceKey silverOreConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "silver_ore"));
        Holder silverOreConfigureHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(silverOreConfiguredKey);
        ResourceKey silverOreDeepslateConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "silver_ore_deepslate"));
        Holder silverOreDeepslateConfiguredHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(silverOreDeepslateConfiguredKey);
        ResourceKey iesniumOreConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "iesnium_ore"));
        Holder iesniumOreConfiguredHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(iesniumOreConfiguredKey);
        ResourceKey undergroundGroveConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "underground_grove"));
        Holder undergroundGroveConfiguredHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(undergroundGroveConfiguredKey);
        ResourceKey otherworldTreeNaturalConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "otherworld_tree_natural"));
        Holder otherworldTreeNaturalConfiguredHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(otherworldTreeNaturalConfiguredKey);
        ResourceKey otherworldTreeConfiguredKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)new ResourceLocation("occultism", "otherworld_tree"));
        Holder otherworldTreeConfiguredHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(otherworldTreeConfiguredKey);
        ResourceKey silverOrePlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "silver_ore"));
        Holder silverOrePlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(silverOrePlacedKey);
        ResourceKey silverOreDeepslatePlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "silver_ore_deepslate"));
        Holder silverOreDeepslatePlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(silverOreDeepslatePlacedKey);
        ResourceKey iesniumOrePlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "iesnium_ore"));
        Holder iesniumOrePlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(iesniumOrePlacedKey);
        ResourceKey undergroundGrovePlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "underground_grove"));
        Holder undergroundGrovePlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(undergroundGrovePlacedKey);
        ResourceKey otherworldTreeNaturalPlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "otherworld_tree_natural"));
        Holder otherworldTreeNaturalPlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(otherworldTreeNaturalPlacedKey);
        ResourceKey otherworldTreePlacedKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)new ResourceLocation("occultism", "otherworld_tree"));
        Holder otherworldTreePlacedHolder = ((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(otherworldTreePlacedKey);
        ConfiguredFeature silverOreConfigured = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144266_), ((Block)OccultismBlocks.SILVER_ORE.get()).m_49966_(), 5));
        ConfiguredFeature silverOreDeepslateConfigured = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_144267_), ((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get()).m_49966_(), 10));
        ConfiguredFeature iesniumOreConfigured = new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BlockTags.f_13062_), ((IesniumOreNaturalBlock)OccultismBlocks.IESNIUM_ORE_NATURAL.get()).m_49966_(), 3));
        ConfiguredFeature otherworldTreeNaturalConfigured = new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)OccultismBlocks.OTHERWORLD_LOG_NATURAL.get()).m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((OtherworldLeavesNaturalBlock)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get()).m_49966_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        ConfiguredFeature otherworldTreeConfigured = new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)OccultismBlocks.OTHERWORLD_LOG.get()).m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((LeavesBlock)OccultismBlocks.OTHERWORLD_LEAVES.get()).m_49966_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68244_().m_68251_());
        PlacedFeature silverOrePlaced = new PlacedFeature(silverOreConfigureHolder, OccultismFeatures.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)50), (VerticalAnchor)VerticalAnchor.m_158922_((int)200))));
        PlacedFeature silverOreDeepslatePlaced = new PlacedFeature(silverOreDeepslateConfiguredHolder, OccultismFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))));
        PlacedFeature iesniumOrePlaced = new PlacedFeature(iesniumOreConfiguredHolder, OccultismFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)50))));
        PlacedFeature otherworldTreeNaturalPlaced = new PlacedFeature(otherworldTreeNaturalConfiguredHolder, List.of(PlacementUtils.m_206493_((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()))));
        PlacedFeature otherworldTreePlaced = new PlacedFeature(otherworldTreeConfiguredHolder, List.of(PlacementUtils.m_206493_((Block)((Block)OccultismBlocks.OTHERWORLD_SAPLING.get()))));
        ConfiguredFeature undergroundGroveConfigured = new ConfiguredFeature((Feature)((MultiChunkFeature)((Object)OccultismFeatures.UNDERGROUND_GROVE_FEATURE.get())), (FeatureConfiguration)new MultiChunkFeatureConfig(7, 400, 25, 60, 14653667, 0.6f, 0.1f, 0.3f, 0.1f, (Holder<PlacedFeature>)otherworldTreeNaturalPlacedHolder));
        PlacedFeature undergroundGrovePlaced = new PlacedFeature(undergroundGroveConfiguredHolder, List.of());
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addSilverOre = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{silverOrePlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addDeepslateSilverOre = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{silverOreDeepslatePlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addIesniumOre = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_207612_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{iesniumOrePlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addUndergroundGrove = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{undergroundGrovePlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addOtherworldTreeNatural = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{otherworldTreeNaturalPlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addOtherworldTree = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{otherworldTreePlacedHolder}), GenerationStep.Decoration.UNDERGROUND_ORES);
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)event.getExistingFileHelper(), (String)"occultism", (RegistryOps)ops, (ResourceKey)Registry.f_122881_, Map.of(silverOreConfiguredKey.m_135782_(), silverOreConfigured, silverOreDeepslateConfiguredKey.m_135782_(), silverOreDeepslateConfigured, iesniumOreConfiguredKey.m_135782_(), iesniumOreConfigured, undergroundGroveConfiguredKey.m_135782_(), undergroundGroveConfigured, otherworldTreeNaturalConfiguredKey.m_135782_(), otherworldTreeNaturalConfigured, otherworldTreeConfiguredKey.m_135782_(), otherworldTreeConfigured)));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)event.getExistingFileHelper(), (String)"occultism", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, Map.of(silverOrePlacedKey.m_135782_(), silverOrePlaced, silverOreDeepslatePlacedKey.m_135782_(), silverOreDeepslatePlaced, iesniumOrePlacedKey.m_135782_(), iesniumOrePlaced, otherworldTreeNaturalPlacedKey.m_135782_(), otherworldTreeNaturalPlaced, otherworldTreePlacedKey.m_135782_(), otherworldTreePlaced, undergroundGrovePlacedKey.m_135782_(), undergroundGrovePlaced)));
        generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)event.getExistingFileHelper(), (String)"occultism", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, Map.of(new ResourceLocation("occultism", "add_silver_ore"), addSilverOre, new ResourceLocation("occultism", "add_deepslate_silver_ore"), addDeepslateSilverOre, new ResourceLocation("occultism", "add_iesnium_ore"), addIesniumOre, new ResourceLocation("occultism", "add_underground_grove"), addUndergroundGrove, new ResourceLocation("occultism", "add_otherworld_tree_natural"), addOtherworldTreeNatural, new ResourceLocation("occultism", "add_otherworld_tree"), addOtherworldTree)));
    }
}

