/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.crafting.recipe;

import com.github.klikli_dev.occultism.common.misc.OutputIngredient;
import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventoryRecipe;
import com.github.klikli_dev.occultism.crafting.recipe.TieredItemStackFakeInventory;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrushingRecipe
extends ItemStackFakeInventoryRecipe {
    public static Serializer SERIALIZER = new Serializer();
    public static int DEFAULT_CRUSHING_TIME = 200;
    protected final int crushingTime;
    protected final int minTier;
    protected final boolean ignoreCrushingMultiplier;
    protected OutputIngredient output;

    public CrushingRecipe(ResourceLocation id, Ingredient input, OutputIngredient output, int minTier, int crushingTime, boolean ignoreCrushingMultiplier) {
        super(id, input, output.getStack());
        this.output = output;
        this.crushingTime = crushingTime;
        this.minTier = minTier;
        this.ignoreCrushingMultiplier = ignoreCrushingMultiplier;
    }

    public int getCrushingTime() {
        return this.crushingTime;
    }

    public boolean getIgnoreCrushingMultiplier() {
        return this.ignoreCrushingMultiplier;
    }

    public int getMinTier() {
        return this.minTier;
    }

    @Override
    public boolean matches(ItemStackFakeInventory inv, Level level) {
        if (inv instanceof TieredItemStackFakeInventory) {
            TieredItemStackFakeInventory tieredInv = (TieredItemStackFakeInventory)inv;
            return tieredInv.getTier() >= this.minTier && this.input.test(inv.m_8020_(0));
        }
        return this.input.test(inv.m_8020_(0));
    }

    @Override
    public ItemStack m_8043_() {
        return this.output.getStack();
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)OccultismRecipes.CRUSHING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrushingRecipe> {
        public CrushingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int crushingTime = GsonHelper.m_13824_((JsonObject)json, (String)"crushing_time", (int)DEFAULT_CRUSHING_TIME);
            boolean ignoreCrushingMultiplier = GsonHelper.m_13855_((JsonObject)json, (String)"ignore_crushing_multiplier", (boolean)false);
            int minTier = GsonHelper.m_13824_((JsonObject)json, (String)"min_tier", (int)-1);
            JsonObject resultElement = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            Ingredient outputIngredient = Ingredient.m_43917_((JsonElement)resultElement);
            if (!resultElement.has("item")) {
                resultElement.addProperty("item", "minecraft:dirt");
            }
            return ItemStackFakeInventoryRecipe.SERIALIZER.read((id, input, output) -> new CrushingRecipe(id, input, new OutputIngredient(outputIngredient, output), minTier, crushingTime, ignoreCrushingMultiplier), recipeId, json);
        }

        public CrushingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int crushingTime = buffer.readInt();
            boolean ignoreCrushingMultiplier = buffer.readBoolean();
            int minTier = buffer.readInt();
            Ingredient outputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return ItemStackFakeInventoryRecipe.SERIALIZER.read((id, input, output) -> new CrushingRecipe(id, input, new OutputIngredient(outputIngredient, output), minTier, crushingTime, ignoreCrushingMultiplier), recipeId, buffer);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrushingRecipe recipe) {
            buffer.writeInt(recipe.crushingTime);
            buffer.writeBoolean(recipe.ignoreCrushingMultiplier);
            buffer.writeInt(recipe.minTier);
            recipe.output.getIngredient().m_43923_(buffer);
            ItemStackFakeInventoryRecipe.SERIALIZER.write(buffer, recipe);
        }
    }
}

