/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.ritual;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.github.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public abstract class Ritual {
    public static final int SACRIFICIAL_BOWL_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE = 8;
    public static final int SACRIFICE_DETECTION_RANGE_SQUARE = 64;
    public static final int ITEM_USE_DETECTION_RANGE = 16;
    public static final int ITEM_USE_DETECTION_RANGE_SQUARE = 256;
    public RitualRecipe recipe;
    public ResourceLocation factoryId;

    public Ritual(RitualRecipe recipe) {
        this.recipe = recipe;
    }

    public static List<Ingredient> getRemainingAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> consumedIngredients) {
        ArrayList<ItemStack> consumedIngredientsCopy = new ArrayList<ItemStack>(consumedIngredients);
        ArrayList<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
        for (Ingredient ingredient : additionalIngredients) {
            Optional<ItemStack> matchedStack = consumedIngredientsCopy.stream().filter(arg_0 -> ((Ingredient)ingredient).test(arg_0)).findFirst();
            if (matchedStack.isPresent()) {
                consumedIngredientsCopy.remove(matchedStack.get());
                continue;
            }
            remainingAdditionalIngredients.add(ingredient);
        }
        return remainingAdditionalIngredients;
    }

    public ResourceLocation getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryId(ResourceLocation factoryId) {
        this.factoryId = factoryId;
    }

    public RitualRecipe getRecipe() {
        return this.recipe;
    }

    public String getRitualID() {
        ResourceLocation recipeId = this.getRecipe().m_6423_();
        String path = recipeId.m_135815_();
        if (path.contains("/")) {
            path = path.substring(path.indexOf("/") + 1);
        }
        return recipeId.m_135827_() + "." + path;
    }

    public String getConditionsMessage() {
        return String.format("ritual.%s.conditions", this.getRitualID());
    }

    public String getStartedMessage() {
        return String.format("ritual.%s.started", this.getRitualID());
    }

    public String getInterruptedMessage() {
        return String.format("ritual.%s.interrupted", this.getRitualID());
    }

    public String getFinishedMessage() {
        return String.format("ritual.%s.finished", this.getRitualID());
    }

    public boolean isValid(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(level, goldenBowlPosition, remainingAdditionalIngredients) && this.recipe.getPentacle().validate(level, goldenBowlPosition) != null;
    }

    public void start(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem) {
        level.m_5594_(null, goldenBowlPosition, (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        castingPlayer.m_5661_((Component)Component.m_237115_((String)this.getStartedMessage()), true);
    }

    public void finish(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem) {
        level.m_5594_(null, goldenBowlPosition, (SoundEvent)OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
        castingPlayer.m_5661_((Component)Component.m_237115_((String)this.getFinishedMessage()), true);
        OccultismAdvancements.RITUAL.trigger((ServerPlayer)castingPlayer, this);
    }

    public void interrupt(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem) {
        level.m_5594_(null, goldenBowlPosition, SoundEvents.f_11752_, SoundSource.BLOCKS, 0.7f, 0.7f);
        castingPlayer.m_5661_((Component)Component.m_237115_((String)this.getInterruptedMessage()), true);
    }

    public void update(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem, List<Ingredient> remainingAdditionalIngredients, int time) {
    }

    public void update(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack activationItem, int time) {
        this.update(level, goldenBowlPosition, blockEntity, castingPlayer, activationItem, new ArrayList<Ingredient>(), time);
    }

    public boolean identify(Level level, BlockPos goldenBowlPosition, ItemStack activationItem) {
        return this.recipe.getPentacle() != null && this.recipe.getActivationItem().test(activationItem) && this.areAdditionalIngredientsFulfilled(level, goldenBowlPosition, (List<Ingredient>)this.recipe.m_7527_()) && this.recipe.getPentacle().validate(level, goldenBowlPosition) != null;
    }

    public boolean consumeAdditionalIngredients(Level level, BlockPos goldenBowlPosition, List<Ingredient> remainingAdditionalIngredients, int time, List<ItemStack> consumedIngredients) {
        int ingredientsConsumed;
        if (remainingAdditionalIngredients.isEmpty()) {
            return true;
        }
        int totalIngredientsToConsume = (int)Math.floor((float)time / this.recipe.getDurationPerIngredient());
        int ingredientsToConsume = totalIngredientsToConsume - (ingredientsConsumed = consumedIngredients.size());
        if (ingredientsToConsume == 0) {
            return true;
        }
        List<SacrificialBowlBlockEntity> sacrificialBowls = this.getSacrificialBowls(level, goldenBowlPosition);
        Iterator<Ingredient> it = remainingAdditionalIngredients.iterator();
        for (int consumed = 0; it.hasNext() && consumed < ingredientsToConsume; ++consumed) {
            Ingredient ingredient = it.next();
            if (!this.consumeAdditionalIngredient(level, goldenBowlPosition, sacrificialBowls, ingredient, consumedIngredients)) {
                return false;
            }
            it.remove();
        }
        return true;
    }

    public boolean consumeAdditionalIngredient(Level level, BlockPos goldenBowlPosition, List<SacrificialBowlBlockEntity> sacrificialBowls, Ingredient ingredient, List<ItemStack> consumedIngredients) {
        for (SacrificialBowlBlockEntity sacrificialBowl : sacrificialBowls) {
            if (!sacrificialBowl.itemStackHandler.map(handler -> {
                ItemStack stack = handler.extractItem(0, 1, true);
                if (ingredient.test(stack)) {
                    ItemStack extracted = handler.extractItem(0, 1, false);
                    consumedIngredients.add(extracted);
                    ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)sacrificialBowl.m_58899_().m_123341_() + 0.5, (double)sacrificialBowl.m_58899_().m_123342_() + 1.5, (double)sacrificialBowl.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    level.m_5594_(null, sacrificialBowl.m_58899_(), (SoundEvent)OccultismSounds.POOF.get(), SoundSource.BLOCKS, 0.7f, 0.7f);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean areAdditionalIngredientsFulfilled(Level level, BlockPos goldenBowlPosition, List<Ingredient> additionalIngredients) {
        return this.matchesAdditionalIngredients(additionalIngredients, this.getItemsOnSacrificialBowls(level, goldenBowlPosition));
    }

    public boolean matchesAdditionalIngredients(List<Ingredient> additionalIngredients, List<ItemStack> items) {
        if (((Boolean)Occultism.SERVER_CONFIG.rituals.enableRemainingIngredientCountMatching.get()).booleanValue() && additionalIngredients.size() != items.size()) {
            return false;
        }
        if (additionalIngredients.isEmpty()) {
            return true;
        }
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>(items);
        for (Ingredient ingredient : additionalIngredients) {
            boolean isMatched = false;
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack stack = (ItemStack)remainingItems.get(i);
                if (!ingredient.test(stack)) continue;
                isMatched = true;
                remainingItems.remove(i);
                break;
            }
            if (isMatched) continue;
            return false;
        }
        return true;
    }

    public List<ItemStack> getItemsOnSacrificialBowls(Level level, BlockPos goldenBowlPosition) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<SacrificialBowlBlockEntity> sacrificialBowls = this.getSacrificialBowls(level, goldenBowlPosition);
        for (SacrificialBowlBlockEntity sacrificialBowl : sacrificialBowls) {
            sacrificialBowl.itemStackHandler.ifPresent(handler -> {
                ItemStack stack = handler.getStackInSlot(0);
                if (!stack.m_41619_()) {
                    result.add(stack);
                }
            });
        }
        return result;
    }

    public List<SacrificialBowlBlockEntity> getSacrificialBowls(Level level, BlockPos goldenBowlPosition) {
        Multiblock pentacle = this.recipe.getPentacle();
        Vec3i offset = pentacle.getOffset();
        Vec3i size = pentacle.getSize();
        int yBowlRangeTop = size.m_123342_() - offset.m_123342_() - 1;
        int yBowlRangeBottom = offset.m_123342_();
        ArrayList<SacrificialBowlBlockEntity> result = new ArrayList<SacrificialBowlBlockEntity>();
        Iterable blocksToCheck = BlockPos.m_121940_((BlockPos)goldenBowlPosition.m_7918_(-8, -(++yBowlRangeBottom), -8), (BlockPos)goldenBowlPosition.m_7918_(8, ++yBowlRangeTop, 8));
        for (BlockPos blockToCheck : blocksToCheck) {
            BlockEntity blockEntity = level.m_7702_(blockToCheck);
            if (!(blockEntity instanceof SacrificialBowlBlockEntity) || blockEntity instanceof GoldenSacrificialBowlBlockEntity) continue;
            result.add((SacrificialBowlBlockEntity)blockEntity);
        }
        return result;
    }

    public boolean isValidSacrifice(LivingEntity entity) {
        return entity != null && this.recipe.requiresSacrifice() && entity.m_6095_().m_204039_(this.recipe.getEntityToSacrifice());
    }

    public boolean isValidItemUse(PlayerInteractEvent.RightClickItem event) {
        return this.recipe.requiresItemUse() && this.recipe.getItemToUse().test(event.getItemStack());
    }

    public boolean requiresSacrifice() {
        return this.recipe.requiresSacrifice();
    }

    public boolean require() {
        return this.recipe.requiresItemUse();
    }

    public void dropResult(Level level, BlockPos goldenBowlPosition, GoldenSacrificialBowlBlockEntity blockEntity, Player castingPlayer, ItemStack stack) {
        double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
        ItemEntity entity = new ItemEntity(level, (double)goldenBowlPosition.m_123341_() + 0.5, (double)goldenBowlPosition.m_123342_() + 0.75, (double)goldenBowlPosition.m_123343_() + 0.5, stack);
        entity.m_20334_(Math.sin(angle) * 0.125, 0.25, Math.cos(angle) * 0.125);
        entity.m_32010_(10);
        level.m_7967_((Entity)entity);
    }
}

