/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.common.blockentity.DimensionalMineshaftBlockEntity;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class MinerSpiritItem
extends Item {
    private final Supplier<Integer> maxMiningTime;
    private final Supplier<Integer> rollsPerOperation;
    private final Supplier<Integer> maxDamage;

    public MinerSpiritItem(Item.Properties properties, Supplier<Integer> maxMiningTime, Supplier<Integer> rollsPerOperation, Supplier<Integer> maxDamage) {
        super(properties);
        this.maxMiningTime = maxMiningTime;
        this.rollsPerOperation = rollsPerOperation;
        this.maxDamage = maxDamage;
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        super.m_7836_(stack, worldIn, playerIn);
        stack.m_41784_().m_128405_("maxMiningTime", this.maxMiningTime.get().intValue());
        stack.m_41784_().m_128405_(DimensionalMineshaftBlockEntity.ROLLS_PER_OPERATION_TAG, this.rollsPerOperation.get().intValue());
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDamage.get();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128405_("maxMiningTime", this.maxMiningTime.get().intValue());
        stack.m_41784_().m_128405_(DimensionalMineshaftBlockEntity.ROLLS_PER_OPERATION_TAG, this.rollsPerOperation.get().intValue());
        return super.initCapabilities(stack, nbt);
    }
}

