/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.item.spirit;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.MachineReference;
import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.api.common.item.IHandleItemMode;
import com.github.klikli_dev.occultism.api.common.item.IIngredientCopyNBT;
import com.github.klikli_dev.occultism.client.gui.GuiHelper;
import com.github.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.github.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfBindingBoundItem;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingManageMachineItem;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import com.github.klikli_dev.occultism.util.EntityUtil;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class BookOfCallingItem
extends Item
implements IIngredientCopyNBT,
IHandleItemMode {
    public static Map<UUID, Long> spiritDeathRegister = new HashMap<UUID, Long>();
    public String translationKeyBase;
    public Predicate<SpiritEntity> targetSpirit;

    public BookOfCallingItem(Item.Properties properties, String translationKeyBase, Predicate<SpiritEntity> targetSpirit) {
        super(properties);
        this.translationKeyBase = translationKeyBase;
        this.targetSpirit = targetSpirit;
    }

    public String getTranslationKeyBase() {
        return this.translationKeyBase;
    }

    @Override
    public boolean shouldCopyNBT(ItemStack itemStack, Recipe recipe, CraftingContainer inventory) {
        return recipe.m_8043_().m_41720_() instanceof BookOfBindingBoundItem;
    }

    @Override
    public CompoundTag overrideNBT(ItemStack itemStack, CompoundTag nbt, Recipe recipe, CraftingContainer inventory) {
        CompoundTag result = new CompoundTag();
        if (nbt.m_128441_("spiritName")) {
            result.m_128359_("spiritName", nbt.m_128461_("spiritName"));
        }
        return result;
    }

    @Override
    public int getItemMode(ItemStack stack) {
        return ItemNBTUtil.getItemMode(stack);
    }

    @Override
    public void setItemMode(ItemStack stack, int mode) {
        ItemNBTUtil.setItemMode(stack, mode);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        Level world = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        CompoundTag entityData = ItemNBTUtil.getSpiritEntityData(itemStack);
        if (entityData != null) {
            if (!world.f_46443_) {
                EntityType<?> type = EntityUtil.entityTypeFromNbt(entityData);
                facing = facing == null ? Direction.UP : facing;
                BlockPos spawnPos = pos.m_7949_();
                if (!world.m_8055_(spawnPos).m_60812_((BlockGetter)world, spawnPos).m_83281_()) {
                    spawnPos = spawnPos.m_121945_(facing);
                }
                MutableComponent customName = null;
                if (entityData.m_128441_("CustomName")) {
                    customName = Component.Serializer.m_130701_((String)entityData.m_128461_("CustomName"));
                }
                entityData.m_128473_("Pos");
                CompoundTag wrapper = new CompoundTag();
                wrapper.m_128365_("EntityTag", (Tag)entityData);
                SpiritEntity entity = (SpiritEntity)type.m_20615_(world);
                entity.m_20258_(entityData);
                entity.m_19890_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)entity);
                ItemNBTUtil.updateItemNBTFromEntity(itemStack, entity);
                world.m_7967_((Entity)entity);
                itemStack.m_41783_().m_128473_("spiritData");
                player.f_36095_.m_38946_();
            }
        } else {
            if (player.m_6144_()) {
                return this.handleItemMode(player, world, pos, itemStack, facing);
            }
            if (world.f_46443_) {
                IItemModeSubset<?> subset = this.getItemModeSubset(itemStack);
                WorkAreaSize workAreaSize = ItemNBTUtil.getWorkAreaSize(itemStack);
                GuiHelper.openBookOfCallingGui(subset, workAreaSize);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        if (!(target instanceof SpiritEntity)) {
            return InteractionResult.PASS;
        }
        SpiritEntity targetSpirit = (SpiritEntity)target;
        if (!targetSpirit.m_20148_().equals(ItemNBTUtil.getSpiritEntityUUID(stack))) {
            if (player.m_6144_()) {
                if (this.targetSpirit.test(targetSpirit)) {
                    ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.m_20148_());
                    ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.m_7755_().getString());
                    player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_linked"), true);
                    player.m_6674_(hand);
                    player.m_21008_(hand, stack);
                    player.f_36095_.m_38946_();
                    return InteractionResult.SUCCESS;
                }
                if (ItemMode.get(this.getItemMode(stack)) == ItemMode.SET_DEPOSIT) {
                    if (targetSpirit.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
                        if (boundSpiritId != null) {
                            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(target.f_19853_.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
                            if (boundSpirit.isPresent()) {
                                boundSpirit.get().setDepositEntityUUID(targetSpirit.m_20148_());
                                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                                ItemNBTUtil.setDepositEntityName(stack, target.m_7755_().getString());
                                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_deposit_entity", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), TextUtil.formatDemonName(targetSpirit.m_7755_().getString())}), true);
                                player.m_6674_(hand);
                                player.m_21008_(hand, stack);
                                player.f_36095_.m_38946_();
                                return InteractionResult.SUCCESS;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
                            return InteractionResult.FAIL;
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                        return InteractionResult.FAIL;
                    }
                    player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_entity_no_inventory"), true);
                    return InteractionResult.FAIL;
                }
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_cannot_link"), true);
                return InteractionResult.FAIL;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_target_uuid_no_match"), true);
            return InteractionResult.FAIL;
        }
        ItemNBTUtil.setSpiritEntityData(stack, targetSpirit.serializeNBT());
        ItemNBTUtil.setSpiritEntityUUID(stack, targetSpirit.m_20148_());
        ItemNBTUtil.setBoundSpiritName(stack, targetSpirit.m_7755_().getString());
        player.m_6674_(hand);
        player.m_21008_(hand, stack);
        targetSpirit.m_142687_(Entity.RemovalReason.DISCARDED);
        player.f_36095_.m_38946_();
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Long deathTime;
        UUID spiritID;
        if (worldIn.m_46467_() % 1200L == 0L && (spiritID = ItemNBTUtil.getSpiritEntityUUID(stack)) != null && (deathTime = spiritDeathRegister.get(spiritID)) != null && deathTime < worldIn.m_46467_()) {
            spiritDeathRegister.remove(spiritID);
            stack.m_41783_().m_128379_("spiritDead", true);
            stack.m_41783_().m_128473_("spiritUUID");
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237110_((String)(this.getTranslationKeyBase() + (ItemNBTUtil.getSpiritDead(stack) ? ".tooltip_dead" : ".tooltip")), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(stack))}));
    }

    public boolean m_5812_(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityData(stack) != null;
    }

    public Rarity m_41460_(ItemStack stack) {
        return ItemNBTUtil.getSpiritEntityUUID(stack) != null ? Rarity.RARE : Rarity.COMMON;
    }

    public IItemModeSubset<?> getItemModeSubset(ItemStack stack) {
        return ItemMode.get(this.getItemMode(stack));
    }

    public boolean useWorkAreaSize() {
        return true;
    }

    public boolean setSpiritManagedMachineExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            BlockEntity extractBlockEntity = world.m_7702_(pos);
            if (boundSpirit.isPresent() && extractBlockEntity != null) {
                SpiritJob spiritJob;
                if (boundSpirit.get().getJob().isPresent() && (spiritJob = boundSpirit.get().getJob().get()) instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)spiritJob;
                    if (manageMachine.getManagedMachine() == null) {
                        player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString())}), true);
                        return true;
                    }
                    BlockEntity oldManagedMachineBlockEntity = manageMachine.getManagedMachineBlockEntity();
                    MachineReference newReference = MachineReference.from(extractBlockEntity, oldManagedMachineBlockEntity != null ? oldManagedMachineBlockEntity : extractBlockEntity);
                    newReference.extractFacing = face;
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().extractGlobalPos.equals(newReference.extractGlobalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().extractRegistryName = newReference.extractRegistryName;
                        manageMachine.getManagedMachine().extractFacing = newReference.extractFacing;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                    player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_managed_machine_extract_location", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName), face.m_7912_()}), true);
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    public boolean setSpiritManagedMachine(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            BlockEntity managedMachineBlockEntity = world.m_7702_(pos);
            if (boundSpirit.isPresent() && managedMachineBlockEntity != null) {
                SpiritJob spiritJob;
                if (boundSpirit.get().getJob().isPresent() && (spiritJob = boundSpirit.get().getJob().get()) instanceof ManageMachineJob) {
                    ManageMachineJob manageMachine = (ManageMachineJob)spiritJob;
                    MachineReference newReference = MachineReference.from(managedMachineBlockEntity, managedMachineBlockEntity);
                    if (manageMachine.getManagedMachine() == null || !manageMachine.getManagedMachine().insertGlobalPos.equals(newReference.insertGlobalPos)) {
                        manageMachine.setManagedMachine(newReference);
                    } else {
                        manageMachine.getManagedMachine().insertRegistryName = newReference.insertRegistryName;
                    }
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_managed_machine", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString())}), true);
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    public boolean setSpiritStorageController(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent() && boundSpirit.get().getJob().isPresent()) {
                if (boundSpirit.get().getJob().get() instanceof ManageMachineJob) {
                    ManageMachineJob job = (ManageMachineJob)boundSpirit.get().getJob().get();
                    job.setStorageControllerPosition(new GlobalBlockPos(pos, world));
                    ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                    String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                    player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_storage_controller", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName)}), true);
                    return true;
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
            }
        }
        return false;
    }

    public boolean setSpiritDepositLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setDepositPosition(pos);
                boundSpirit.get().setDepositFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_deposit", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName), face.m_7912_()}), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    public boolean setSpiritExtractLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setExtractPosition(pos);
                boundSpirit.get().setExtractFacing(face);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_extract", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName), face.m_7912_()}), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    public boolean setSpiritBaseLocation(Player player, Level world, BlockPos pos, ItemStack stack, Direction face) {
        UUID boundSpiritId = ItemNBTUtil.getSpiritEntityUUID(stack);
        if (boundSpiritId != null) {
            Optional<SpiritEntity> boundSpirit = EntityUtil.getEntityByUuiDGlobal(world.m_7654_(), boundSpiritId).map(e -> (SpiritEntity)e);
            if (boundSpirit.isPresent()) {
                boundSpirit.get().setWorkAreaPosition(pos);
                ItemNBTUtil.updateItemNBTFromEntity(stack, boundSpirit.get());
                String blockName = world.m_8055_(pos).m_60734_().m_7705_();
                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_base", (Object[])new Object[]{TextUtil.formatDemonName(boundSpirit.get().m_7755_().getString()), Component.m_237115_((String)blockName)}), true);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"item.occultism.book_of_calling.message_spirit_not_found"), true);
        }
        return false;
    }

    public InteractionResult handleItemMode(Player player, Level world, BlockPos pos, ItemStack stack, Direction facing) {
        ItemMode itemMode = ItemMode.get(this.getItemMode(stack));
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!world.f_46443_) {
            switch (itemMode) {
                case SET_DEPOSIT: {
                    if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) break;
                    return this.setSpiritDepositLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                case SET_EXTRACT: {
                    if (this instanceof BookOfCallingManageMachineItem) {
                        if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) break;
                        return this.setSpiritManagedMachineExtractLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                    }
                    if (blockEntity == null || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, facing).isPresent()) break;
                    return this.setSpiritExtractLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                case SET_BASE: {
                    return this.setSpiritBaseLocation(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                case SET_STORAGE_CONTROLLER: {
                    if (!(blockEntity instanceof IStorageController)) break;
                    return this.setSpiritStorageController(player, world, pos, stack, facing) ? InteractionResult.SUCCESS : InteractionResult.PASS;
                }
                case SET_MANAGED_MACHINE: {
                    if (blockEntity == null || !BlockEntityUtil.hasCapabilityOnAnySide(blockEntity, ForgeCapabilities.ITEM_HANDLER)) break;
                    this.setSpiritManagedMachine(player, world, pos, stack, facing);
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            switch (itemMode) {
                case SET_MANAGED_MACHINE: {
                    MachineReference machine;
                    if (blockEntity == null || !BlockEntityUtil.hasCapabilityOnAnySide(blockEntity, ForgeCapabilities.ITEM_HANDLER) || (machine = ItemNBTUtil.getManagedMachine(stack)) == null) break;
                    GuiHelper.openBookOfCallingManagedMachineGui(machine.insertFacing, machine.extractFacing, machine.customName);
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static interface IItemModeSubset<T extends IItemModeSubset<T>> {
        public ItemMode getItemMode();

        public T next();
    }

    public static enum ItemMode implements IItemModeSubset<ItemMode>
    {
        SET_DEPOSIT(0, "set_deposit"),
        SET_EXTRACT(1, "set_extract"),
        SET_BASE(2, "set_base"),
        SET_STORAGE_CONTROLLER(3, "set_storage_controller"),
        SET_MANAGED_MACHINE(4, "set_managed_machine");

        private static final Map<Integer, ItemMode> lookup;
        private static final String TRANSLATION_KEY_BASE = "enum.occultism.book_of_calling.item_mode";
        private final int value;
        private final String translationKey;

        private ItemMode(int value, String translationKey) {
            this.value = value;
            this.translationKey = "enum.occultism.book_of_calling.item_mode." + translationKey;
        }

        public static ItemMode get(int value) {
            return lookup.get(value);
        }

        public int getValue() {
            return this.value;
        }

        public String getDescriptionId() {
            return this.translationKey;
        }

        @Override
        public ItemMode getItemMode() {
            return this;
        }

        @Override
        public ItemMode next() {
            return ItemMode.values()[(this.ordinal() + 1) % ItemMode.values().length];
        }

        public boolean equals(int value) {
            return this.value == value;
        }

        static {
            lookup = new HashMap<Integer, ItemMode>();
            for (ItemMode itemMode : ItemMode.values()) {
                lookup.put(itemMode.getValue(), itemMode);
            }
        }
    }
}

