/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.familiar.GuardianFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GuardianFamiliarModel
extends EntityModel<GuardianFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart bodyLower;
    public ModelPart head;
    public ModelPart leftArm1;
    public ModelPart rightArm1;
    public ModelPart leftLeg1;
    public ModelPart rightLeg1;
    public ModelPart leftLeg2;
    public ModelPart rightLeg2;
    public ModelPart crystal1;
    public ModelPart crystal2;
    public ModelPart crystal3;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart tree1;
    public ModelPart tree2;
    public ModelPart leftArm2;
    public ModelPart birdBody;
    public ModelPart leftArm3;
    public ModelPart birdLeftLeg;
    public ModelPart birdRightLeg;
    public ModelPart birdHead;
    public ModelPart birdLeftWing;
    public ModelPart birdRightWing;
    public ModelPart birdNose;
    public ModelPart rightArm2;
    public ModelPart rightArm3;

    public GuardianFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.bodyLower = this.body.m_171324_("bodyLower");
        this.head = this.body.m_171324_("head");
        this.leftArm1 = this.body.m_171324_("leftArm1");
        this.rightArm1 = this.body.m_171324_("rightArm1");
        this.leftLeg1 = this.bodyLower.m_171324_("leftLeg1");
        this.rightLeg1 = this.bodyLower.m_171324_("rightLeg1");
        this.leftLeg2 = this.leftLeg1.m_171324_("leftLeg2");
        this.rightLeg2 = this.rightLeg1.m_171324_("rightLeg2");
        this.crystal1 = this.head.m_171324_("crystal1");
        this.crystal2 = this.head.m_171324_("crystal2");
        this.crystal3 = this.head.m_171324_("crystal3");
        this.leftEye = this.head.m_171324_("leftEye");
        this.rightEye = this.head.m_171324_("rightEye");
        this.tree1 = this.head.m_171324_("tree1");
        this.tree2 = this.head.m_171324_("tree2");
        this.leftArm2 = this.leftArm1.m_171324_("leftArm2");
        this.birdBody = this.leftArm1.m_171324_("birdBody");
        this.leftArm3 = this.leftArm2.m_171324_("leftArm3");
        this.birdLeftLeg = this.birdBody.m_171324_("birdLeftLeg");
        this.birdRightLeg = this.birdBody.m_171324_("birdRightLeg");
        this.birdHead = this.birdBody.m_171324_("birdHead");
        this.birdLeftWing = this.birdBody.m_171324_("birdLeftWing");
        this.birdRightWing = this.birdBody.m_171324_("birdRightWing");
        this.birdNose = this.birdHead.m_171324_("birdNose");
        this.rightArm2 = this.rightArm1.m_171324_("rightArm2");
        this.rightArm3 = this.rightArm2.m_171324_("rightArm3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-3.5f, -3.0f, -3.0f, 7.0f, 6.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)9.1f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodyLower = body.m_171599_("bodyLower", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171506_(-2.5f, -2.0f, -2.5f, 5.0f, 4.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(22, 9).m_171506_(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm1 = body.m_171599_("leftArm1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171506_(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, false), PartPose.m_171423_((float)5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.19547687f));
        PartDefinition rightArm1 = body.m_171599_("rightArm1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171506_(-2.0f, -2.0f, -2.0f, 4.0f, 6.0f, 4.0f, true), PartPose.m_171423_((float)-5.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.19198622f));
        PartDefinition leftLeg1 = bodyLower.m_171599_("leftLeg1", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171506_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, false), PartPose.m_171423_((float)2.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1563815f));
        PartDefinition rightLeg1 = bodyLower.m_171599_("rightLeg1", CubeListBuilder.m_171558_().m_171514_(46, 0).m_171506_(-1.5f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, true), PartPose.m_171423_((float)-2.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1563815f));
        PartDefinition leftLeg2 = leftLeg1.m_171599_("leftLeg2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.11728612f));
        PartDefinition rightLeg2 = rightLeg1.m_171599_("rightLeg2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.11728612f));
        PartDefinition crystal1 = head.m_171599_("crystal1", CubeListBuilder.m_171558_().m_171514_(8, 28).m_171506_(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)0.9f, (float)-1.0f, (float)0.0f, (float)-0.07819075f, (float)-0.35185838f, (float)0.43004912f));
        PartDefinition crystal2 = head.m_171599_("crystal2", CubeListBuilder.m_171558_().m_171514_(4, 28).m_171506_(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-1.0f, (float)-1.0f, (float)-1.0f, (float)0.1563815f, (float)0.23457225f, (float)0.19547687f));
        PartDefinition crystal3 = head.m_171599_("crystal3", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171506_(-1.0f, -4.0f, 0.0f, 2.0f, 4.0f, 0.0f, false), PartPose.m_171423_((float)-1.1f, (float)-1.0f, (float)1.0f, (float)-0.11728612f, (float)0.8210029f, (float)-0.23457225f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171506_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, false), PartPose.m_171423_((float)1.2f, (float)-0.5f, (float)-2.4f, (float)0.0f, (float)-0.12217305f, (float)0.12217305f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171506_(-1.0f, -1.5f, 0.0f, 2.0f, 3.0f, 0.0f, true), PartPose.m_171423_((float)-1.2f, (float)-0.5f, (float)-2.4f, (float)0.0f, (float)0.12217305f, (float)-0.12217305f));
        PartDefinition tree1 = head.m_171599_("tree1", CubeListBuilder.m_171558_().m_171514_(12, 22).m_171506_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition tree2 = head.m_171599_("tree2", CubeListBuilder.m_171558_().m_171514_(12, 22).m_171506_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition leftArm2 = leftArm1.m_171599_("leftArm2", CubeListBuilder.m_171558_().m_171514_(35, 16).m_171506_(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.07819075f));
        PartDefinition birdBody = leftArm1.m_171599_("birdBody", CubeListBuilder.m_171558_().m_171514_(56, 28).m_171506_(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 2.0f, false), PartPose.m_171423_((float)0.3f, (float)-2.9f, (float)0.0f, (float)-0.54733527f, (float)0.17453292f, (float)0.0f));
        PartDefinition leftArm3 = leftArm2.m_171599_("leftArm3", CubeListBuilder.m_171558_().m_171514_(52, 13).m_171506_(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.039095376f));
        PartDefinition birdLeftLeg = birdBody.m_171599_("birdLeftLeg", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.5f, (float)-0.31f, (float)0.0f, (float)0.74281216f, (float)-0.51173055f, (float)-0.43004912f));
        PartDefinition birdRightLeg = birdBody.m_171599_("birdRightLeg", CubeListBuilder.m_171558_().m_171514_(48, 30).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 1.0f, 1.0f, true), PartPose.m_171423_((float)-0.4f, (float)-0.21f, (float)0.0f, (float)0.7330383f, (float)0.5235988f, (float)0.41887903f));
        PartDefinition birdHead = birdBody.m_171599_("birdHead", CubeListBuilder.m_171558_().m_171514_(44, 30).m_171506_(-0.5f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.5f, (float)-0.6f, (float)0.50823987f, (float)0.0f, (float)0.0f));
        PartDefinition birdLeftWing = birdBody.m_171599_("birdLeftWing", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171506_(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, false), PartPose.m_171423_((float)0.7f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)-0.39095375f, (float)0.50823987f));
        PartDefinition birdRightWing = birdBody.m_171599_("birdRightWing", CubeListBuilder.m_171558_().m_171514_(50, 30).m_171506_(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, true), PartPose.m_171423_((float)-0.7f, (float)-0.6f, (float)0.0f, (float)0.0f, (float)0.39095375f, (float)-0.50823987f));
        PartDefinition birdNose = birdHead.m_171599_("birdNose", CubeListBuilder.m_171558_().m_171514_(41, 31).m_171506_(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)-0.3f, (float)-0.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm2 = rightArm1.m_171599_("rightArm2", CubeListBuilder.m_171558_().m_171514_(35, 16).m_171506_(-1.5f, -1.5f, -1.5f, 3.0f, 5.0f, 3.0f, true), PartPose.m_171423_((float)0.0f, (float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.07819075f));
        PartDefinition rightArm3 = rightArm2.m_171599_("rightArm3", CubeListBuilder.m_171558_().m_171514_(52, 13).m_171506_(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, true), PartPose.m_171423_((float)1.0f, (float)5.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.039095376f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ImmutableList.of((Object)this.body).forEach(modelRenderer -> modelRenderer.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
        if (!this.leftArm1.f_104207_) {
            pPoseStack.m_85836_();
            pPoseStack.m_85837_((double)this.body.f_104200_ / 16.0, (double)this.body.f_104201_ / 16.0, (double)this.body.f_104202_ / 16.0);
            pPoseStack.m_85837_(0.35, -0.2, 0.0);
            this.birdBody.m_104301_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            pPoseStack.m_85849_();
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    public void setupAnim(GuardianFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float pAgeInTicks, float netHeadYaw, float headPitch) {
        this.showModels(pEntity);
        byte lives = pEntity.getLives();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104205_ = 0.0f;
        this.rightLeg1.f_104205_ = 0.16f;
        this.rightArm1.f_104205_ = 0.19f;
        if (pEntity.isSitting()) {
            this.rightLeg1.f_104203_ = this.toRads(-90.0f);
            this.leftLeg1.f_104203_ = this.toRads(-90.0f);
            this.leftArm1.f_104203_ = this.toRads(-30.0f);
            this.rightArm1.f_104203_ = this.toRads(-30.0f);
            this.leftArm2.f_104203_ = this.toRads(-30.0f);
            this.rightArm2.f_104203_ = this.toRads(-30.0f);
            this.leftArm3.f_104203_ = this.toRads(-30.0f);
            this.rightArm3.f_104203_ = this.toRads(-30.0f);
        } else {
            this.rightLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.5f;
            this.leftLeg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.leftArm2.f_104203_ = 0.0f;
            this.rightArm2.f_104203_ = 0.0f;
            this.leftArm3.f_104203_ = 0.0f;
            this.rightArm3.f_104203_ = 0.0f;
        }
        if (pEntity.isPartying()) {
            this.leftArm1.f_104203_ = -pAgeInTicks / 10.0f;
            this.rightArm1.f_104203_ = -pAgeInTicks / 10.0f;
            this.head.f_104204_ = pAgeInTicks / 10.0f;
        } else if (!pEntity.isSitting()) {
            this.rightArm1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.5f;
            this.leftArm1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.5f;
        }
        if (lives == 3) {
            this.body.f_104205_ = this.toRads(-20.0f);
            this.rightLeg1.f_104205_ = this.toRads(20.0f);
            this.rightArm1.f_104205_ = this.toRads(20.0f);
        }
        this.birdHead.f_104204_ = netHeadYaw * ((float)Math.PI / 180) * 0.4f;
        this.birdHead.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.4f + this.toRads(30.0f);
        if (lives > 4) {
            this.birdLeftLeg.f_104201_ = -(Mth.m_14031_((float)(pAgeInTicks / 2.0f)) + 1.0f) * 0.1f - 0.21f;
            this.birdRightLeg.f_104201_ = -(Mth.m_14031_((float)(pAgeInTicks / 2.0f + (float)Math.PI)) + 1.0f) * 0.1f - 0.21f;
            if (pAgeInTicks % 100.0f < 20.0f) {
                float wingProgress = pAgeInTicks % 100.0f % 20.0f;
                this.birdLeftWing.f_104205_ = this.toRads(20.0f) + Mth.m_14031_((float)(wingProgress / 20.0f * this.toRads(360.0f) * 2.0f)) * this.toRads(25.0f);
                this.birdRightWing.f_104205_ = this.toRads(-20.0f) - Mth.m_14031_((float)(wingProgress / 20.0f * this.toRads(360.0f) * 2.0f)) * this.toRads(25.0f);
            }
            this.birdBody.f_104201_ = -2.9f;
        } else {
            this.birdLeftLeg.f_104201_ = -0.31f;
            this.birdRightLeg.f_104201_ = -0.31f;
            this.birdLeftWing.f_104205_ = this.toRads(20.0f) + Mth.m_14031_((float)(pAgeInTicks / 2.0f)) * this.toRads(25.0f);
            this.birdRightWing.f_104205_ = this.toRads(-20.0f) - Mth.m_14031_((float)(pAgeInTicks / 2.0f)) * this.toRads(25.0f);
            this.birdBody.f_104201_ = -2.9f - Mth.m_14031_((float)(pAgeInTicks / 2.0f)) * 0.4f;
            this.birdBody.f_104205_ = lives <= 3 ? 0.0f : 0.0f;
        }
    }

    private void showModels(GuardianFamiliarEntity entity) {
        boolean hasTree = entity.hasTree();
        byte lives = entity.getLives();
        this.tree1.f_104207_ = hasTree;
        this.tree2.f_104207_ = hasTree;
        this.birdBody.f_104207_ = entity.hasBird();
        this.leftArm1.f_104207_ = lives > 4;
        this.leftLeg1.f_104207_ = lives > 3;
        this.rightLeg1.f_104207_ = lives > 2;
        this.rightArm1.f_104207_ = lives > 1;
    }
}

