/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.utils;

import cn.mcmod_mmf.mmlib.Main;
import cn.mcmod_mmf.mmlib.client.RenderUtils;
import cn.mcmod_mmf.mmlib.client.model.pojo.BedrockModelPOJO;
import cn.mcmod_mmf.mmlib.utils.DataGenUtil;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtil {
    public static final HashMap<ResourceLocation, BedrockModelPOJO> MODEL_MAP = Maps.newHashMap();

    @OnlyIn(value=Dist.CLIENT)
    public static void loadModel(ResourceLocation modelLocation, JsonElement element) {
        BedrockModelPOJO pojo = (BedrockModelPOJO)DataGenUtil.DATA_GSON.fromJson(element, BedrockModelPOJO.class);
        if (pojo.getFormatVersion() == null) {
            Main.getLogger().error("Failed to load model: {}, it's not a Bedrock Model!", (Object)modelLocation);
            return;
        }
        if (pojo.getFormatVersion().equals("1.10.0")) {
            if (pojo.getGeometryModelLegacy() != null) {
                Main.getLogger().info("Loaded 1.10.0 version model : {}", (Object)modelLocation);
                MODEL_MAP.put(modelLocation, pojo);
                return;
            }
            Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
            return;
        }
        if (pojo.getFormatVersion().equals("1.12.0")) {
            if (pojo.getGeometryModelNew() != null) {
                MODEL_MAP.put(modelLocation, pojo);
                Main.getLogger().info("Loaded 1.12.0 version model : {}", (Object)modelLocation);
                return;
            }
            Main.getLogger().warn("{} model file don't have model field", (Object)modelLocation);
            return;
        }
        Main.getLogger().error("{} model version is not 1.10.0 or 1.12.0", (Object)modelLocation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BedrockModelPOJO getModelPOJO(ResourceLocation modelLocation) {
        if (MODEL_MAP.containsKey(modelLocation)) {
            return MODEL_MAP.get(modelLocation);
        }
        return null;
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        RenderSystem.m_69478_();
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType()).getStillTexture());
        RenderUtils.setColorRGBA(IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType()).getTintColor(fluidStack));
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        do {
            int currentHeight = Math.min(sprite.m_118408_(), height);
            height -= currentHeight;
            float v2 = sprite.m_118393_((double)((float)(16 * currentHeight) / (float)sprite.m_118408_()));
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.m_118405_(), width2);
                width2 -= currentWidth;
                float u2 = sprite.m_118367_((double)((float)(16 * currentWidth) / (float)sprite.m_118405_()));
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_((double)x2, (double)y, (double)depth).m_7421_(u1, v1).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)x2, (double)(y + currentHeight), (double)depth).m_7421_(u1, v2).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).m_7421_(u2, v2).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)y, (double)depth).m_7421_(u2, v1).m_6122_(255, 255, 255, 255).m_5752_();
                tessellator.m_85914_();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
        RenderSystem.m_69461_();
    }

    public static float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }
}

