/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client.model.bedrock;

import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockCube;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockPolygon;
import cn.mcmod_mmf.mmlib.client.model.bedrock.BedrockVertex;
import cn.mcmod_mmf.mmlib.client.model.pojo.FaceItem;
import cn.mcmod_mmf.mmlib.client.model.pojo.FaceUVsItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.core.Direction;

public class BedrockCubePerFace
implements BedrockCube {
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;
    private final BedrockPolygon[] polygons;

    public BedrockCubePerFace(float x, float y, float z, float width, float height, float depth, float delta, float texWidth, float texHeight, FaceUVsItem faces) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + width;
        this.maxY = y + height;
        this.maxZ = z + depth;
        this.polygons = new BedrockPolygon[6];
        float xEnd = x + width;
        float yEnd = y + height;
        float zEnd = z + depth;
        BedrockVertex vertex1 = new BedrockVertex(x -= delta, y -= delta, z -= delta, 0.0f, 0.0f);
        BedrockVertex vertex2 = new BedrockVertex(xEnd += delta, y, z, 0.0f, 8.0f);
        BedrockVertex vertex3 = new BedrockVertex(xEnd, yEnd += delta, z, 8.0f, 8.0f);
        BedrockVertex vertex4 = new BedrockVertex(x, yEnd, z, 8.0f, 0.0f);
        BedrockVertex vertex5 = new BedrockVertex(x, y, zEnd += delta, 0.0f, 0.0f);
        BedrockVertex vertex6 = new BedrockVertex(xEnd, y, zEnd, 0.0f, 8.0f);
        BedrockVertex vertex7 = new BedrockVertex(xEnd, yEnd, zEnd, 8.0f, 8.0f);
        BedrockVertex vertex8 = new BedrockVertex(x, yEnd, zEnd, 8.0f, 0.0f);
        this.polygons[2] = this.getTexturedQuad(new BedrockVertex[]{vertex6, vertex5, vertex1, vertex2}, texWidth, texHeight, Direction.DOWN, faces);
        this.polygons[3] = this.getTexturedQuad(new BedrockVertex[]{vertex3, vertex4, vertex8, vertex7}, texWidth, texHeight, Direction.UP, faces);
        this.polygons[1] = this.getTexturedQuad(new BedrockVertex[]{vertex1, vertex5, vertex8, vertex4}, texWidth, texHeight, Direction.WEST, faces);
        this.polygons[4] = this.getTexturedQuad(new BedrockVertex[]{vertex2, vertex1, vertex4, vertex3}, texWidth, texHeight, Direction.NORTH, faces);
        this.polygons[0] = this.getTexturedQuad(new BedrockVertex[]{vertex6, vertex2, vertex3, vertex7}, texWidth, texHeight, Direction.EAST, faces);
        this.polygons[5] = this.getTexturedQuad(new BedrockVertex[]{vertex5, vertex6, vertex7, vertex8}, texWidth, texHeight, Direction.SOUTH, faces);
    }

    private BedrockPolygon getTexturedQuad(BedrockVertex[] positionsIn, float texWidth, float texHeight, Direction direction, FaceUVsItem faces) {
        FaceItem face = faces.getFace(direction);
        float u1 = face.getUv()[0];
        float v1 = face.getUv()[1];
        float u2 = u1 + face.getUvSize()[0];
        float v2 = v1 + face.getUvSize()[1];
        return new BedrockPolygon(positionsIn, u1, v1, u2, v2, texWidth, texHeight, false, direction);
    }

    @Override
    public void compile(PoseStack.Pose pose, VertexConsumer consumer, int texU, int texV, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        for (BedrockPolygon polygon : this.polygons) {
            Vector3f vector3f = polygon.normal.m_122281_();
            vector3f.m_122249_(matrix3f);
            float nx = vector3f.m_122239_();
            float ny = vector3f.m_122260_();
            float nz = vector3f.m_122269_();
            for (BedrockVertex vertex : polygon.vertices) {
                float x = vertex.pos.m_122239_() / 16.0f;
                float y = vertex.pos.m_122260_() / 16.0f;
                float z = vertex.pos.m_122269_() / 16.0f;
                Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
                vector4f.m_123607_(matrix4f);
                consumer.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, vertex.u, vertex.v, texV, texU, nx, ny, nz);
            }
        }
    }
}

