/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class RenderUtils {
    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
    }

    public static void setup(ResourceLocation texture, float red, float green, float blue, float alpha) {
        RenderUtils.bindTexture(texture);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void setup(ResourceLocation texture) {
        RenderUtils.setup(texture, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderFluidStack(int x, int y, int width, int height, float depth, FluidStack fluidStack) {
        RenderSystem.m_69478_();
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType()).getStillTexture());
        RenderUtils.setColorRGBA(IClientFluidTypeExtensions.of((FluidType)fluid.getFluidType()).getTintColor(fluidStack));
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        do {
            int currentHeight = Math.min(sprite.m_118408_(), height);
            height -= currentHeight;
            float v2 = sprite.m_118393_((double)((float)(16 * currentHeight) / (float)sprite.m_118408_()));
            int x2 = x;
            int width2 = width;
            do {
                int currentWidth = Math.min(sprite.m_118405_(), width2);
                width2 -= currentWidth;
                float u2 = sprite.m_118367_((double)((float)(16 * currentWidth) / (float)sprite.m_118405_()));
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_((double)x2, (double)y, (double)depth).m_7421_(u1, v1).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)x2, (double)(y + currentHeight), (double)depth).m_7421_(u1, v2).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)(y + currentHeight), (double)depth).m_7421_(u2, v2).m_6122_(255, 255, 255, 255).m_5752_();
                bufferbuilder.m_5483_((double)(x2 + currentWidth), (double)y, (double)depth).m_7421_(u2, v1).m_6122_(255, 255, 255, 255).m_5752_();
                tessellator.m_85914_();
                x2 += currentWidth;
            } while (width2 > 0);
            y += currentHeight;
        } while (height > 0);
        RenderSystem.m_69461_();
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtils.alpha(color) / 255.0f;
        float r = (float)RenderUtils.red(color) / 255.0f;
        float g = (float)RenderUtils.green(color) / 255.0f;
        float b = (float)RenderUtils.blue(color) / 255.0f;
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }
}

