/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.data.IntValueRange;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigDecimal;
import org.zeith.hammerlib.util.configured.types.ConfigInteger;
import org.zeith.hammerlib.util.java.functions.Function3;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.net.PacketSyncPanelData;
import org.zeith.solarflux.panels.SolarPanelInstance;

public class SolarPanel
implements ItemLike {
    private final SolarPanelData delegateDataBase;
    public final String name;
    private SolarPanelData delegateData;
    private SolarPanelData networkData;
    private String compatMod;
    public List<Consumer<RegisterRecipesEvent>> recipes = new ArrayList<Consumer<RegisterRecipesEvent>>();
    public final boolean isCustom;
    private SolarPanelBlock block;
    private LanguageData langs;

    protected SolarPanel(String name, SolarPanelData data, boolean isCustom) {
        this.delegateData = this.delegateDataBase = data;
        this.name = (isCustom ? "custom_" : "") + name;
        this.isCustom = isCustom;
    }

    public SolarPanelData getPanelData() {
        return this.networkData != null ? this.networkData : this.delegateData;
    }

    public SolarPanelData getDelegateData() {
        return this.delegateData;
    }

    public SolarPanel register() {
        if (SolarPanelsSF.PANELS.containsKey(this.name)) {
            throw new IllegalArgumentException("Solar panel with id " + this.name + " already exists.");
        }
        SolarPanelsSF.PANELS.put(this.name, this);
        return this;
    }

    @ApiStatus.Internal
    public SolarPanel setCompatMod(String compatMod) {
        this.compatMod = compatMod;
        return this;
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public void configureBase(ConfigCategory category) {
        this.delegateData = new SolarPanelData(category, this);
    }

    protected SolarPanelBlock createBlock() {
        return new SolarPanelBlock(this, new ResourceLocation("solarflux", "sp_" + this.name));
    }

    public SolarPanelBlock getBlock() {
        if (this.block == null) {
            this.block = this.createBlock();
        }
        return this.block;
    }

    public Supplier<Block> getBlockSupplier() {
        return this::getBlock;
    }

    public Item m_5456_() {
        return this.getBlock().m_5456_();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static Builder customBuilder() {
        Builder b = new Builder();
        b.custom = true;
        return b;
    }

    public LanguageData langBuilder() {
        return new LanguageData(this);
    }

    public boolean hasLang() {
        return this.langs != null;
    }

    public LanguageData getLang() {
        return this.langs;
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder(this);
    }

    public float computeSunIntensity(ISolarPanelTile solar) {
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.level().m_46490_(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return Mth.m_14036_((float)(multiplicator * Mth.m_14089_((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    @ApiStatus.Internal
    public void recipes(RegisterRecipesEvent helper) {
        if (this.recipes != null) {
            this.recipes.forEach(c -> c.accept(helper));
        }
    }

    public SolarPanelInstance createInstance(ISolarPanelTile tile) {
        SolarPanelInstance inst = new SolarPanelInstance();
        inst.delegate = this.name;
        inst.infoDelegate = this;
        inst.reset();
        return inst;
    }

    public void accept(SolarPanelInstance t) {
        SolarPanelData data = this.getPanelData();
        t.gen = data.generation;
        t.cap = data.capacity;
        t.transfer = data.transfer;
        t.delegate = this.name;
    }

    public void handle(PacketSyncPanelData packet) {
        this.networkData = packet.getData();
    }

    public static class SolarPanelData {
        public final long generation;
        public final long capacity;
        public final long transfer;
        public final float height;

        @ApiStatus.Internal
        public SolarPanelData(FriendlyByteBuf buf) {
            this.generation = buf.readLong();
            this.capacity = buf.readLong();
            this.transfer = buf.readLong();
            this.height = buf.readFloat();
        }

        @ApiStatus.Internal
        private SolarPanelData(long generation, long capacity, long transfer, float height) {
            this.generation = generation;
            this.capacity = capacity;
            this.transfer = transfer;
            this.height = height;
        }

        public SolarPanelData(ConfigCategory cat, SolarPanel base) {
            this.generation = ((ConfigInteger)cat.getElement(ConfiguredLib.INT, "Generation Rate")).withRange(IntValueRange.rangeClosed((long)1L, (long)Long.MAX_VALUE)).withDefault(base.delegateDataBase.generation).withComment("How much FE does this solar panel produce per tick?").getValue().longValue();
            this.transfer = ((ConfigInteger)cat.getElement(ConfiguredLib.INT, "Transfer Rate")).withRange(IntValueRange.rangeClosed((long)1L, (long)Long.MAX_VALUE)).withDefault(base.delegateDataBase.transfer).withComment("How much FE does this solar panel emit to other blocks, per tick?").getValue().longValue();
            this.capacity = ((ConfigInteger)cat.getElement(ConfiguredLib.INT, "Capacity")).withRange(IntValueRange.rangeClosed((long)1L, (long)Long.MAX_VALUE)).withDefault(base.delegateDataBase.capacity).withComment("How much FE does this solar panel store?").getValue().longValue();
            this.height = ((ConfigDecimal)cat.getElement(ConfiguredLib.DECIMAL, "Height")).withRange(DecimalValueRange.range((double)0.0, (double)16.0)).withDefault((double)(base.delegateDataBase.height * 16.0f)).withComment("How high is this solar panel?").getValue().floatValue() / 16.0f;
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeLong(this.generation);
            buf.writeLong(this.capacity);
            buf.writeLong(this.transfer);
            buf.writeFloat(this.height);
        }
    }

    public static class Builder {
        private String name;
        private Long generation;
        private Long capacity;
        private Long transfer;
        private float height = 0.375f;
        private boolean custom = false;

        private Builder() {
        }

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder copyEnergy(SolarPanel panel) {
            return this.generation(panel.delegateData.generation).transfer(panel.delegateData.transfer).capacity(panel.delegateData.capacity);
        }

        public Builder copyEnergy(SolarPanel panel, double multiplier) {
            return this.generation((double)panel.delegateData.generation * multiplier).transfer((double)panel.delegateData.transfer * multiplier).capacity((double)panel.delegateData.capacity * multiplier);
        }

        public Builder height(float f) {
            this.height = f;
            return this;
        }

        public Builder generation(Number n) {
            this.generation = n.longValue();
            return this;
        }

        public Builder generation(String s) {
            this.generation = Long.parseLong(s);
            return this;
        }

        public Builder capacity(Number n) {
            this.capacity = n.longValue();
            return this;
        }

        public Builder capacity(String s) {
            this.capacity = Long.parseLong(s);
            return this;
        }

        public Builder transfer(Number n) {
            this.transfer = n.longValue();
            return this;
        }

        public Builder transfer(String s) {
            this.transfer = Long.parseLong(s);
            return this;
        }

        public SolarPanel build() {
            return this.build((Function3<String, SolarPanelData, Boolean, SolarPanel>)((Function3)SolarPanel::new));
        }

        public SolarPanel build(Function3<String, SolarPanelData, Boolean, SolarPanel> factory) {
            if (this.name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.generation == null) {
                throw new NullPointerException("generation == null");
            }
            if (this.capacity == null) {
                throw new NullPointerException("capacity == null");
            }
            if (this.transfer == null) {
                throw new NullPointerException("transfer == null");
            }
            return (SolarPanel)factory.apply((Object)this.name, (Object)new SolarPanelData(this.generation, this.capacity, this.transfer, this.height), (Object)this.custom);
        }

        public SolarPanel buildAndRegister() {
            return this.build().register();
        }
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final SolarPanel panel;

        @ApiStatus.Internal
        private LanguageData(SolarPanel panel) {
            this.panel = panel;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equalsIgnoreCase("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public SolarPanel build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.panel.langs = this;
            return this.panel;
        }
    }

    public static class RecipeBuilder {
        final SolarPanel panel;
        final List<Consumer<ShapedRecipeBuilder>> handlers = new ArrayList<Consumer<ShapedRecipeBuilder>>();

        @ApiStatus.Internal
        private RecipeBuilder(SolarPanel panel) {
            this.panel = panel;
        }

        public RecipeBuilder shape(String ... strings) {
            this.handlers.add(b -> b.shape(strings));
            return this;
        }

        public RecipeBuilder bind(String ch, Object output) {
            if (ch.length() != 1) {
                throw new IllegalArgumentException(ch + " is not a single character!");
            }
            this.handlers.add(b -> b.map(ch.charAt(0), output));
            return this;
        }

        public SolarPanel build() {
            return this.build(1);
        }

        public SolarPanel build(int amount) {
            int lineNumber = Thread.currentThread().getStackTrace()[2].getLineNumber();
            this.panel.recipes.add(evt -> {
                ResourceLocation prn = this.panel.getBlock().getRegistryName();
                ShapedRecipeBuilder builder = (ShapedRecipeBuilder)((ShapedRecipeBuilder)evt.shaped().id(new ResourceLocation(prn.m_135827_(), "builtin/generated_" + prn.m_135815_() + "_x_" + amount + "_ln" + lineNumber))).result(new ItemStack((ItemLike)this.panel, amount));
                this.handlers.forEach(c -> c.accept(builder));
                builder.register();
            });
            return this.panel;
        }
    }
}

