/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.init;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.script.ScriptException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModInfo;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.util.configured.ConfigFile;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.data.IntValueRange;
import org.zeith.hammerlib.util.configured.types.ConfigBoolean;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigDecimal;
import org.zeith.hammerlib.util.configured.types.ConfigInteger;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarScriptEngine;

@SimplyRegister
public class SolarPanelsSF {
    public static final Map<String, SolarPanel> PANELS = new HashMap<String, SolarPanel>();
    public static double LOOSE_ENERGY;
    public static float RAIN_MULTIPLIER;
    public static float THUNDER_MULTIPLIER;
    public static float CAPACITY_UPGRADE_INCREASE;
    public static float EFFICIENCY_UPGRADE_INCREASE;
    public static float TRANSFER_RATE_UPGRADE_INCREASE;
    public static float BLOCK_CHARGING_UPGRADE_RANGE;
    public static int TRAVERSAL_UPGRADE_RANGE;
    public static final SolarPanel[] CORE_PANELS;
    public static File CONFIG_DIR;
    public static final List<ResourceLocation> RECIPE_KEYS;
    private static final List<ResourceLocation> ENABLED_RECIPES;

    public static Stream<SolarPanel> listPanels() {
        return PANELS.values().stream();
    }

    public static Stream<SolarPanelBlock> listPanelBlocks() {
        return SolarPanelsSF.listPanels().map(SolarPanel::getBlock);
    }

    @SimplyRegister
    public static void registerPanels(BiConsumer<ResourceLocation, Block> reg) {
        SolarPanelsSF.listPanelBlocks().forEach(panel -> reg.accept(panel.getRegistryName(), (Block)panel));
    }

    public static void init() {
        File custom_panels;
        File textures;
        CONFIG_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "solarflux");
        File solarflux = CONFIG_DIR;
        if (!solarflux.isDirectory()) {
            solarflux.mkdirs();
        }
        int[] generations = new int[]{1, 8, 32, 128, 512, 2048, 8192, 32768};
        int[] transfers = new int[]{8, 64, 256, 1024, 4096, 16348, 65536, 262144};
        int[] capacities = new int[]{25000, 125000, 425000, 2000000, 8000000, 32000000, 64000000, 128000000};
        ConfigFile cfgs = ConfiguredLib.create((File)new File(solarflux, "main.cfg"), (boolean)true);
        cfgs.withComment("Main configuration file for Solar Flux Reborn!\nTo implement custom panels, look for the custom_panels.js file!");
        for (int i = 0; i < CORE_PANELS.length; ++i) {
            int generation = generations[i];
            int transfer = transfers[i];
            int capacity = capacities[i];
            SolarPanelsSF.CORE_PANELS[i] = SolarPanel.builder().name(Integer.toString(i + 1)).generation(generation).transfer(transfer).capacity(capacity).buildAndRegister();
        }
        ConfigCategory main = cfgs.setupCategory("Main");
        LOOSE_ENERGY = ((ConfigDecimal)main.getElement(ConfiguredLib.DECIMAL, "Pickup Energy Loss")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)100.0)).withDefault(5.0).withComment("How much energy (percent) will get lost while picking up the solar panel?").getValueF();
        RAIN_MULTIPLIER = ((ConfigDecimal)main.getElement(ConfiguredLib.DECIMAL, "Rain Multiplier")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)1.0)).withDefault((double)0.6f).withComment("How much energy should be generated when it is raining? 0 - nothing, 1 - full power.").getValueF();
        THUNDER_MULTIPLIER = ((ConfigDecimal)main.getElement(ConfiguredLib.DECIMAL, "Thunder Multiplier")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)1.0)).withDefault((double)0.4f).withComment("How much energy should be generated when it is thundering? 0 - nothing, 1 - full power.").getValueF();
        ConfigCategory upgrades = cfgs.setupCategory("Upgrades");
        BLOCK_CHARGING_UPGRADE_RANGE = ((ConfigDecimal)upgrades.getElement(ConfiguredLib.DECIMAL, "Block Charging Upgrade Range")).withRange(DecimalValueRange.min((double)0.0)).withDefault(16.0).withComment("How far should the Block Charging Upgrade reach?").getValueF();
        BLOCK_CHARGING_UPGRADE_RANGE *= BLOCK_CHARGING_UPGRADE_RANGE;
        TRAVERSAL_UPGRADE_RANGE = ((ConfigInteger)upgrades.getElement(ConfiguredLib.INT, "Traversal Upgrade Range")).withRange(IntValueRange.range((long)0L, (long)16L)).withDefault(5).withComment("How far should the Traversal Upgrade reach?").getValue().intValue();
        TRAVERSAL_UPGRADE_RANGE *= TRAVERSAL_UPGRADE_RANGE;
        CAPACITY_UPGRADE_INCREASE = ((ConfigDecimal)upgrades.getElement(ConfiguredLib.DECIMAL, "Capacity Upgrade Bonus")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)100.0)).withDefault(10.0).withComment("How much should each capacity upgrade add, in percent?").getValueF() / 100.0f;
        EFFICIENCY_UPGRADE_INCREASE = ((ConfigDecimal)upgrades.getElement(ConfiguredLib.DECIMAL, "Efficiency Upgrade Bonus")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)100.0)).withDefault(5.0).withComment("How much should each efficiency upgrade add, in percent?").getValueF() / 100.0f;
        TRANSFER_RATE_UPGRADE_INCREASE = ((ConfigDecimal)upgrades.getElement(ConfiguredLib.DECIMAL, "Transfer Rate Upgrade Bonus")).withRange(DecimalValueRange.rangeClosed((double)0.0, (double)100.0)).withDefault(15.0).withComment("How much should each transfer rate upgrade add, in percent?").getValueF() / 100.0f;
        if (cfgs.hasChanged()) {
            cfgs.save();
        }
        if (!(textures = new File(solarflux, "textures")).isDirectory()) {
            textures.mkdirs();
            blocks = new File(textures, "blocks");
            if (!blocks.isDirectory()) {
                int r;
                InputStream in;
                FileOutputStream out;
                blocks.mkdirs();
                byte[] buf = new byte[768];
                try {
                    out = new FileOutputStream(new File(blocks, "example_base.png"));
                    try {
                        in = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/blocks/sp_example_base.png");
                        try {
                            while ((r = in.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    out = new FileOutputStream(new File(blocks, "example_top.png"));
                    try {
                        in = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/blocks/sp_example_top.png");
                        try {
                            while ((r = in.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(items = new File(textures, "items")).isDirectory()) {
                items.mkdirs();
                buf = new byte[768];
                try {
                    out = new FileOutputStream(new File(items, "example.png"));
                    try {
                        in = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/items/_example.png");
                        try {
                            int r;
                            while ((r = in.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            blocks = new File(textures, "blocks");
            if (!blocks.isDirectory()) {
                blocks.mkdirs();
                SolarPanelsSF.move(textures, blocks);
            }
            if (!(items = new File(textures, "items")).isDirectory()) {
                items.mkdirs();
                buf = new byte[768];
                try {
                    out = new FileOutputStream(new File(items, "example.png"));
                    try {
                        in = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/items/_example.png");
                        try {
                            int r;
                            while ((r = in.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    finally {
                        out.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!(custom_panels = new File(solarflux, "custom_panels.js")).isFile()) {
            try (FileOutputStream fos = new FileOutputStream(custom_panels);
                 InputStream in = SolarFlux.class.getResourceAsStream("/__custom_panels.js");){
                int r;
                byte[] buf = new byte[768];
                while ((r = in.read(buf)) > 0) {
                    fos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            SolarScriptEngine engine = new SolarScriptEngine(Files.readAllLines(custom_panels.toPath(), StandardCharsets.UTF_8).stream());
            engine.callFunction("init", new Object[0]);
        }
        catch (IOException | ReflectiveOperationException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private static void move(File dir, File to) {
        if (dir.isDirectory() && to.isDirectory() && !dir.getAbsolutePath().startsWith(to.getAbsolutePath())) {
            for (File f : dir.listFiles()) {
                if (f.getAbsolutePath().startsWith(to.getAbsolutePath())) continue;
                if (f.isFile()) {
                    f.renameTo(new File(to, f.getName()));
                    continue;
                }
                if (!f.isDirectory()) continue;
                File nd = new File(to, f.getName());
                if (!nd.isDirectory()) {
                    nd.mkdirs();
                }
                SolarPanelsSF.move(f, nd);
                f.delete();
            }
        }
    }

    public static void refreshConfigs() {
        ConfigFile panels = ConfiguredLib.create((File)new File(CONFIG_DIR, "panels.cfg"), (boolean)true);
        SolarPanelsSF.listPanels().forEach(i -> {
            ConfigCategory cat = i.isCustom ? panels.setupCategory("Solar Flux: Custom") : (i.getCompatMod() == null ? panels.setupCategory("Solar Flux") : panels.setupCategory(ModList.get().getMods().stream().filter(m -> m.getModId().equals(i.getCompatMod())).findFirst().map(IModInfo::getDisplayName).orElse(i.getCompatMod())));
            i.configureBase(cat.setupSubCategory(i.name));
        });
        if (panels.hasChanged()) {
            panels.save();
        }
        SolarPanelsSF.refreshRecipes();
    }

    public static void refreshRecipes() {
        ENABLED_RECIPES.clear();
        ConfigFile recipes = ConfiguredLib.create((File)new File(CONFIG_DIR, "recipes.cfg"), (boolean)true);
        ConfigCategory cat = recipes.setupCategory("recipes");
        RECIPE_KEYS.forEach(recipe -> {
            boolean enabled = ((ConfigBoolean)((ConfigBoolean)cat.getElement(ConfiguredLib.BOOLEAN, recipe.toString())).withDefault(true).withComment("Enable this recipe?")).getValue();
            if (enabled) {
                ENABLED_RECIPES.add((ResourceLocation)recipe);
            }
        });
        if (recipes.hasChanged()) {
            recipes.save();
        }
    }

    public static boolean isRecipeActive(ResourceLocation id) {
        return ENABLED_RECIPES.contains(id);
    }

    public static void indexRecipes(ResourceLocation ... ids) {
        RECIPE_KEYS.addAll(Arrays.asList(ids));
    }

    public static Ingredient getGeneratingSolars(long generation) {
        return Ingredient.m_43938_(SolarPanelsSF.listPanels().filter(sp -> sp.getDelegateData().generation == generation).map(SolarPanel::getBlock).map(ItemStack::new).map(Ingredient.ItemValue::new));
    }

    public static Ingredient getGeneratingSolars(SolarPanel as) {
        return SolarPanelsSF.getGeneratingSolars(as.getDelegateData().generation);
    }

    static {
        RAIN_MULTIPLIER = 0.6f;
        THUNDER_MULTIPLIER = 0.4f;
        CAPACITY_UPGRADE_INCREASE = 0.1f;
        EFFICIENCY_UPGRADE_INCREASE = 0.05f;
        TRANSFER_RATE_UPGRADE_INCREASE = 0.15f;
        BLOCK_CHARGING_UPGRADE_RANGE = 16.0f;
        TRAVERSAL_UPGRADE_RANGE = 5;
        CORE_PANELS = new SolarPanel[8];
        RECIPE_KEYS = new ArrayList<ResourceLocation>();
        ENABLED_RECIPES = new ArrayList<ResourceLocation>();
    }
}

