/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.armor.HeavyArmor;
import com.hollingsworth.arsnouveau.common.armor.LightArmor;
import com.hollingsworth.arsnouveau.common.armor.MediumArmor;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.items.AlchemistsCrown;
import com.hollingsworth.arsnouveau.common.items.AnnotatedCodex;
import com.hollingsworth.arsnouveau.common.items.BlankParchmentItem;
import com.hollingsworth.arsnouveau.common.items.CasterTome;
import com.hollingsworth.arsnouveau.common.items.Debug;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.DowsingRod;
import com.hollingsworth.arsnouveau.common.items.EarthEssence;
import com.hollingsworth.arsnouveau.common.items.EnchantersMirror;
import com.hollingsworth.arsnouveau.common.items.EnchantersShield;
import com.hollingsworth.arsnouveau.common.items.EnchantersSword;
import com.hollingsworth.arsnouveau.common.items.ExperienceGem;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.FireEssence;
import com.hollingsworth.arsnouveau.common.items.FlaskCannon;
import com.hollingsworth.arsnouveau.common.items.FormSpellArrow;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.JarOfLight;
import com.hollingsworth.arsnouveau.common.items.ManipulationEssence;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.common.items.PotionFlask;
import com.hollingsworth.arsnouveau.common.items.Present;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.RunicChalk;
import com.hollingsworth.arsnouveau.common.items.ScryCaster;
import com.hollingsworth.arsnouveau.common.items.ScryerScroll;
import com.hollingsworth.arsnouveau.common.items.SpellArrow;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellBow;
import com.hollingsworth.arsnouveau.common.items.SpellCrossbow;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.items.StableWarpScroll;
import com.hollingsworth.arsnouveau.common.items.StarbuncleShades;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.items.Wand;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.items.WixieHat;
import com.hollingsworth.arsnouveau.common.items.WornNotebook;
import com.hollingsworth.arsnouveau.common.items.curios.AbstractManaCurio;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfLevitation;
import com.hollingsworth.arsnouveau.common.items.curios.BeltOfUnstableGifts;
import com.hollingsworth.arsnouveau.common.items.curios.DiscountRing;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.items.curios.SummoningFocus;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.AllowItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.DenyItemScroll;
import com.hollingsworth.arsnouveau.common.items.itemscrolls.MimicItemScroll;
import com.hollingsworth.arsnouveau.common.items.summon_charms.AmethystGolemCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.BookwyrmCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.DrygmyCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.StarbuncleCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WhirlisprigCharm;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WixieCharm;
import com.hollingsworth.arsnouveau.common.perk.EmptyPerk;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import com.hollingsworth.arsnouveau.common.util.RegistryWrapper;
import com.hollingsworth.arsnouveau.setup.SoundRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class ItemsRegistry {
    public static FoodProperties SOURCE_BERRY_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 100), 1.0f).m_38765_().m_38767_();
    public static FoodProperties SOURCE_PIE_FOOD = new FoodProperties.Builder().m_38760_(9).m_38758_(0.9f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 1200, 1), 1.0f).m_38765_().m_38767_();
    public static FoodProperties SOURCE_ROLL_FOOD = new FoodProperties.Builder().m_38760_(8).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.MANA_REGEN_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
    public static FoodProperties MENDOSTEEN_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.RECOVERY_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
    public static FoodProperties BLASTING_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.BLAST_EFFECT.get(), 200), 1.0f).m_38765_().m_38767_();
    public static FoodProperties BASTION_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.DEFENCE_EFFECT.get(), 1200), 1.0f).m_38765_().m_38767_();
    public static FoodProperties FROSTAYA_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.6f).effect(() -> new MobEffectInstance((MobEffect)ModPotions.FREEZING_EFFECT.get(), 600), 1.0f).m_38765_().m_38767_();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_nouveau");
    public static final RegistryWrapper<RunicChalk> RUNIC_CHALK = ItemsRegistry.register("runic_chalk", () -> new RunicChalk());
    public static RegistryWrapper<SpellBook> NOVICE_SPELLBOOK = ItemsRegistry.register("novice_spell_book", () -> new SpellBook(SpellTier.ONE));
    public static RegistryWrapper<SpellBook> APPRENTICE_SPELLBOOK = ItemsRegistry.register("apprentice_spell_book", () -> new SpellBook(SpellTier.TWO));
    public static RegistryWrapper<SpellBook> ARCHMAGE_SPELLBOOK = ItemsRegistry.register("archmage_spell_book", () -> new SpellBook(SpellTier.THREE));
    public static RegistryWrapper<SpellBook> CREATIVE_SPELLBOOK = ItemsRegistry.register("creative_spell_book", () -> new SpellBook(SpellTier.CREATIVE));
    public static RegistryWrapper<Item> BLANK_GLYPH = ItemsRegistry.register("blank_glyph");
    public static RegistryWrapper<ModItem> BUCKET_OF_SOURCE = ItemsRegistry.register("bucket_of_source");
    public static RegistryWrapper<ModItem> MAGE_BLOOM = ItemsRegistry.register("magebloom", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.magebloom")));
    public static RegistryWrapper<ModItem> MAGE_FIBER = ItemsRegistry.register("magebloom_fiber");
    public static RegistryWrapper<ModItem> BLAZE_FIBER = ItemsRegistry.register("blaze_fiber");
    public static RegistryWrapper<ModItem> END_FIBER = ItemsRegistry.register("end_fiber");
    public static RegistryWrapper<ModItem> MUNDANE_BELT = ItemsRegistry.register("mundane_belt", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
    public static RegistryWrapper<JarOfLight> JAR_OF_LIGHT = ItemsRegistry.register("jar_of_light", () -> new JarOfLight());
    public static RegistryWrapper<BeltOfLevitation> BELT_OF_LEVITATION = ItemsRegistry.register("belt_of_levitation", () -> new BeltOfLevitation());
    public static RegistryWrapper<WornNotebook> WORN_NOTEBOOK = ItemsRegistry.register("worn_notebook", () -> new WornNotebook().withTooltip((Component)Component.m_237115_((String)"tooltip.worn_notebook")));
    public static RegistryWrapper<ModItem> RING_OF_POTENTIAL = ItemsRegistry.register("ring_of_potential", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
    public static RegistryWrapper<DiscountRing> RING_OF_LESSER_DISCOUNT = ItemsRegistry.register("ring_of_lesser_discount", () -> new DiscountRing(){

        @Override
        public int getManaDiscount() {
            return 10;
        }
    });
    public static RegistryWrapper<DiscountRing> RING_OF_GREATER_DISCOUNT = ItemsRegistry.register("ring_of_greater_discount", () -> new DiscountRing(){

        @Override
        public int getManaDiscount() {
            return 20;
        }
    });
    public static RegistryWrapper<BeltOfUnstableGifts> BELT_OF_UNSTABLE_GIFTS = ItemsRegistry.register("belt_of_unstable_gifts", () -> new BeltOfUnstableGifts());
    public static RegistryWrapper<WarpScroll> WARP_SCROLL = ItemsRegistry.register("warp_scroll", () -> new WarpScroll());
    public static RegistryWrapper<SpellParchment> SPELL_PARCHMENT = ItemsRegistry.register("spell_parchment", () -> new SpellParchment());
    public static RegistryWrapper<BookwyrmCharm> BOOKWYRM_CHARM = ItemsRegistry.register("bookwyrm_charm", () -> new BookwyrmCharm().withTooltip("ars_nouveau.tooltip.bookwyrm"));
    public static RegistryWrapper<DominionWand> DOMINION_ROD = ItemsRegistry.register("dominion_wand", () -> new DominionWand());
    public static RegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_BOOST = ItemsRegistry.register("amulet_of_mana_boost", () -> new AbstractManaCurio(){

        @Override
        public int getMaxManaBoost(ItemStack i) {
            return 50;
        }
    });
    public static RegistryWrapper<AbstractManaCurio> AMULET_OF_MANA_REGEN = ItemsRegistry.register("amulet_of_mana_regen", () -> new AbstractManaCurio(){

        @Override
        public int getManaRegenBonus(ItemStack i) {
            return 3;
        }
    });
    public static RegistryWrapper<ModItem> DULL_TRINKET = ItemsRegistry.register("dull_trinket", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.dull")));
    public static RegistryWrapper<StarbuncleCharm> STARBUNCLE_CHARM = ItemsRegistry.register("starbuncle_charm", () -> new StarbuncleCharm());
    public static RegistryWrapper<Debug> debug = ItemsRegistry.register("debug", () -> new Debug());
    public static RegistryWrapper<ModItem> STARBUNCLE_SHARD = ItemsRegistry.register("starbuncle_shards", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.starbuncle_shard")));
    public static RegistryWrapper<StarbuncleShades> STARBUNCLE_SHADES = ItemsRegistry.register("starbuncle_shades", () -> new StarbuncleShades().withTooltip((Component)Component.m_237115_((String)"tooltip.starbuncle_shades")));
    public static RegistryWrapper<WhirlisprigCharm> WHIRLISPRIG_CHARM = ItemsRegistry.register("whirlisprig_charm", () -> new WhirlisprigCharm());
    public static RegistryWrapper<ModItem> WHIRLISPRIG_SHARDS = ItemsRegistry.register("whirlisprig_shards", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.whirlisprig_shard")));
    public static RegistryWrapper<ModItem> SOURCE_GEM = ItemsRegistry.register("source_gem", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.source_gem")));
    public static RegistryWrapper<AllowItemScroll> ALLOW_ITEM_SCROLL = ItemsRegistry.register("allow_scroll", () -> new AllowItemScroll());
    public static RegistryWrapper<DenyItemScroll> DENY_ITEM_SCROLL = ItemsRegistry.register("deny_scroll", () -> new DenyItemScroll());
    public static RegistryWrapper<MimicItemScroll> MIMIC_ITEM_SCROLL = ItemsRegistry.register("mimic_scroll", () -> new MimicItemScroll());
    public static RegistryWrapper<BlankParchmentItem> BLANK_PARCHMENT = ItemsRegistry.register("blank_parchment", () -> new BlankParchmentItem());
    public static RegistryWrapper<Wand> WAND = ItemsRegistry.register("wand", () -> new Wand());
    public static RegistryWrapper<VoidJar> VOID_JAR = ItemsRegistry.register("void_jar", () -> new VoidJar());
    public static RegistryWrapper<WixieCharm> WIXIE_CHARM = ItemsRegistry.register("wixie_charm", () -> new WixieCharm());
    public static RegistryWrapper<ModItem> WIXIE_SHARD = ItemsRegistry.register("wixie_shards", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wixie_shard")));
    public static RegistryWrapper<SpellBow> SPELL_BOW = ItemsRegistry.register("spell_bow", () -> new SpellBow());
    public static RegistryWrapper<SpellArrow> AMPLIFY_ARROW = ItemsRegistry.register("amplify_arrow", () -> new SpellArrow(AugmentAmplify.INSTANCE, 2));
    public static RegistryWrapper<FormSpellArrow> SPLIT_ARROW = ItemsRegistry.register("split_arrow", () -> new FormSpellArrow(AugmentSplit.INSTANCE, 2));
    public static RegistryWrapper<FormSpellArrow> PIERCE_ARROW = ItemsRegistry.register("pierce_arrow", () -> new FormSpellArrow(AugmentPierce.INSTANCE, 2));
    public static RegistryWrapper<ModItem> WILDEN_HORN = ItemsRegistry.register("wilden_horn", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_horn")));
    public static RegistryWrapper<ModItem> WILDEN_SPIKE = ItemsRegistry.register("wilden_spike", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_spike")));
    public static RegistryWrapper<ModItem> WILDEN_WING = ItemsRegistry.register("wilden_wing", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.wilden_wing")));
    public static RegistryWrapper<PotionFlask> POTION_FLASK = ItemsRegistry.register("potion_flask", () -> new PotionFlask(){

        @Override
        @NotNull
        public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
            return effectInstance;
        }
    }.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask")));
    public static RegistryWrapper<PotionFlask> POTION_FLASK_AMPLIFY = ItemsRegistry.register("potion_flask_amplify", () -> new PotionFlask(){

        @Override
        public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
            return new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() / 2, effectInstance.m_19564_() + 1);
        }
    }.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask_amplify")));
    public static RegistryWrapper<PotionFlask> POTION_FLASK_EXTEND_TIME = ItemsRegistry.register("potion_flask_extend_time", () -> new PotionFlask(){

        @Override
        public MobEffectInstance getEffectInstance(MobEffectInstance effectInstance) {
            return new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_() + effectInstance.m_19557_() / 2, effectInstance.m_19564_());
        }
    }.withTooltip((Component)Component.m_237115_((String)"tooltip.potion_flask_extend_time")));
    public static RegistryWrapper<ExperienceGem> EXPERIENCE_GEM = ItemsRegistry.register("experience_gem", () -> new ExperienceGem(){

        @Override
        public int getValue() {
            return 3;
        }
    }.withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.exp_gem")));
    public static RegistryWrapper<ExperienceGem> GREATER_EXPERIENCE_GEM = ItemsRegistry.register("greater_experience_gem", () -> new ExperienceGem(){

        @Override
        public int getValue() {
            return 12;
        }
    }.withTooltip((Component)Component.m_237115_((String)"ars_nouveau.tooltip.exp_gem")));
    public static RegistryWrapper<EnchantersSword> ENCHANTERS_SWORD = ItemsRegistry.register("enchanters_sword", () -> new EnchantersSword((Tier)Tiers.NETHERITE, 3, -2.4f));
    public static RegistryWrapper<EnchantersShield> ENCHANTERS_SHIELD = ItemsRegistry.register("enchanters_shield", () -> new EnchantersShield());
    public static RegistryWrapper<CasterTome> CASTER_TOME = ItemsRegistry.register("caster_tome", () -> new CasterTome());
    public static RegistryWrapper<DrygmyCharm> DRYGMY_CHARM = ItemsRegistry.register("drygmy_charm", () -> new DrygmyCharm());
    public static RegistryWrapper<ModItem> DRYGMY_SHARD = ItemsRegistry.register("drygmy_shard", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.drygmy_shard")));
    public static RegistryWrapper<ModItem> WILDEN_TRIBUTE = ItemsRegistry.register("wilden_tribute", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.wilden_tribute").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE))).withRarity(Rarity.EPIC));
    public static RegistryWrapper<SummoningFocus> SUMMONING_FOCUS = ItemsRegistry.register("summon_focus", () -> new SummoningFocus());
    public static RegistryWrapper<ShapersFocus> SHAPERS_FOCUS = ItemsRegistry.register("shapers_focus", () -> new ShapersFocus(ItemsRegistry.defaultItemProperties().m_41487_(1)).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.shapers_focus")));
    public static RegistryWrapper<ModItem> SOURCE_BERRY_PIE = ItemsRegistry.register("source_berry_pie", () -> new ModItem(ItemsRegistry.defaultItemProperties().m_41489_(SOURCE_PIE_FOOD)).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.source_food")));
    public static RegistryWrapper<ModItem> SOURCE_BERRY_ROLL = ItemsRegistry.register("source_berry_roll", () -> new ModItem(ItemsRegistry.defaultItemProperties().m_41489_(SOURCE_ROLL_FOOD)).withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.source_food")));
    public static RegistryWrapper<EnchantersMirror> ENCHANTERS_MIRROR = ItemsRegistry.register("enchanters_mirror", () -> new EnchantersMirror(ItemsRegistry.defaultItemProperties().m_41487_(1)));
    public static RegistryWrapper<LightArmor> NOVICE_BOOTS = ItemsRegistry.register("novice_boots", () -> new LightArmor(EquipmentSlot.FEET));
    public static RegistryWrapper<LightArmor> NOVICE_LEGGINGS = ItemsRegistry.register("novice_leggings", () -> new LightArmor(EquipmentSlot.LEGS));
    public static RegistryWrapper<LightArmor> NOVICE_ROBES = ItemsRegistry.register("novice_robes", () -> new LightArmor(EquipmentSlot.CHEST));
    public static RegistryWrapper<LightArmor> NOVICE_HOOD = ItemsRegistry.register("novice_hood", () -> new LightArmor(EquipmentSlot.HEAD));
    public static RegistryWrapper<MediumArmor> APPRENTICE_BOOTS = ItemsRegistry.register("apprentice_boots", () -> new MediumArmor(EquipmentSlot.FEET));
    public static RegistryWrapper<MediumArmor> APPRENTICE_LEGGINGS = ItemsRegistry.register("apprentice_leggings", () -> new MediumArmor(EquipmentSlot.LEGS));
    public static RegistryWrapper<MediumArmor> APPRENTICE_ROBES = ItemsRegistry.register("apprentice_robes", () -> new MediumArmor(EquipmentSlot.CHEST));
    public static RegistryWrapper<MediumArmor> APPRENTICE_HOOD = ItemsRegistry.register("apprentice_hood", () -> new MediumArmor(EquipmentSlot.HEAD));
    public static RegistryWrapper<HeavyArmor> ARCHMAGE_BOOTS = ItemsRegistry.register("archmage_boots", () -> new HeavyArmor(EquipmentSlot.FEET));
    public static RegistryWrapper<HeavyArmor> ARCHMAGE_LEGGINGS = ItemsRegistry.register("archmage_leggings", () -> new HeavyArmor(EquipmentSlot.LEGS));
    public static RegistryWrapper<HeavyArmor> ARCHMAGE_ROBES = ItemsRegistry.register("archmage_robes", () -> new HeavyArmor(EquipmentSlot.CHEST));
    public static RegistryWrapper<HeavyArmor> ARCHMAGE_HOOD = ItemsRegistry.register("archmage_hood", () -> new HeavyArmor(EquipmentSlot.HEAD));
    public static RegistryWrapper<DowsingRod> DOWSING_ROD = ItemsRegistry.register("dowsing_rod", () -> new DowsingRod().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.dowsing_rod")));
    public static RegistryWrapper<ModItem> ABJURATION_ESSENCE = ItemsRegistry.register("abjuration_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<ModItem> CONJURATION_ESSENCE = ItemsRegistry.register("conjuration_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<ModItem> AIR_ESSENCE = ItemsRegistry.register("air_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<EarthEssence> EARTH_ESSENCE = ItemsRegistry.register("earth_essence", () -> new EarthEssence().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<FireEssence> FIRE_ESSENCE = ItemsRegistry.register("fire_essence", () -> new FireEssence().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<ModItem> MANIPULATION_ESSENCE = ItemsRegistry.register("manipulation_essence", () -> new ManipulationEssence().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<ModItem> WATER_ESSENCE = ItemsRegistry.register("water_essence", () -> new ModItem().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.essences")));
    public static RegistryWrapper<AmethystGolemCharm> AMETHYST_GOLEM_CHARM = ItemsRegistry.register("amethyst_golem_charm", () -> new AmethystGolemCharm().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.amethyst_charm")));
    public static RegistryWrapper<AnnotatedCodex> ANNOTATED_CODEX = ItemsRegistry.register("annotated_codex", () -> new AnnotatedCodex());
    public static RegistryWrapper<ScryerScroll> SCRYER_SCROLL = ItemsRegistry.register("scryer_scroll", () -> new ScryerScroll().withTooltip((Component)Component.m_237115_((String)"tooltip.ars_nouveau.scryer_scroll")));
    public static RegistryWrapper<ModItem> WIXIE_HAT = ItemsRegistry.register("wixie_hat", () -> new WixieHat().withTooltip("tooltip.ars_nouveau.wixie_hat"));
    public static RegistryWrapper<ModItem> ALCHEMISTS_CROWN = ItemsRegistry.register("alchemists_crown", () -> new AlchemistsCrown(ItemsRegistry.defaultItemProperties().m_41487_(1)));
    public static RegistryWrapper<ModItem> SPLASH_LAUNCHER = ItemsRegistry.register("splash_flask_cannon", () -> new FlaskCannon.SplashLauncher(ItemsRegistry.defaultItemProperties().m_41487_(1)));
    public static RegistryWrapper<ModItem> LINGERING_LAUNCHER = ItemsRegistry.register("lingering_flask_cannon", () -> new FlaskCannon.LingeringLauncher(ItemsRegistry.defaultItemProperties().m_41487_(1)));
    public static PerkItem BLANK_THREAD;
    public static RegistryWrapper<Item> FIREL_DISC;
    public static RegistryWrapper<Item> STARBY_GIFY;
    public static RegistryWrapper<Item> SPELL_CROSSBOW;
    public static RegistryWrapper<Item> STABLE_WARP_SCROLL;
    public static RegistryWrapper<ScryCaster> SCRY_CASTER;

    public static RegistryWrapper register(String name, Supplier<? extends Item> item) {
        return new RegistryWrapper(ITEMS.register(name, item));
    }

    public static RegistryWrapper register(String name) {
        return ItemsRegistry.register(name, () -> new ModItem());
    }

    public static void onItemRegistry(IForgeRegistry<Item> registry) {
        ArsNouveauAPI api = ArsNouveauAPI.getInstance();
        for (Map.Entry<ResourceLocation, Supplier<Glyph>> glyphEntry : api.getGlyphItemMap().entrySet()) {
            Glyph glyph = glyphEntry.getValue().get();
            registry.register(glyphEntry.getKey(), (Object)glyph);
            glyph.spellPart.glyphItem = glyph;
        }
        for (AbstractRitual ritual : api.getRitualMap().values()) {
            RitualTablet tablet = new RitualTablet(ritual);
            registry.register(ritual.getRegistryName(), (Object)tablet);
            api.getRitualItemMap().put(ritual.getRegistryName(), tablet);
        }
        for (AbstractFamiliarHolder holder : api.getFamiliarHolderMap().values()) {
            FamiliarScript script = new FamiliarScript(holder);
            api.getFamiliarScriptMap().put(holder.getRegistryName(), script);
            registry.register(holder.getRegistryName(), (Object)script);
        }
        for (IPerk perk : api.getPerkMap().values()) {
            PerkItem perkItem = new PerkItem(perk);
            api.getPerkItemMap().put(perk.getRegistryName(), perkItem);
            registry.register(perk.getRegistryName(), (Object)perkItem);
            if (!(perk instanceof EmptyPerk)) continue;
            BLANK_THREAD = perkItem;
        }
        registry.register("drygmy_se", (Object)new ForgeSpawnEggItem(ModEntities.ENTITY_DRYGMY, 10051392, 16770611, ItemsRegistry.defaultItemProperties()));
        registry.register("starbuncle_se", (Object)new ForgeSpawnEggItem(ModEntities.STARBUNCLE_TYPE, 16757299, 16770611, ItemsRegistry.defaultItemProperties()));
        registry.register("whirlisprig_se", (Object)new ForgeSpawnEggItem(ModEntities.WHIRLISPRIG_TYPE, 0x77FF33, 0xFFFB00, ItemsRegistry.defaultItemProperties()));
        registry.register("wilden_hunter_se", (Object)new ForgeSpawnEggItem(ModEntities.WILDEN_HUNTER, 0xFDFDFD, 13281663, ItemsRegistry.defaultItemProperties()));
        registry.register("wilden_guardian_se", (Object)new ForgeSpawnEggItem(ModEntities.WILDEN_GUARDIAN, 0xFFFFFF, 16752128, ItemsRegistry.defaultItemProperties()));
        registry.register("wilden_stalker_se", (Object)new ForgeSpawnEggItem(ModEntities.WILDEN_STALKER, 10183948, 15669272, ItemsRegistry.defaultItemProperties()));
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties().m_41491_(ArsNouveau.itemGroup);
    }

    static {
        FIREL_DISC = ItemsRegistry.register("music_disc_aria_biblio", () -> new RecordItem(9, () -> (SoundEvent)SoundRegistry.ARIA_BIBLIO.get(), ItemsRegistry.defaultItemProperties().m_41487_(1).m_41497_(Rarity.RARE), 4800));
        STARBY_GIFY = ItemsRegistry.register("starby_gift", () -> new Present(ItemsRegistry.defaultItemProperties().m_41497_(Rarity.EPIC)));
        SPELL_CROSSBOW = ItemsRegistry.register("spell_crossbow", () -> new SpellCrossbow(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        STABLE_WARP_SCROLL = ItemsRegistry.register("stable_warp_scroll", () -> new StableWarpScroll(ItemsRegistry.defaultItemProperties().m_41487_(1)));
        SCRY_CASTER = ItemsRegistry.register("enchanters_eye", () -> new ScryCaster(ItemsRegistry.defaultItemProperties().m_41487_(1)));
    }
}

