/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.InteractType;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.SlotReference;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.StackUtil;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectName
extends AbstractEffect {
    public static EffectName INSTANCE = new EffectName();

    private EffectName() {
        super(GlyphLib.EffectNameID, "Name");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Component newName = this.getName(world, shooter, spellStats, spellContext, resolver);
        rayTraceResult.m_82443_().m_6593_(newName);
        Entity entity = rayTraceResult.m_82443_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21530_();
        } else {
            entity = rayTraceResult.m_82443_();
            if (entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                item.m_32055_().m_41714_(newName);
            }
        }
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (this.isRealPlayer((Entity)shooter) && player.equals((Object)rayTraceResult.m_82443_())) {
                ItemStack offhand = player.m_21206_();
                offhand.m_41714_(newName);
            }
        }
    }

    public Component getName(Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Player player;
        ItemStack stack;
        MutableComponent newName = null;
        InventoryManager manager = spellContext.getCaster().getInvManager();
        SlotReference slotRef = manager.findItem(i -> i.m_41720_() == Items.f_42656_, InteractType.EXTRACT);
        if (slotRef.getHandler() != null) {
            ItemStack stack2 = slotRef.getHandler().getStackInSlot(slotRef.getSlot());
            newName = stack2.m_41611_().m_6879_();
        }
        if (newName == null && this.isRealPlayer((Entity)shooter) && shooter instanceof Player && (stack = StackUtil.getHeldCasterToolOrEmpty(player = (Player)shooter)) != ItemStack.f_41583_ && stack.m_41783_() != null) {
            ISpellCaster caster = CasterUtil.getCaster(stack);
            newName = Component.m_237113_((String)caster.getSpellName());
        }
        return newName;
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Component name = this.getName(world, shooter, spellStats, spellContext, resolver);
        BlockEntity blockEntity = world.m_7702_(rayTraceResult.m_82425_());
        if (blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity nameable = (BaseContainerBlockEntity)blockEntity;
            nameable.m_58638_(name);
            BlockPos pos = rayTraceResult.m_82425_();
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
            nameable.m_6596_();
            return;
        }
        for (Entity entity : world.m_45933_(null, new AABB(rayTraceResult.m_82425_()).m_82400_(0.08))) {
            entity.m_6593_(name);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_21530_();
                continue;
            }
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            item.m_32055_().m_41714_(name);
        }
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Names an entity after the set Spell Name. Targeting a block will name nearby entities or name inventory blocks directly if possible. Targeting with Self will name the held offhand item. Can be overridden with a name tag in the hotbar.";
    }
}

