/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class RitualAnimalSummoning
extends AbstractRitual {
    private MobCategory category = MobCategory.CREATURE;
    private WeightedRandomList<MobSpawnSettings.SpawnerData> mobs;

    private WeightedRandomList<MobSpawnSettings.SpawnerData> getMobs() {
        return WeightedRandomList.m_146328_(((Biome)this.getWorld().m_204166_(this.getPos()).get()).m_47518_().m_151798_(this.category).m_146338_().stream().filter(mob -> !mob.f_48404_.m_204039_(EntityTags.ANIMAL_SUMMON_BLACKLIST)).collect(Collectors.toList()));
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.tile == null || this.getWorld() == null || this.getPos() == null) {
            return;
        }
        this.mobs = this.getMobs();
    }

    @Override
    protected void tick() {
        if (this.mobs == null) {
            this.mobs = this.getMobs();
        }
        if (this.getWorld().m_46467_() % 20L == 0L) {
            this.incrementProgress();
        }
        if (this.getWorld().m_46467_() % 60L == 0L && !this.getWorld().f_46443_) {
            Optional opt = this.mobs.m_216829_(this.rand);
            opt.ifPresent(animal -> {
                BlockPos summonPos = this.getPos().m_7494_().m_122030_(this.rand.m_188503_(3) - this.rand.m_188503_(6)).m_122013_(this.rand.m_188503_(3) - this.rand.m_188503_(6));
                Mob mob = (Mob)animal.f_48404_.m_20615_(this.getWorld());
                if (mob == null) {
                    return;
                }
                this.summon(mob, summonPos);
            });
            if (this.getProgress() >= 15) {
                this.setFinished();
            }
        }
    }

    public void summon(Mob mob, BlockPos pos) {
        mob.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        mob.f_19853_.m_7967_((Entity)mob);
        Level level = mob.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_6907_()) {
                serverLevel.m_8624_(player, (ParticleOptions)ParticleTypes.f_123810_, false, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.1, (double)pos.m_123343_(), 10, 0.1, 0.1, 0.1, 0.05);
            }
        }
    }

    @Override
    public String getLangName() {
        return "Summon Animals";
    }

    @Override
    public String getLangDescription() {
        return "Summon a random variety of wild animals native to the biome it's in.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", RitualLib.ANIMAL_SUMMON);
    }
}

