/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.carbuncle;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToPosGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.event.OpenChestEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class TakeItemGoal<T extends StarbyTransportBehavior>
extends GoToPosGoal<T> {
    public TakeItemGoal(Starbuncle starbuncle, T behavior) {
        super(starbuncle, behavior, () -> starbuncle.getHeldStack().m_41619_());
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.TAKING_ITEM;
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return ((StarbyTransportBehavior)this.behavior).isPositionValidTake(pos);
    }

    @Override
    @Nullable
    public BlockPos getDestination() {
        return ((StarbyTransportBehavior)this.behavior).getValidTakePos();
    }

    @Override
    public boolean onDestinationReached() {
        Level world = this.starbuncle.f_19853_;
        BlockEntity tileEntity = world.m_7702_(this.targetPos);
        if (tileEntity == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakePosBroken", "Take Tile Broken"));
            return true;
        }
        IItemHandler iItemHandler = ((StarbyTransportBehavior)this.behavior).getItemCapFromTile(tileEntity);
        if (iItemHandler == null) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("NoItemHandler", "No item handler at " + this.targetPos.toString()));
            return true;
        }
        for (int j = 0; j < iItemHandler.getSlots() && this.starbuncle.getHeldStack().m_41619_(); ++j) {
            int count;
            if (iItemHandler.getStackInSlot(j).m_41619_() || (count = ((StarbyTransportBehavior)this.behavior).getMaxTake(iItemHandler.getStackInSlot(j))) <= 0) continue;
            this.starbuncle.setHeldStack(iItemHandler.extractItem(j, count, false));
            this.starbuncle.addGoalDebug(this, new DebugEvent("SetHeld", "Taking " + count + "x " + this.starbuncle.getHeldStack().m_41786_().getString() + " from " + this.targetPos.toString()));
            this.starbuncle.f_19853_.m_6263_(null, this.starbuncle.m_20185_(), this.starbuncle.m_20186_(), this.starbuncle.m_20189_(), SoundEvents.f_12019_, this.starbuncle.m_5720_(), 1.0f, 1.0f);
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)world;
            try {
                OpenChestEvent event = new OpenChestEvent(serverLevel, this.targetPos, 20);
                event.open();
                EventQueue.getServerInstance().addEvent(event);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.starbuncle.getHeldStack().m_41619_()) {
            this.starbuncle.addGoalDebug(this, new DebugEvent("TakeFromChest", "No items to take? Cancelling goal."));
        }
        return true;
    }
}

