/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.mob_jar.JarBehaviorRegistry;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobJar
extends TickableModBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final Property<Integer> LIGHT_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)15);
    public static final Property<Boolean> POWERED = BlockStateProperties.f_61448_;
    private static BlockBehaviour.Properties props = MobJar.defaultProperties().m_60955_().m_60953_(state -> (Integer)state.m_61143_(LIGHT_LEVEL));
    public static final VoxelShape shape = Stream.of(Block.m_49796_((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.m_49796_((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public MobJar() {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_(POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        SpawnEggItem spawnEggItem;
        EntityType type;
        Entity entity;
        ItemStack stack;
        Item item;
        MobJarTile tile = (MobJarTile)pLevel.m_7702_(pPos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (tile.getEntity() == null && !pLevel.f_46443_ && (item = (stack = pPlayer.m_21120_(pHand)).m_41720_()) instanceof SpawnEggItem && (entity = (type = (spawnEggItem = (SpawnEggItem)item).m_43228_(null)).m_20615_(pLevel)) != null) {
            tile.setEntityData(entity);
            stack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        if (!(tile.getEntity() == null || tile.getEntity() instanceof PlayerRideable || JarBehaviorRegistry.containsEntity(tile.getEntity()) || tile.getEntity() instanceof ContainerEntity)) {
            pPlayer.m_36157_(tile.getEntity(), pHand);
        }
        tile.dispatchBehavior(behavior -> behavior.use(pState, pLevel, pPos, pPlayer, pHand, pHit, tile));
        tile.updateBlock();
        return InteractionResult.SUCCESS;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        context.m_43725_().m_186460_(context.m_8083_(), (Block)this, 1);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_(POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_46753_(context.m_8083_())));
    }

    public BlockState m_7417_(BlockState stateIn, Direction side, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MobJarTile) {
            MobJarTile tile = (MobJarTile)blockEntity;
            int light = tile.calculateLight();
            if ((Integer)pState.m_61143_(LIGHT_LEVEL) != light) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
            }
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag;
        if (!pLevel.f_46443_ && (flag = ((Boolean)pState.m_61143_(POWERED)).booleanValue()) != pLevel.m_46753_(pPos)) {
            if (!flag) {
                MobJarTile tile = (MobJarTile)pLevel.m_7702_(pPos);
                tile.dispatchBehavior(behavior -> behavior.onRedstonePower(tile));
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_(POWERED), 2);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        MobJarTile tile = (MobJarTile)worldIn.m_7702_(pos);
        AtomicInteger power = new AtomicInteger();
        tile.dispatchBehavior(behavior -> power.set(Math.max(power.get(), behavior.getAnalogPower(tile))));
        return Math.min(power.get(), 15);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BlockStateProperties.f_61362_, LIGHT_LEVEL, POWERED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MobJarTile(pPos, pState);
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        BlockEntity blockEntity = pBlockAccess.m_7702_(pPos);
        if (blockEntity instanceof MobJarTile) {
            MobJarTile jarTile = (MobJarTile)blockEntity;
            AtomicInteger power = new AtomicInteger();
            jarTile.dispatchBehavior(behavior -> power.set(Math.max(power.get(), behavior.getSignalPower(jarTile))));
            return Math.min(power.get(), 15);
        }
        return 0;
    }
}

