/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.mob_jar;

import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.hollingsworth.arsnouveau.common.lib.EntityTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;

public class JarBehavior<T extends Entity> {
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        T entity = this.entityFromJar(tile);
        if (entity.m_6095_().m_204039_(EntityTags.INTERACT_JAR_BLACKLIST)) {
            return;
        }
        ItemStack handItem = player.m_21120_(handIn);
        if (entity instanceof IForgeShearable) {
            IForgeShearable shearable = (IForgeShearable)entity;
            Item item = handItem.m_41720_();
            if (item instanceof ShearsItem) {
                ShearsItem shearsItem = (ShearsItem)item;
                shearsItem.m_6880_(handItem, player, (LivingEntity)shearable, handIn);
                this.syncClient(tile);
                return;
            }
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_6096_(player, handIn);
            this.syncClient(tile);
        }
    }

    public void tick(MobJarTile tile) {
    }

    public void syncClient(MobJarTile tile) {
        tile.updateBlock();
    }

    @NotNull
    public T entityFromJar(MobJarTile tile) {
        return (T)tile.getEntity();
    }

    public boolean isEntityBaby(Entity entity) {
        if (!(entity instanceof AgeableMob)) {
            return false;
        }
        AgeableMob ageableMob = (AgeableMob)entity;
        return ageableMob.m_6162_();
    }

    public Vec3 scaleOffset(MobJarTile pBlockEntity) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public Vec3 translate(MobJarTile pBlockEntity) {
        return new Vec3(0.0, 0.0, 0.0);
    }

    public boolean shouldUsePartialTicks(MobJarTile pBlockEntity) {
        return false;
    }

    public int lightLevel(MobJarTile pBlockEntity) {
        return 0;
    }

    public int getAnalogPower(MobJarTile tile) {
        return tile.getEntity() == null ? 0 : 15;
    }

    public void onRedstonePower(MobJarTile tile) {
        T entity = this.entityFromJar(tile);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_8032_();
        }
    }

    public int getSignalPower(MobJarTile tile) {
        return 0;
    }

    public void getTooltip(MobJarTile tile, List<Component> tooltips) {
    }
}

