/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.texture;

import com.google.common.hash.HashCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.ExistingFileHelper;

public class TextureGenerator {
    private final DataGenerator generator;
    private final ExistingFileHelper fileHelper;

    public TextureGenerator(DataGenerator generator, ExistingFileHelper fileHelper) {
        this.generator = generator;
        this.fileHelper = fileHelper;
    }

    public void save(CachedOutput output, ResourceLocation id, BufferedImage image) throws IOException {
        Path path = this.generator.m_123916_().resolve("assets").resolve(id.m_135827_()).resolve(id.m_135815_());
        this.save(output, image, path);
    }

    public void save(CachedOutput output, BufferedImage image, Path path) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", byteOut);
        byte[] data = byteOut.toByteArray();
        output.m_213871_(path, data, HashCode.fromBytes((byte[])data));
    }

    public BufferedImage newImage(int width, int height, int scale) {
        return new BufferedImage(width * scale, height * scale, 2);
    }

    public BufferedImage loadImage(ResourceLocation image) {
        BufferedImage bufferedImage;
        block9: {
            if (!this.fileHelper.exists(image, PackType.CLIENT_RESOURCES)) {
                throw new RuntimeException("Texture does not exists: " + image);
            }
            InputStream in = this.fileHelper.getResource(image, PackType.CLIENT_RESOURCES).m_215507_();
            try {
                bufferedImage = ImageIO.read(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load texture: " + image, e);
                }
            }
            in.close();
        }
        return bufferedImage;
    }
}

