/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.datagen.patchouli.content;

import java.util.List;
import java.util.stream.Stream;
import org.moddingx.libx.datagen.provider.patchouli.page.Content;
import org.moddingx.libx.datagen.provider.patchouli.page.PageBuilder;

public final class CompositeContent
implements Content {
    private final List<Content> children;

    public CompositeContent(List<Content> children) {
        this(children.stream());
    }

    private CompositeContent(Stream<Content> children) {
        this.children = children.flatMap(c -> {
            if (c instanceof CompositeContent) {
                CompositeContent composite = (CompositeContent)c;
                return composite.children.stream();
            }
            return Stream.of(c);
        }).toList();
    }

    @Override
    public void pages(PageBuilder builder) {
        this.children.forEach(c -> c.pages(builder));
    }

    @Override
    public Content with(Content next) {
        if (this.children.isEmpty()) {
            return next;
        }
        return new CompositeContent(Stream.concat(this.children.stream().limit(this.children.size() - 1), Stream.of(this.children.get(this.children.size() - 1).with(next))));
    }
}

