/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.texture;

import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.datagen.provider.texture.Textures;
import org.moddingx.libx.mod.ModX;

public class TextureBuilder {
    private final ModX mod;
    private final Function<ResourceLocation, BufferedImage> textureLoader;
    private int scale;
    private final Map<ResourceLocation, Pair<BufferedImage, Integer>> images;

    public TextureBuilder(ModX mod, Function<ResourceLocation, BufferedImage> textureLoader) {
        this.mod = mod;
        this.textureLoader = textureLoader;
        this.scale = 1;
        this.images = new HashMap<ResourceLocation, Pair<BufferedImage, Integer>>();
    }

    public TextureBuilder addTexture(String loc, int defaultSize) {
        return this.addTexture(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addImage(String loc, int defaultSize) {
        return this.addImage(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addTexture(ResourceLocation loc, int defaultSize) {
        return this.addTexture(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addImage(ResourceLocation loc, int defaultSize) {
        return this.addImage(loc, defaultSize, defaultSize);
    }

    public TextureBuilder addTexture(String loc, int defaultWidth, int defaultHeight) {
        return this.addTexture(this.mod.resource(loc), defaultWidth, defaultHeight);
    }

    public TextureBuilder addImage(String loc, int defaultWidth, int defaultHeight) {
        return this.addImage(this.mod.resource(loc), defaultWidth, defaultHeight);
    }

    public TextureBuilder addTexture(ResourceLocation loc, int defaultWidth, int defaultHeight) {
        return this.addImage(new ResourceLocation(loc.m_135827_(), "textures/" + loc.m_135815_() + ".png"), defaultWidth, defaultHeight);
    }

    public TextureBuilder addImage(ResourceLocation loc, int defaultWidth, int defaultHeight) {
        if (!TextureBuilder.isPowerOfTwo(defaultWidth)) {
            throw new IllegalArgumentException("Invalid default width for texture " + loc + ": " + defaultWidth + " is not a power of two.");
        }
        if (!TextureBuilder.isPowerOfTwo(defaultHeight)) {
            throw new IllegalArgumentException("Invalid default height for texture " + loc + ": " + defaultHeight + " is not a power of two.");
        }
        if (!this.images.containsKey(loc)) {
            int imageScaleByHeight;
            BufferedImage image = this.textureLoader.apply(loc);
            if (!TextureBuilder.isPowerOfTwo(image.getWidth())) {
                throw new IllegalStateException("Invalid texture width for texture " + loc + ": " + image.getWidth() + " is not a power of two.");
            }
            if (!TextureBuilder.isPowerOfTwo(image.getHeight())) {
                throw new IllegalStateException("Invalid texture height for texture " + loc + ": " + image.getHeight() + " is not a power of two.");
            }
            if (image.getWidth() < defaultWidth || image.getHeight() < defaultHeight) {
                throw new IllegalStateException("Invalid texture: " + loc + ": Image is smaller than default");
            }
            int imageScaleByWidth = image.getWidth() / defaultWidth;
            if (imageScaleByWidth != (imageScaleByHeight = image.getHeight() / defaultHeight)) {
                int gcd = BigInteger.valueOf(defaultWidth).gcd(BigInteger.valueOf(defaultHeight)).intValue();
                throw new IllegalStateException("Texture " + loc + " has invalid aspect ratio, expected " + defaultWidth / gcd + ":" + defaultHeight / gcd);
            }
            this.images.put(loc, (Pair<BufferedImage, Integer>)Pair.of((Object)image, (Object)imageScaleByWidth));
            this.scale = TextureBuilder.lcm(this.scale, imageScaleByWidth);
        }
        return this;
    }

    public Textures build() {
        return new Textures(this.mod, this.textureLoader, this.scale, this.images);
    }

    private static boolean isPowerOfTwo(int number) {
        return number > 0 && (number & number - 1) == 0;
    }

    private static int gcd(int a, int b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValue();
    }

    private static int lcm(int a, int b) {
        return a * b / TextureBuilder.gcd(a, b);
    }
}

