/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StoneButtonBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import org.moddingx.libx.annotation.meta.SuperChainRequired;
import org.moddingx.libx.base.decoration.DecoratedBlock;
import org.moddingx.libx.base.decoration.DecorationContext;
import org.moddingx.libx.base.decoration.SignAccess;
import org.moddingx.libx.impl.base.decoration.DecorationTypes;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public interface DecorationType<T> {
    public static final DecorationType<DecoratedBlock> BASE = DecorationTypes.BASE;
    public static final DecorationType<? extends SlabBlock> SLAB = DecorationTypes.SLAB;
    public static final DecorationType<? extends StairBlock> STAIRS = DecorationTypes.STAIRS;
    public static final DecorationType<? extends WallBlock> WALL = DecorationTypes.WALL;
    public static final DecorationType<? extends FenceBlock> FENCE = DecorationTypes.FENCE;
    public static final DecorationType<? extends FenceGateBlock> FENCE_GATE = DecorationTypes.FENCE_GATE;
    public static final DecorationType<? extends WoodButtonBlock> WOOD_BUTTON = DecorationTypes.WOOD_BUTTON;
    public static final DecorationType<? extends StoneButtonBlock> STONE_BUTTON = DecorationTypes.STONE_BUTTON;
    public static final DecorationType<? extends PressurePlateBlock> WOOD_PRESSURE_PLATE = DecorationTypes.WOOD_PRESSURE_PLATE;
    public static final DecorationType<? extends PressurePlateBlock> STONE_PRESSURE_PLATE = DecorationTypes.STONE_PRESSURE_PLATE;
    public static final DecorationType<? extends DoorBlock> DOOR = DecorationTypes.DOOR;
    public static final DecorationType<? extends TrapDoorBlock> TRAPDOOR = DecorationTypes.TRAPDOOR;
    public static final DecorationType<? extends SignAccess> SIGN = DecorationTypes.SIGN;

    public String name();

    public DecorationElement<? super T, T> element(ModX var1, DecorationContext var2, DecoratedBlock var3);

    @SuperChainRequired
    default public void registerAdditional(ModX mod, DecorationContext context, DecoratedBlock block, T element, RegistrationContext registrationContext, Registerable.EntryCollector builder) {
    }

    public record DecorationElement<R, T extends R>(@Nullable ResourceKey<? extends Registry<R>> registry, T element) {
        public void registerTo(Registerable.EntryCollector builder) {
            builder.register(this.registry(), this.element());
        }
    }
}

